/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FsIndex_flat;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.jcas.cas.TOP;

public class FsIterator_subtypes_snapshot<T extends FeatureStructure>
implements LowLevelIterator<T>,
Comparator<FeatureStructure> {
    private final T[] snapshot;
    private int pos = 0;
    private final boolean is_unordered;
    private final LowLevelIndex<T> indexForComparator;
    private final boolean isNotUimaIndexSource;
    private final Comparator<TOP> comparatorMaybeNoTypeWithoutId;

    public FsIterator_subtypes_snapshot(FsIndex_flat<T> flatIndex, Comparator<TOP> comparatorMaybeNoTypeWithoutId) {
        this.indexForComparator = flatIndex;
        this.snapshot = flatIndex.getFlatArray();
        this.is_unordered = flatIndex.getIndexingStrategy() != 0;
        this.comparatorMaybeNoTypeWithoutId = comparatorMaybeNoTypeWithoutId;
        this.isNotUimaIndexSource = false;
    }

    public FsIterator_subtypes_snapshot(T[] snapshot, LowLevelIndex<T> index, boolean is_unordered, Comparator<TOP> comparatorMaybeNoTypeWithoutId) {
        this.indexForComparator = index;
        this.snapshot = snapshot;
        this.is_unordered = is_unordered;
        this.comparatorMaybeNoTypeWithoutId = comparatorMaybeNoTypeWithoutId;
        this.isNotUimaIndexSource = true;
    }

    @Override
    public boolean isValid() {
        return 0 <= this.pos && this.pos < this.snapshot.length;
    }

    @Override
    public T get() throws NoSuchElementException {
        if (this.isValid()) {
            return this.snapshot[this.pos];
        }
        throw new NoSuchElementException();
    }

    @Override
    public T getNvc() {
        return this.snapshot[this.pos];
    }

    @Override
    public void moveToNext() {
        if (this.isValid()) {
            ++this.pos;
        }
    }

    @Override
    public void moveToNextNvc() {
        ++this.pos;
    }

    @Override
    public void moveToPrevious() {
        if (this.isValid()) {
            --this.pos;
        }
    }

    @Override
    public void moveToPreviousNvc() {
        --this.pos;
    }

    @Override
    public void moveToFirstNoReinit() {
        this.pos = 0;
    }

    @Override
    public void moveToLastNoReinit() {
        this.pos = this.snapshot.length - 1;
    }

    @Override
    public void moveToNoReinit(FeatureStructure fs) {
        if (this.is_unordered) {
            int i;
            for (i = 0; i < this.snapshot.length && this.compare((FeatureStructure)this.snapshot[i], fs) != 0; ++i) {
            }
            this.pos = i;
        } else {
            int c = Arrays.binarySearch(this.snapshot, 0, this.snapshot.length, fs, this);
            if (c < 0) {
                this.pos = -c - 1;
            } else {
                --c;
                while (c >= 0 && this.compare((FeatureStructure)this.snapshot[c], fs) == 0) {
                    --c;
                }
                this.pos = c + 1;
            }
        }
    }

    @Override
    public FSIterator<T> copy() {
        FsIterator_subtypes_snapshot it = new FsIterator_subtypes_snapshot(this.snapshot, this.indexForComparator, this.is_unordered, this.comparatorMaybeNoTypeWithoutId);
        it.pos = this.pos;
        return it;
    }

    @Override
    public int ll_indexSizeMaybeNotCurrent() {
        return this.snapshot.length;
    }

    @Override
    public int ll_maxAnnotSpan() {
        return this.indexForComparator.ll_maxAnnotSpan();
    }

    @Override
    public LowLevelIndex<T> ll_getIndex() {
        return this.indexForComparator;
    }

    @Override
    public int compare(FeatureStructure fs1, FeatureStructure fs2) {
        return null == this.comparatorMaybeNoTypeWithoutId ? Integer.compare(fs1._id(), fs2._id()) : this.comparatorMaybeNoTypeWithoutId.compare((TOP)fs1, (TOP)fs2);
    }

    @Override
    public boolean isIndexesHaveBeenUpdated() {
        return false;
    }

    @Override
    public boolean maybeReinitIterator() {
        return false;
    }

    @Override
    public Comparator<TOP> getComparator() {
        return this.comparatorMaybeNoTypeWithoutId;
    }

    @Override
    public int size() {
        return this.snapshot.length;
    }
}

