/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.uima.internal.util.Common_hash_support;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.internal.util.Misc;

public class Obj2IntIdentityHashMap<T>
extends Common_hash_support {
    private final T removedMarker;
    private final Class<T> componentType;
    private T[] keys;
    private int[] values;

    public Obj2IntIdentityHashMap(Class<T> clazz, T removedMarker) {
        this(12, clazz, removedMarker);
    }

    public Obj2IntIdentityHashMap(int initialCapacity, Class<T> clazz, T removedMarker) {
        super(initialCapacity);
        this.componentType = clazz;
        this.removedMarker = removedMarker;
        this.newTable(this.initialCapacity);
    }

    private int findPosition(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("null is an invalid key");
        }
        return this.findPosition(Misc.hashInt(System.identityHashCode(obj)), i -> this.keys[i] == null || this.keys[i] == obj, i -> this.keys[i] == this.removedMarker);
    }

    public boolean contains(Object obj) {
        return this.componentType.isAssignableFrom(obj.getClass()) ? this.find(obj) != -1 : false;
    }

    public int find(T obj) {
        if (obj == null || this.size() == 0) {
            return -1;
        }
        int pos = this.findPosition(obj);
        return obj == this.keys[pos] ? pos : -1;
    }

    public int get(T obj) {
        if (obj == null || this.size() == 0) {
            return 0;
        }
        int pos = this.findPosition(obj);
        return this.values[pos];
    }

    public int put(T obj, int value) {
        int i = this.findPosition(obj);
        if (this.keys[i] == obj) {
            int prevValue = this.values[i];
            this.values[i] = value;
            return prevValue;
        }
        if (this.found_removed != -1) {
            i = this.found_removed;
        }
        this.keys[i] = obj;
        this.values[i] = value;
        this.commonPutOrAddNotFound();
        return 0;
    }

    private void putInner(T obj, int value) {
        int i = this.findPosition(obj);
        assert (this.keys[i] == null);
        this.keys[i] = obj;
        this.values[i] = value;
    }

    public int remove(Object rawKey) {
        if (rawKey == null) {
            return 0;
        }
        int pos = this.findPosition(rawKey);
        int r = this.values[pos];
        if (rawKey == this.keys[pos]) {
            this.values[pos] = 0;
            this.keys[pos] = this.removedMarker;
            this.commonRemove();
        }
        return r;
    }

    public T[] getKeys() {
        Object[] r = (Object[])Array.newInstance(this.componentType, this.size());
        int i = 0;
        for (T key : this.keys) {
            if (key == null || key == this.removedMarker) continue;
            r[i++] = key;
        }
        return r;
    }

    public IntListIterator iterator() {
        return new Obj2IntIdentityHashMapIterator();
    }

    public String toString() {
        return String.format("%s [loadFactor=%s, initialCapacity=%s, sizeWhichTriggersExpansion=%s, size=%s, secondTimeShrinkable=%s%n keys=%s]", this.getClass().getName(), Float.valueOf(this.loadFactor), this.initialCapacity, this.sizeWhichTriggersExpansion, this.size(), this.secondTimeShrinkable, Arrays.toString(this.keys));
    }

    @Override
    protected boolean is_valid_key(int pos) {
        return this.keys[pos] != null && this.keys[pos] != this.removedMarker;
    }

    @Override
    protected int keys_length() {
        return this.keys.length;
    }

    @Override
    protected void newKeysAndValues(int capacity) {
        this.keys = (Object[])Array.newInstance(this.componentType, capacity);
        this.values = new int[capacity];
    }

    @Override
    protected void clearKeysAndValues() {
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, 0);
    }

    @Override
    protected void copy_to_new_table(int newCapacity, int oldCapacity, Common_hash_support.CommonCopyOld2New commonCopy) {
        Object[] oldKeys = this.keys;
        int[] oldValues = this.values;
        commonCopy.apply(i -> this.putInner(oldKeys[i], oldValues[i]), i -> oldKeys[i] != null && oldKeys[i] != this.removedMarker);
    }

    private class Obj2IntIdentityHashMapIterator
    implements IntListIterator {
        private int curPosition;
        private final int firstPosition;

        private Obj2IntIdentityHashMapIterator() {
            this.firstPosition = this.curPosition = Obj2IntIdentityHashMap.this.moveToNextFilled(0);
        }

        @Override
        public final boolean hasNext() {
            return this.curPosition < Obj2IntIdentityHashMap.this.keys_length() && this.curPosition >= 0;
        }

        @Override
        public final int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int r = Obj2IntIdentityHashMap.this.values[this.curPosition];
            this.curPosition = Obj2IntIdentityHashMap.this.moveToNextFilled(this.curPosition + 1);
            return r;
        }

        @Override
        public final int nextNvc() {
            int r = Obj2IntIdentityHashMap.this.values[this.curPosition];
            this.curPosition = Obj2IntIdentityHashMap.this.moveToNextFilled(this.curPosition + 1);
            return r;
        }

        @Override
        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int previous() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int previousNvc() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void moveToStart() {
            this.curPosition = this.firstPosition;
        }

        @Override
        public void moveToEnd() {
            this.curPosition = Obj2IntIdentityHashMap.this.moveToPreviousFilled(Obj2IntIdentityHashMap.this.getCapacity() - 1);
        }
    }
}

