/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.core.route;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.unomi.router.api.exceptions.BadProfileDataFormatException;
import org.apache.unomi.router.core.processor.ImportConfigByFileNameProcessor;
import org.apache.unomi.router.core.processor.LineSplitFailureHandler;
import org.apache.unomi.router.core.processor.LineSplitProcessor;
import org.apache.unomi.router.core.route.RouterAbstractRouteBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileImportOneShotRouteBuilder
extends RouterAbstractRouteBuilder {
    private Logger logger = LoggerFactory.getLogger((String)ProfileImportOneShotRouteBuilder.class.getName());
    private ImportConfigByFileNameProcessor importConfigByFileNameProcessor;
    private String uploadDir;

    public ProfileImportOneShotRouteBuilder(Map<String, String> kafkaProps, String configType) {
        super(kafkaProps, configType);
    }

    public void configure() throws Exception {
        this.logger.info("Configure OneShot Route...");
        OnExceptionDefinition prDefErr = ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.onException(BadProfileDataFormatException.class).log(LoggingLevel.ERROR, "Error processing record ${exchangeProperty.CamelSplitIndex}++ !")).handled(true).process((Processor)new LineSplitFailureHandler())).onException(Exception.class).log(LoggingLevel.ERROR, "Failed to process file.")).handled(true);
        if ("kafka".equals(this.configType)) {
            prDefErr.to((Endpoint)((KafkaEndpoint)this.getEndpointURI("from", "direct:depositImportBuffer")));
        } else {
            prDefErr.to((String)this.getEndpointURI("from", "direct:depositImportBuffer"));
        }
        LineSplitProcessor lineSplitProcessor = new LineSplitProcessor();
        lineSplitProcessor.setProfilePropertyTypes(this.profileService.getTargetPropertyTypes("profiles"));
        ProcessorDefinition prDef = ((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((RouteDefinition)this.from("file://" + this.uploadDir + "?moveFailed=.error&include=.*.csv&consumer.delay=1m").routeId("ONE_SHOT_ROUTE").autoStartup(true).process((Processor)this.importConfigByFileNameProcessor)).split((Expression)this.bodyAs(String.class).tokenize("${in.header.importConfigOneShot.getLineSeparator}")).setHeader("configType", (Expression)this.constant(this.configType))).process((Processor)lineSplitProcessor)).to("log:org.apache.unomi.router?level=DEBUG")).marshal((DataFormat)this.jacksonDataFormat)).convertBodyTo(String.class);
        if ("kafka".equals(this.configType)) {
            prDef.to((Endpoint)((KafkaEndpoint)this.getEndpointURI("from", "direct:depositImportBuffer")));
        } else {
            prDef.to((String)this.getEndpointURI("from", "direct:depositImportBuffer"));
        }
    }

    public void setImportConfigByFileNameProcessor(ImportConfigByFileNameProcessor importConfigByFileNameProcessor) {
        this.importConfigByFileNameProcessor = importConfigByFileNameProcessor;
    }

    public void setUploadDir(String uploadDir) {
        this.uploadDir = uploadDir;
    }
}

