/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.conditions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.SegmentService;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionContextHelper;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionESQueryBuilder;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionESQueryBuilderDispatcher;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.persistence.spi.aggregate.BaseAggregate;
import org.apache.unomi.persistence.spi.aggregate.TermsAggregate;
import org.apache.unomi.scripting.ScriptExecutor;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;

public class PastEventConditionESQueryBuilder
implements ConditionESQueryBuilder {
    private DefinitionsService definitionsService;
    private PersistenceService persistenceService;
    private SegmentService segmentService;
    private ScriptExecutor scriptExecutor;
    private int maximumIdsQueryCount = 5000;
    private int aggregateQueryBucketSize = 5000;
    private boolean pastEventsDisablePartitions = false;

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setScriptExecutor(ScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    public void setMaximumIdsQueryCount(int maximumIdsQueryCount) {
        this.maximumIdsQueryCount = maximumIdsQueryCount;
    }

    public void setAggregateQueryBucketSize(int aggregateQueryBucketSize) {
        this.aggregateQueryBucketSize = aggregateQueryBucketSize;
    }

    public void setPastEventsDisablePartitions(boolean pastEventsDisablePartitions) {
        this.pastEventsDisablePartitions = pastEventsDisablePartitions;
    }

    public void setSegmentService(SegmentService segmentService) {
        this.segmentService = segmentService;
    }

    public QueryBuilder buildQuery(Condition condition, Map<String, Object> context, ConditionESQueryBuilderDispatcher dispatcher) {
        Integer minimumEventCount = condition.getParameter("minimumEventCount") == null ? 1 : (Integer)condition.getParameter("minimumEventCount");
        Integer maximumEventCount = condition.getParameter("maximumEventCount") == null ? Integer.MAX_VALUE : (Integer)condition.getParameter("maximumEventCount");
        if (condition.getParameter("generatedPropertyKey") != null && condition.getParameter("generatedPropertyKey").equals(this.segmentService.getGeneratedPropertyKey((Condition)condition.getParameter("eventCondition"), condition))) {
            if (minimumEventCount != 1 || maximumEventCount != Integer.MAX_VALUE) {
                RangeQueryBuilder builder = QueryBuilders.rangeQuery((String)("systemProperties.pastEvents." + condition.getParameter("generatedPropertyKey")));
                if (minimumEventCount != 1) {
                    builder.gte((Object)minimumEventCount);
                }
                if (maximumEventCount != Integer.MAX_VALUE) {
                    builder.lte((Object)minimumEventCount);
                }
                return builder;
            }
            return QueryBuilders.existsQuery((String)("systemProperties.pastEvents." + condition.getParameter("generatedPropertyKey")));
        }
        Condition eventCondition = this.getEventCondition(condition, context);
        Set<Object> ids = new HashSet();
        if (this.pastEventsDisablePartitions) {
            Map eventCountByProfile = this.persistenceService.aggregateWithOptimizedQuery(eventCondition, (BaseAggregate)new TermsAggregate("profileId"), "event", this.maximumIdsQueryCount);
            ids = eventCountByProfile.entrySet().stream().filter(x -> !((String)x.getKey()).equals("_filtered")).filter(x -> (Long)x.getValue() >= (long)minimumEventCount.intValue() && (Long)x.getValue() <= (long)maximumEventCount.intValue()).map(Map.Entry::getKey).collect(Collectors.toSet());
        } else {
            Map m = this.persistenceService.getSingleValuesMetrics(eventCondition, new String[]{"card"}, "profileId.keyword", "event");
            long card = ((Double)m.get("_card")).longValue();
            int numParts = (int)(card / (long)this.aggregateQueryBucketSize) + 2;
            for (int i = 0; i < numParts; ++i) {
                Map eventCountByProfile = this.persistenceService.aggregateWithOptimizedQuery(eventCondition, (BaseAggregate)new TermsAggregate("profileId", i, numParts), "event");
                if (eventCountByProfile == null) continue;
                eventCountByProfile.remove("_filtered");
                for (Map.Entry entry : eventCountByProfile.entrySet()) {
                    if ((Long)entry.getValue() < (long)minimumEventCount.intValue()) break;
                    if ((Long)entry.getValue() > (long)maximumEventCount.intValue()) continue;
                    ids.add(entry.getKey());
                    if (ids.size() <= this.maximumIdsQueryCount) continue;
                    throw new UnsupportedOperationException("Too many profiles");
                }
            }
        }
        return QueryBuilders.idsQuery().addIds(ids.toArray(new String[0]));
    }

    public long count(Condition condition, Map<String, Object> context, ConditionESQueryBuilderDispatcher dispatcher) {
        Condition eventCondition = this.getEventCondition(condition, context);
        Map aggResult = null;
        Integer minimumEventCount = condition.getParameter("minimumEventCount") == null ? 1 : (Integer)condition.getParameter("minimumEventCount");
        Integer maximumEventCount = condition.getParameter("maximumEventCount") == null ? Integer.MAX_VALUE : (Integer)condition.getParameter("maximumEventCount");
        if (minimumEventCount == 1 && maximumEventCount == Integer.MAX_VALUE) {
            aggResult = this.persistenceService.getSingleValuesMetrics(eventCondition, new String[]{"card"}, "profileId.keyword", "event");
            return ((Double)aggResult.get("_card")).longValue();
        }
        if (this.pastEventsDisablePartitions) {
            Map eventCountByProfile = this.persistenceService.aggregateWithOptimizedQuery(eventCondition, (BaseAggregate)new TermsAggregate("profileId"), "event", this.maximumIdsQueryCount);
            return eventCountByProfile.entrySet().stream().filter(x -> ((String)x.getKey()).equals("_filtered")).filter(x -> (Long)x.getValue() >= (long)minimumEventCount.intValue() && (Long)x.getValue() <= (long)maximumEventCount.intValue()).count();
        }
        aggResult = this.persistenceService.getSingleValuesMetrics(eventCondition, new String[]{"card"}, "profileId.keyword", "event");
        long card = ((Double)aggResult.get("_card")).longValue();
        int result = 0;
        int numParts = (int)(card / (long)this.aggregateQueryBucketSize) + 2;
        block0: for (int i = 0; i < numParts; ++i) {
            Map eventCountByProfile = this.persistenceService.aggregateWithOptimizedQuery(eventCondition, (BaseAggregate)new TermsAggregate("profileId", i, numParts), "event");
            int j = 0;
            if (eventCountByProfile == null) continue;
            eventCountByProfile.remove("_filtered");
            for (Map.Entry entry : eventCountByProfile.entrySet()) {
                if ((Long)entry.getValue() < (long)minimumEventCount.intValue()) break;
                if ((Long)entry.getValue() <= (long)maximumEventCount.intValue() && minimumEventCount == 1) {
                    result += eventCountByProfile.size() - j;
                    continue block0;
                }
                if ((Long)entry.getValue() <= (long)maximumEventCount.intValue()) {
                    ++result;
                }
                ++j;
            }
        }
        return result;
    }

    private Condition getEventCondition(Condition condition, Map<String, Object> context) {
        Condition eventCondition;
        try {
            eventCondition = (Condition)condition.getParameter("eventCondition");
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Empty eventCondition");
        }
        if (eventCondition == null) {
            throw new IllegalArgumentException("No eventCondition");
        }
        ArrayList<Condition> l = new ArrayList<Condition>();
        Condition andCondition = new Condition();
        andCondition.setConditionType(this.definitionsService.getConditionType("booleanCondition"));
        andCondition.setParameter("operator", (Object)"and");
        andCondition.setParameter("subConditions", l);
        l.add(ConditionContextHelper.getContextualCondition((Condition)eventCondition, context, (ScriptExecutor)this.scriptExecutor));
        Integer numberOfDays = (Integer)condition.getParameter("numberOfDays");
        String fromDate = (String)condition.getParameter("fromDate");
        String toDate = (String)condition.getParameter("toDate");
        if (numberOfDays != null) {
            Condition numberOfDaysCondition = new Condition();
            numberOfDaysCondition.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
            numberOfDaysCondition.setParameter("propertyName", (Object)"timeStamp");
            numberOfDaysCondition.setParameter("comparisonOperator", (Object)"greaterThan");
            numberOfDaysCondition.setParameter("propertyValueDateExpr", (Object)("now-" + numberOfDays + "d"));
            l.add(numberOfDaysCondition);
        }
        if (fromDate != null) {
            Condition startDateCondition = new Condition();
            startDateCondition.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
            startDateCondition.setParameter("propertyName", (Object)"timeStamp");
            startDateCondition.setParameter("comparisonOperator", (Object)"greaterThanOrEqualTo");
            startDateCondition.setParameter("propertyValueDate", (Object)fromDate);
            l.add(startDateCondition);
        }
        if (toDate != null) {
            Condition endDateCondition = new Condition();
            endDateCondition.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
            endDateCondition.setParameter("propertyName", (Object)"timeStamp");
            endDateCondition.setParameter("comparisonOperator", (Object)"lessThanOrEqualTo");
            endDateCondition.setParameter("propertyValueDate", (Object)toDate);
            l.add(endDateCondition);
        }
        return andCondition;
    }
}

