/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ConnectionRetryConfig;

public class ClientConnectionStrategyConfig {
    private boolean asyncStart;
    private ReconnectMode reconnectMode = ReconnectMode.ON;
    private ConnectionRetryConfig connectionRetryConfig = new ConnectionRetryConfig();

    public ClientConnectionStrategyConfig() {
    }

    public ClientConnectionStrategyConfig(ClientConnectionStrategyConfig config) {
        this.asyncStart = config.asyncStart;
        this.reconnectMode = config.reconnectMode;
        this.connectionRetryConfig = new ConnectionRetryConfig(config.connectionRetryConfig);
    }

    public boolean isAsyncStart() {
        return this.asyncStart;
    }

    public ClientConnectionStrategyConfig setAsyncStart(boolean asyncStart) {
        this.asyncStart = asyncStart;
        return this;
    }

    public ReconnectMode getReconnectMode() {
        return this.reconnectMode;
    }

    public ClientConnectionStrategyConfig setReconnectMode(ReconnectMode reconnectMode) {
        this.reconnectMode = reconnectMode;
        return this;
    }

    public ConnectionRetryConfig getConnectionRetryConfig() {
        return this.connectionRetryConfig;
    }

    public ClientConnectionStrategyConfig setConnectionRetryConfig(ConnectionRetryConfig connectionRetryConfig) {
        this.connectionRetryConfig = connectionRetryConfig;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientConnectionStrategyConfig that = (ClientConnectionStrategyConfig)o;
        if (this.asyncStart != that.asyncStart) {
            return false;
        }
        if (this.reconnectMode != that.reconnectMode) {
            return false;
        }
        return this.connectionRetryConfig != null ? this.connectionRetryConfig.equals(that.connectionRetryConfig) : that.connectionRetryConfig == null;
    }

    public int hashCode() {
        int result = this.asyncStart ? 1 : 0;
        result = 31 * result + (this.reconnectMode != null ? this.reconnectMode.hashCode() : 0);
        result = 31 * result + (this.connectionRetryConfig != null ? this.connectionRetryConfig.hashCode() : 0);
        return result;
    }

    public static enum ReconnectMode {
        OFF,
        ON,
        ASYNC;

    }
}

