/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IQueue;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.command.Command;
import org.apache.karaf.cellar.core.command.Result;
import org.apache.karaf.cellar.core.control.BasicSwitch;
import org.apache.karaf.cellar.core.control.Switch;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueProducer<E extends Event>
implements EventProducer<E> {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(QueueProducer.class);
    public static final String SWITCH_ID = "org.apache.karaf.cellar.queue.producer";
    private final Switch eventSwitch = new BasicSwitch("org.apache.karaf.cellar.queue.producer");
    private HazelcastInstance instance;
    private IQueue<E> queue;
    private Node node;
    private ConfigurationAdmin configurationAdmin;

    public void init() {
        if (this.queue == null) {
            this.queue = this.instance.getQueue("org.apache.karaf.cellar.event.queue");
        }
    }

    public void destroy() {
    }

    public void produce(E event) {
        if (this.getSwitch().getStatus().equals((Object)SwitchStatus.ON) || event.getForce().booleanValue() || event instanceof Result) {
            if (event instanceof Result || event instanceof Command) {
                event.setSourceNode(this.node);
            }
            try {
                this.queue.put(event);
            }
            catch (InterruptedException e) {
                LOGGER.error("CELLAR HAZELCAST: queue producer interrupted", (Throwable)e);
            }
        } else if (this.eventSwitch.getStatus().equals((Object)SwitchStatus.OFF)) {
            LOGGER.debug("CELLAR HAZELCAST: {} switch is OFF, don't produce the cluster event", (Object)SWITCH_ID);
        }
    }

    public Switch getSwitch() {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
            if (configuration != null) {
                Boolean status = new Boolean((String)configuration.getProperties().get("producer"));
                if (status.booleanValue()) {
                    this.eventSwitch.turnOn();
                } else {
                    this.eventSwitch.turnOff();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.eventSwitch;
    }

    public IQueue<E> getQueue() {
        return this.queue;
    }

    public void setQueue(IQueue<E> queue) {
        this.queue = queue;
    }

    public HazelcastInstance getInstance() {
        return this.instance;
    }

    public void setInstance(HazelcastInstance instance) {
        this.instance = instance;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }
}

