/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl.configsharing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.unomi.api.services.ConfigSharingService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSharingServiceImpl
implements ConfigSharingService,
SynchronousBundleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigSharingServiceImpl.class);
    private BundleContext bundleContext;
    private Map<String, Object> configProperties = new ConcurrentHashMap<String, Object>();

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setConfigProperties(Map<String, Object> configProperties) {
        this.configProperties = configProperties;
    }

    public Object getProperty(String name) {
        return this.configProperties.get(name);
    }

    public Object setProperty(String name, Object newValue) {
        boolean existed = this.configProperties.containsKey(name);
        Object oldValue = this.configProperties.put(name, newValue);
        if (existed) {
            this.firePropertyUpdatedEvent(name, oldValue, newValue);
        } else {
            this.firePropertyAddedEvent(name, newValue);
        }
        return oldValue;
    }

    public boolean hasProperty(String name) {
        return this.configProperties.containsKey(name);
    }

    public Object removeProperty(String name) {
        boolean existed = this.configProperties.containsKey(name);
        Object oldValue = this.configProperties.remove(name);
        if (existed) {
            this.firePropertyRemovedEvent(name, oldValue);
        }
        return oldValue;
    }

    public Set<String> getPropertyNames() {
        return this.configProperties.keySet();
    }

    public void preDestroy() throws Exception {
        this.bundleContext.removeBundleListener((BundleListener)this);
        LOGGER.info("Config sharing service for Service is shutdown.");
    }

    private void processBundleStartup(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
    }

    public void bundleChanged(BundleEvent bundleEvent) {
    }

    private void firePropertyAddedEvent(String name, Object newValue) {
        this.fireConfigChangeEvent(new ConfigSharingService.ConfigChangeEvent(ConfigSharingService.ConfigChangeEvent.ConfigChangeEventType.ADDED, name, null, newValue));
    }

    private void firePropertyUpdatedEvent(String name, Object oldValue, Object newValue) {
        this.fireConfigChangeEvent(new ConfigSharingService.ConfigChangeEvent(ConfigSharingService.ConfigChangeEvent.ConfigChangeEventType.UPDATED, name, oldValue, newValue));
    }

    private void firePropertyRemovedEvent(String name, Object oldValue) {
        this.fireConfigChangeEvent(new ConfigSharingService.ConfigChangeEvent(ConfigSharingService.ConfigChangeEvent.ConfigChangeEventType.REMOVED, name, oldValue, null));
    }

    private void fireConfigChangeEvent(ConfigSharingService.ConfigChangeEvent configChangeEvent) {
        List<ConfigSharingService.ConfigChangeListener> listeners = this.getListeners();
        for (ConfigSharingService.ConfigChangeListener configChangeListener : listeners) {
            configChangeListener.configChanged(configChangeEvent);
        }
    }

    private List<ConfigSharingService.ConfigChangeListener> getListeners() {
        ArrayList<ConfigSharingService.ConfigChangeListener> listeners = new ArrayList<ConfigSharingService.ConfigChangeListener>();
        try {
            ServiceReference[] allListenerReferences = this.bundleContext.getAllServiceReferences(ConfigSharingService.ConfigChangeListener.class.getName(), null);
            if (allListenerReferences == null) {
                return listeners;
            }
            for (ServiceReference listenerReference : allListenerReferences) {
                ConfigSharingService.ConfigChangeListener configChangeListener = (ConfigSharingService.ConfigChangeListener)this.bundleContext.getService(listenerReference);
                if (configChangeListener == null) continue;
                listeners.add(configChangeListener);
            }
        }
        catch (InvalidSyntaxException e) {
            LOGGER.error("Error retrieving listeners", (Throwable)e);
            return listeners;
        }
        return listeners;
    }
}

