/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.conditions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.persistence.spi.conditions.evaluator.ConditionEvaluator;
import org.apache.unomi.persistence.spi.conditions.evaluator.ConditionEvaluatorDispatcher;
import org.apache.unomi.plugins.baseplugin.conditions.PropertyConditionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedConditionEvaluator
implements ConditionEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)NestedConditionEvaluator.class.getName());
    PropertyConditionEvaluator propertyConditionEvaluator;

    public void setPropertyConditionEvaluator(PropertyConditionEvaluator propertyConditionEvaluator) {
        this.propertyConditionEvaluator = propertyConditionEvaluator;
    }

    public boolean eval(Condition condition, Item item, Map<String, Object> context, ConditionEvaluatorDispatcher dispatcher) {
        String path = (String)condition.getParameter("path");
        Condition subCondition = (Condition)condition.getParameter("subCondition");
        if (subCondition == null || path == null) {
            throw new IllegalArgumentException("Impossible to build Nested evaluator, subCondition and path properties should be provided");
        }
        try {
            Object nestedItems = this.propertyConditionEvaluator.getPropertyValue(item, path);
            if (nestedItems instanceof List) {
                for (Object nestedItem : (List)nestedItems) {
                    Map<String, Object> flattenedNestedItem;
                    Item finalNestedItem;
                    if (!(nestedItem instanceof Map) || (finalNestedItem = this.createFinalNestedItemForEvaluation(item, path, flattenedNestedItem = this.flattenNestedItem(path, (Map)nestedItem))) == null || !dispatcher.eval(subCondition, finalNestedItem, context)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to evaluated nested condition", (Throwable)e);
            return false;
        }
        return false;
    }

    protected Map<String, Object> flattenNestedItem(String path, Map<String, Object> nestedItem) {
        String propertyPath;
        HashMap<String, Object> flattenNestedItem = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)path) && StringUtils.isNotEmpty((CharSequence)(propertyPath = StringUtils.substringAfter((String)path, (String)".")))) {
            String[] propertyKeys = propertyPath.split("\\.");
            Iterator propertyKeysIterator = Arrays.stream(propertyKeys).iterator();
            HashMap<String, Object> currentPropertiesLevel = flattenNestedItem;
            while (propertyKeysIterator.hasNext()) {
                String propertyKey = (String)propertyKeysIterator.next();
                if (!propertyKeysIterator.hasNext()) {
                    currentPropertiesLevel.put(propertyKey, nestedItem);
                    continue;
                }
                HashMap subLevel = new HashMap();
                currentPropertiesLevel.put(propertyKey, subLevel);
                currentPropertiesLevel = subLevel;
            }
        }
        return flattenNestedItem;
    }

    protected Item createFinalNestedItemForEvaluation(Item parentItem, String path, Map<String, Object> flattenedNestedItem) {
        if (parentItem instanceof Profile) {
            Profile profile = new Profile(parentItem.getItemId());
            if (path.startsWith("properties.")) {
                profile.setProperties(flattenedNestedItem);
            } else if (path.startsWith("systemProperties.")) {
                profile.setSystemProperties(flattenedNestedItem);
            }
            return profile;
        }
        if (parentItem instanceof Session) {
            Session session = new Session();
            if (path.startsWith("properties.")) {
                session.setProperties(flattenedNestedItem);
            } else if (path.startsWith("systemProperties.")) {
                session.setSystemProperties(flattenedNestedItem);
            }
            return session;
        }
        return null;
    }
}

