/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PinnedDoc
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final String index;
    public static final JsonpDeserializer<PinnedDoc> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PinnedDoc::setupPinnedDocDeserializer);

    private PinnedDoc(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.index = builder.index;
    }

    public static PinnedDoc of(Function<Builder, ObjectBuilder<PinnedDoc>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_id");
        generator.write(this.id);
        if (this.index != null) {
            generator.writeKey("_index");
            generator.write(this.index);
        }
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    protected static void setupPinnedDocDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PinnedDoc> {
        private String id;
        @Nullable
        private String index;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PinnedDoc build() {
            this._checkSingleUse();
            return new PinnedDoc(this);
        }
    }
}

