/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.com.github.benmanes.caffeine.cache;

import java.lang.ref.ReferenceQueue;
import org.apache.camel.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.camel.com.github.benmanes.caffeine.cache.Node;
import org.apache.camel.com.github.benmanes.caffeine.cache.References;

interface NodeFactory<K, V> {
    public static final Object RETIRED_STRONG_KEY = new Object();
    public static final Object DEAD_STRONG_KEY = new Object();
    public static final References.WeakKeyReference<Object> RETIRED_WEAK_KEY = new References.WeakKeyReference<Object>(null, null);
    public static final References.WeakKeyReference<Object> DEAD_WEAK_KEY = new References.WeakKeyReference<Object>(null, null);

    public Node<K, V> newNode(K var1, ReferenceQueue<K> var2, V var3, ReferenceQueue<V> var4, int var5, long var6);

    public Node<K, V> newNode(Object var1, V var2, ReferenceQueue<V> var3, int var4, long var5);

    default public Object newReferenceKey(K k, ReferenceQueue<K> referenceQueue) {
        return k;
    }

    default public Object newLookupKey(Object object) {
        return object;
    }

    public static <K, V> NodeFactory<K, V> newFactory(Caffeine<K, V> caffeine, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("org.apache.camel.com.github.benmanes.caffeine.cache.");
        if (caffeine.isStrongKeys()) {
            stringBuilder.append('P');
        } else {
            stringBuilder.append('F');
        }
        if (caffeine.isStrongValues()) {
            stringBuilder.append('S');
        } else if (caffeine.isWeakValues()) {
            stringBuilder.append('W');
        } else {
            stringBuilder.append('D');
        }
        if (caffeine.expiresVariable()) {
            if (caffeine.refreshes()) {
                stringBuilder.append('A');
                if (caffeine.evicts()) {
                    stringBuilder.append('W');
                }
            } else {
                stringBuilder.append('W');
            }
        } else {
            if (caffeine.expiresAfterAccess()) {
                stringBuilder.append('A');
            }
            if (caffeine.expiresAfterWrite()) {
                stringBuilder.append('W');
            }
        }
        if (caffeine.refreshes()) {
            stringBuilder.append('R');
        }
        if (caffeine.evicts()) {
            stringBuilder.append('M');
            if (bl && caffeine.evicts() || caffeine.isWeighted()) {
                stringBuilder.append('W');
            } else {
                stringBuilder.append('S');
            }
        }
        try {
            Class<?> clazz = NodeFactory.class.getClassLoader().loadClass(stringBuilder.toString());
            NodeFactory nodeFactory = (NodeFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return nodeFactory;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new IllegalStateException(stringBuilder.toString(), reflectiveOperationException);
        }
    }

    default public boolean weakValues() {
        return false;
    }

    default public boolean softValues() {
        return false;
    }
}

