/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.SystemPropertiesItem;
import org.apache.unomi.api.TimestampedItem;

public class Session
extends Item
implements TimestampedItem,
SystemPropertiesItem {
    public static final String ITEM_TYPE = "session";
    private static final long serialVersionUID = 4628640198281687336L;
    private String profileId;
    private Profile profile;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, Object> systemProperties = new HashMap<String, Object>();
    private Date timeStamp;
    private String scope;
    private Date lastEventDate;
    private int size = 0;
    private int duration = 0;
    private List<String> originEventTypes = new ArrayList<String>();
    private List<String> originEventIds = new ArrayList<String>();

    public Session() {
    }

    public Session(String itemId, Profile profile, Date timeStamp, String scope) {
        super(itemId);
        this.profile = profile;
        this.profileId = profile.getItemId();
        this.timeStamp = timeStamp;
        this.scope = scope;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profileId = profile.getItemId();
        this.profile = profile;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public Map<String, Object> getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Map<String, Object> systemProperties) {
        this.systemProperties = systemProperties;
    }

    @Override
    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public Date getLastEventDate() {
        return this.lastEventDate;
    }

    public void setLastEventDate(Date lastEventDate) {
        this.lastEventDate = lastEventDate;
        if (lastEventDate != null) {
            this.duration = (int)(lastEventDate.getTime() - this.timeStamp.getTime());
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public void setScope(String scope) {
        this.scope = scope;
    }

    public List<String> getOriginEventTypes() {
        return this.originEventTypes;
    }

    public void setOriginEventTypes(List<String> originEventTypes) {
        this.originEventTypes = originEventTypes;
    }

    public List<String> getOriginEventIds() {
        return this.originEventIds;
    }

    public void setOriginEventIds(List<String> originEventIds) {
        this.originEventIds = originEventIds;
    }
}

