package org.apache.dvsl;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.StringReader;
import java.io.StringWriter;
import java.io.FileReader;

import junit.framework.TestCase;

import org.dom4j.Document;
import org.dom4j.io.SAXReader;

/**
 *  Simple testcase to ensure things are basically working.
 *  This tests both a serialized document as well as a 'live'
 *  dom4j one.
 *
 *  @author <a href="mailto:geirm@apache.org>Geir Magnusson Jr.</a>
 */
public class GrinderTest
    extends TestCase
{
    /*
     * use simple in-memory style and input strings
     */

    private String dvslstyle = "src/test/site.dvsl";
    private String input = "src/test/user-guide.xml";

    public GrinderTest( String name )
    {
        super(name);
    }


    public void testSelection()
    {
        try
        {
            doit();
        }
        catch( Exception e )
        {
            fail( e.getMessage() );
        }
    }

    public void doit()
        throws Exception
    {
        /*
         * make a dvsl
         */

        DVSL dvsl = new DVSL();

        /*
         *  register the stylesheet
         */

        dvsl.setStylesheet( new FileReader(dvslstyle) );

        /*
         *  render the document as a Reader
         */

        StringWriter sw = new StringWriter();
        SAXReader sr = new SAXReader();
        Document document = sr.read( new FileReader(input ));
        sw = new StringWriter();

        while(true)
        {
            dvsl.transform( document, sw );
        }
    }
}
