
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  First use setAttribute to create two new attributes on the second strong element and sup element.
 *  Invoke setIdAttribute on the new attributes. Verify by calling isID on the new attributes and getElementById 
 *  with two different values on document. 
* @author IBM
* @author Jenny Hsu
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-ElSetIdAttr">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-ElSetIdAttr</a>
*/
public final class elementsetidattribute09 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public elementsetidattribute09(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList elemList1;
      NodeList elemList2;
      Element nameElem;
      Element salaryElem;
      NamedNodeMap attributesMap;
      Attr attr;
      boolean id = false;
      Element elem;
      String elemName;
      doc = (Document) load("hc_staff", true);
      elemList1 = doc.getElementsByTagName("strong");
      elemList2 = doc.getElementsByTagName("sup");
      nameElem = (Element) elemList1.item(2);
      salaryElem = (Element) elemList2.item(2);
      nameElem.setAttribute("hasMiddleName", "Antoine");
      salaryElem.setAttribute("annual", "2002");
      nameElem.setIdAttribute("hasMiddleName", true);
      salaryElem.setIdAttribute("annual", true);
      attributesMap = nameElem.getAttributes();
      attr = (Attr) attributesMap.getNamedItem("hasMiddleName");
      id = attr.isId();
      assertTrue("elementsetidattributeIsId1True09", id);
      attributesMap = salaryElem.getAttributes();
      attr = (Attr) attributesMap.getNamedItem("annual");
      id = attr.isId();
      assertTrue("elementsetidattributeIsId2True09", id);
      elem = doc.getElementById("Antoine");
      elemName = elem.getTagName();
      assertEquals("elementsetidattribute1GetElementById09", "strong", elemName);
      elem = doc.getElementById("2002");
      elemName = elem.getTagName();
      assertEquals("elementsetidattribute2GetElementById09", "sup", elemName);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/elementsetidattribute09";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(elementsetidattribute09.class, args);
   }
}

