Apache Axiom 1.2.15 Release Note
================================

Axiom 1.2.15 ships fixes for over a dozen [JIRA issues][1] and contains many other improvements,
mainly related to consistency between the LLOM and DOOM implementations and how serialization is
performed. In particular the builder is now able to continue building the Axiom tree after an
element has been consumed (see [AXIOM-288][2]).

Changes in this release
-----------------------

### Removal of the JavaMail dependency

Axiom 1.2.15 no longer uses JavaMail and the corresponding dependency has been removed. If your
project relies on Axiom to introduce JavaMail as a transitive dependency, you need to update your
build.

### Serialization changes

In previous Axiom versions, the `serialize` and `serializeAndConsume` methods skipped empty SOAP
`Header` elements. On the other hand, such elements would still appear in the representations
produced by `getXMLStreamReader` and `getSAXSource`. For consistency, starting with Axiom 1.2.15,
SOAP `Header` elements are always serialized. This may change the output of existing code,
especially code that uses the `getDefaultEnvelope()` defined by `SOAPFactory`. However, it is
expected that this will not break anything because empty SOAP `Header` elements should be ignored by
the receiver.

To avoid producing empty `Header` elements, projects should switch from using `getDefaultEnvelope()`
(in `SOAPFactory`) and `getHeader()` (in `SOAPEnvelope`) to using `createDefaultSOAPMessage()` and
`getOrCreateHeader()`.

For more information, see [AXIOM-430][3].

### Introduction of AspectJ

The implementation JARs (`axiom-impl` and `axiom-dom`) are now built with [AspectJ][4] (to reduce
source code duplication) and contain a small subset of classes from the AspectJ runtime library.
There is a small risk that this may cause conflicts with other code that uses AspectJ.

[1]: http://s.apache.org/axiom-changes-1.2.15
[2]: https://issues.apache.org/jira/browse/AXIOM-288
[3]: https://issues.apache.org/jira/browse/AXIOM-430
[4]: https://eclipse.org/aspectj/
