
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 * Insert whitespace before the "p" element in barfoo and normalize with validation.
 * isElementContentWhitespace should be true since the node is whitespace and in element content.  
* @author Curt Arnold
* @author Curt Arnold
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Text3-isElementContentWhitespace">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Text3-isElementContentWhitespace</a>
*/
public final class textiselementcontentwhitespace06 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public textiselementcontentwhitespace06(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "barfoo", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList bodyList;
      Element bodyElem;
      Node refChild;
      Text textNode;
      Text blankNode;
      Node returnedNode;
      boolean isElemContentWhitespace;
      DOMConfiguration domConfig;
      boolean canSetValidation;
      Node replacedNode;
      org.w3c.domts.DOMErrorMonitor errorMonitor = new org.w3c.domts.DOMErrorMonitor();
      
      doc = (Document) load("barfoo", true);
      domConfig = doc.getDomConfig();
      canSetValidation = domConfig.canSetParameter("validate", Boolean.TRUE);
      
      if (canSetValidation) {
          domConfig.setParameter("validate", Boolean.TRUE);
      domConfig.setParameter("error-handler", ((Object) /*DOMErrorMonitor */errorMonitor));
      bodyList = doc.getElementsByTagName("body");
      bodyElem = (Element) bodyList.item(0);
      refChild = bodyElem.getFirstChild();
      blankNode = doc.createTextNode("     ");
      replacedNode = bodyElem.insertBefore(blankNode, refChild);
      doc.normalizeDocument();
      errorMonitor.assertLowerSeverity(this, "noErrors", 2);
     bodyList = doc.getElementsByTagName("body");
      bodyElem = (Element) bodyList.item(0);
      textNode = (Text) bodyElem.getFirstChild();
      isElemContentWhitespace = textNode.isElementContentWhitespace();
      assertTrue("isElemContentWhitespace", isElemContentWhitespace);
      }
    }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/textiselementcontentwhitespace06";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(textiselementcontentwhitespace06.class, args);
   }
}

