/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

class Encodings {
    static final int DefaultLastPrintable = 127;
    private static final EncodingInfo[] _encodings = new EncodingInfo[]{new EncodingInfo("ASCII", "ASCII", 127), new EncodingInfo("ISO-Latin-1", "ASCII", 255), new EncodingInfo("ISO-8859-1", "ISO8859_1", 255), new EncodingInfo("ISO-8859-2", "ISO8859_2", 255), new EncodingInfo("ISO-8859-3", "ISO8859_3", 255), new EncodingInfo("ISO-8859-4", "ISO8859_4", 255), new EncodingInfo("ISO-8859-5", "ISO8859_5", 255), new EncodingInfo("ISO-8859-6", "ISO8859_6", 255), new EncodingInfo("ISO-8859-7", "ISO8859_7", 255), new EncodingInfo("ISO-8859-8", "ISO8859_8", 255), new EncodingInfo("ISO-8859-9", "ISO8859_9", 255), new EncodingInfo("UTF-8", "UTF8", 65535), new EncodingInfo("UNICODE", "Unicode", 65535)};

    Encodings() {
    }

    static int getLastPrintable() {
        return 127;
    }

    static int getLastPrintable(String string) {
        int n = 0;
        while (n < _encodings.length) {
            if (Encodings._encodings[n].name.equalsIgnoreCase(string)) {
                return Encodings._encodings[n].lastPrintable;
            }
            ++n;
        }
        return 127;
    }

    static Writer getWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        int n = 0;
        while (n < _encodings.length) {
            if (Encodings._encodings[n].name.equals(string)) {
                return new OutputStreamWriter(outputStream, Encodings._encodings[n].javaName);
            }
            ++n;
        }
        return new OutputStreamWriter(outputStream, string);
    }

    static final class EncodingInfo {
        final String name;
        final String javaName;
        final int lastPrintable;

        EncodingInfo(String string, String string2, int n) {
            this.name = string;
            this.javaName = string2;
            this.lastPrintable = n;
        }
    }
}

