# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
import grpc

import kernel_pb2 as kernel__pb2


class JupyterKernelStub(object):
  """The JupyterKernel service definition.
  """

  def __init__(self, channel):
    """Constructor.

    Args:
      channel: A grpc.Channel.
    """
    self.execute = channel.unary_stream(
        '/jupyter.JupyterKernel/execute',
        request_serializer=kernel__pb2.ExecuteRequest.SerializeToString,
        response_deserializer=kernel__pb2.ExecuteResponse.FromString,
        )
    self.complete = channel.unary_unary(
        '/jupyter.JupyterKernel/complete',
        request_serializer=kernel__pb2.CompletionRequest.SerializeToString,
        response_deserializer=kernel__pb2.CompletionResponse.FromString,
        )
    self.cancel = channel.unary_unary(
        '/jupyter.JupyterKernel/cancel',
        request_serializer=kernel__pb2.CancelRequest.SerializeToString,
        response_deserializer=kernel__pb2.CancelResponse.FromString,
        )
    self.status = channel.unary_unary(
        '/jupyter.JupyterKernel/status',
        request_serializer=kernel__pb2.StatusRequest.SerializeToString,
        response_deserializer=kernel__pb2.StatusResponse.FromString,
        )
    self.stop = channel.unary_unary(
        '/jupyter.JupyterKernel/stop',
        request_serializer=kernel__pb2.StopRequest.SerializeToString,
        response_deserializer=kernel__pb2.StopResponse.FromString,
        )


class JupyterKernelServicer(object):
  """The JupyterKernel service definition.
  """

  def execute(self, request, context):
    """Sends code
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def complete(self, request, context):
    """Get completion
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def cancel(self, request, context):
    """Cancel the running statement
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def status(self, request, context):
    """Get jupyter kernel status
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def stop(self, request, context):
    """Stop jupyter kernel
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')


def add_JupyterKernelServicer_to_server(servicer, server):
  rpc_method_handlers = {
      'execute': grpc.unary_stream_rpc_method_handler(
          servicer.execute,
          request_deserializer=kernel__pb2.ExecuteRequest.FromString,
          response_serializer=kernel__pb2.ExecuteResponse.SerializeToString,
      ),
      'complete': grpc.unary_unary_rpc_method_handler(
          servicer.complete,
          request_deserializer=kernel__pb2.CompletionRequest.FromString,
          response_serializer=kernel__pb2.CompletionResponse.SerializeToString,
      ),
      'cancel': grpc.unary_unary_rpc_method_handler(
          servicer.cancel,
          request_deserializer=kernel__pb2.CancelRequest.FromString,
          response_serializer=kernel__pb2.CancelResponse.SerializeToString,
      ),
      'status': grpc.unary_unary_rpc_method_handler(
          servicer.status,
          request_deserializer=kernel__pb2.StatusRequest.FromString,
          response_serializer=kernel__pb2.StatusResponse.SerializeToString,
      ),
      'stop': grpc.unary_unary_rpc_method_handler(
          servicer.stop,
          request_deserializer=kernel__pb2.StopRequest.FromString,
          response_serializer=kernel__pb2.StopResponse.SerializeToString,
      ),
  }
  generic_handler = grpc.method_handlers_generic_handler(
      'jupyter.JupyterKernel', rpc_method_handlers)
  server.add_generic_rpc_handlers((generic_handler,))
