﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/redshift-data/RedshiftDataAPIServiceRequest.h>
#include <aws/redshift-data/RedshiftDataAPIService_EXPORTS.h>

#include <utility>

namespace Aws {
namespace RedshiftDataAPIService {
namespace Model {

/**
 */
class GetStatementResultRequest : public RedshiftDataAPIServiceRequest {
 public:
  AWS_REDSHIFTDATAAPISERVICE_API GetStatementResultRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetStatementResult"; }

  AWS_REDSHIFTDATAAPISERVICE_API Aws::String SerializePayload() const override;

  AWS_REDSHIFTDATAAPISERVICE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The identifier of the SQL statement whose results are to be fetched. This
   * value is a universally unique identifier (UUID) generated by Amazon Redshift
   * Data API. A suffix indicates then number of the SQL statement. For example,
   * <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of
   * <code>:2</code> that indicates the second SQL statement of a batch query. This
   * identifier is returned by <code>BatchExecuteStatment</code>,
   * <code>ExecuteStatment</code>, and <code>ListStatements</code>. </p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  GetStatementResultRequest& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A value that indicates the starting point for the next set of response
   * records in a subsequent request. If a value is returned in a response, you can
   * retrieve the next set of records by providing this returned NextToken value in
   * the next NextToken parameter and retrying the command. If the NextToken field is
   * empty, all response records have been retrieved for the request. </p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  GetStatementResultRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_nextToken;
  bool m_idHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace RedshiftDataAPIService
}  // namespace Aws
