/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.List;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class OrderByDeParser
extends AbstractDeParser<List<OrderByElement>> {
    private ExpressionVisitor<StringBuilder> expressionVisitor;

    OrderByDeParser() {
        super(new StringBuilder());
    }

    public OrderByDeParser(ExpressionVisitor<StringBuilder> expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(List<OrderByElement> orderByElementList) {
        this.deParse(false, orderByElementList);
    }

    public void deParse(boolean oracleSiblings, List<OrderByElement> orderByElementList) {
        if (oracleSiblings) {
            this.builder.append(" ORDER SIBLINGS BY ");
        } else {
            this.builder.append(" ORDER BY ");
        }
        Iterator<OrderByElement> iterator = orderByElementList.iterator();
        while (iterator.hasNext()) {
            OrderByElement orderByElement = iterator.next();
            this.deParseElement(orderByElement);
            if (!iterator.hasNext()) continue;
            this.builder.append(", ");
        }
    }

    public void deParseElement(OrderByElement orderBy) {
        orderBy.getExpression().accept(this.expressionVisitor, null);
        if (!orderBy.isAsc()) {
            this.builder.append(" DESC");
        } else if (orderBy.isAscDescPresent()) {
            this.builder.append(" ASC");
        }
        if (orderBy.getNullOrdering() != null) {
            this.builder.append(' ');
            this.builder.append(orderBy.getNullOrdering() == OrderByElement.NullOrdering.NULLS_FIRST ? "NULLS FIRST" : "NULLS LAST");
        }
        if (orderBy.isMysqlWithRollup()) {
            this.builder.append(" WITH ROLLUP");
        }
    }

    void setExpressionVisitor(ExpressionVisitor<StringBuilder> expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }
}

