/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Timestamp;
import java.util.Objects;
import java.util.Optional;

public final class TestRunFinished {
    private final String message;
    private final Boolean success;
    private final Timestamp timestamp;

    public TestRunFinished(String message, Boolean success, Timestamp timestamp) {
        this.message = message;
        this.success = Objects.requireNonNull(success, "TestRunFinished.success cannot be null");
        this.timestamp = Objects.requireNonNull(timestamp, "TestRunFinished.timestamp cannot be null");
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestRunFinished that = (TestRunFinished)o;
        return Objects.equals(this.message, that.message) && this.success.equals(that.success) && this.timestamp.equals(that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.success, this.timestamp);
    }

    public String toString() {
        return "TestRunFinished{message=" + this.message + ", success=" + this.success + ", timestamp=" + this.timestamp + '}';
    }
}

