/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.nativewindow.CapabilitiesFilter;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.VisualIDHolder;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesFilter;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;
import com.jogamp.opengl.egl.EGL;
import java.io.PrintStream;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jogamp.opengl.GLGraphicsConfigurationFactory;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.egl.EGLDisplayUtil;
import jogamp.opengl.egl.EGLDrawableFactory;
import jogamp.opengl.egl.EGLGLCapabilities;
import jogamp.opengl.egl.EGLGraphicsConfiguration;

public class EGLGraphicsConfigurationFactory
extends GLGraphicsConfigurationFactory {
    static VisualIDHolder.VIDComparator EglCfgIDComparator = new VisualIDHolder.VIDComparator(VisualIDHolder.VIDType.EGL_CONFIG);
    static GraphicsConfigurationFactory nativeGraphicsConfigurationFactory = null;
    static GraphicsConfigurationFactory kdeglGraphicsConfigurationFactory = null;
    static GraphicsConfigurationFactory fallbackGraphicsConfigurationFactory = null;

    static void registerFactory() {
        EGLGraphicsConfigurationFactory eGLGraphicsConfigurationFactory = new EGLGraphicsConfigurationFactory();
        String string = NativeWindowFactory.getNativeWindowType(false);
        if (".x11" == string) {
            nativeGraphicsConfigurationFactory = GraphicsConfigurationFactory.registerFactory(X11GraphicsDevice.class, GLCapabilitiesImmutable.class, eGLGraphicsConfigurationFactory);
            fallbackGraphicsConfigurationFactory = null != nativeGraphicsConfigurationFactory ? nativeGraphicsConfigurationFactory : GraphicsConfigurationFactory.getFactory(X11GraphicsDevice.class, CapabilitiesImmutable.class);
        }
        kdeglGraphicsConfigurationFactory = GraphicsConfigurationFactory.registerFactory(EGLGraphicsDevice.class, GLCapabilitiesImmutable.class, eGLGraphicsConfigurationFactory);
    }

    static void unregisterFactory() {
        String string = NativeWindowFactory.getNativeWindowType(false);
        if (".x11" == string) {
            GraphicsConfigurationFactory.registerFactory(X11GraphicsDevice.class, GLCapabilitiesImmutable.class, nativeGraphicsConfigurationFactory);
        }
        nativeGraphicsConfigurationFactory = null;
        fallbackGraphicsConfigurationFactory = null;
        GraphicsConfigurationFactory.registerFactory(EGLGraphicsDevice.class, GLCapabilitiesImmutable.class, kdeglGraphicsConfigurationFactory);
        kdeglGraphicsConfigurationFactory = null;
    }

    private EGLGraphicsConfigurationFactory() {
    }

    @Override
    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n) {
        if (abstractGraphicsScreen == null) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only AbstractGraphicsDevice objects");
        }
        if (!(capabilitiesImmutable instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - chosen");
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)capabilitiesImmutable;
        if (!(capabilitiesImmutable2 instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - requested");
        }
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        if (null == abstractGraphicsDevice) {
            throw new GLException("Null AbstractGraphicsDevice");
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = null;
        if (abstractGraphicsDevice instanceof EGLGraphicsDevice) {
            abstractGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)capabilitiesImmutable, (GLCapabilitiesImmutable)capabilitiesImmutable2, (GLCapabilitiesChooser)capabilitiesChooser, abstractGraphicsScreen, n, false);
        } else {
            if (null == fallbackGraphicsConfigurationFactory) {
                throw new InternalError("Native fallback GraphicsConfigurationFactory is null, but call issued for device: " + abstractGraphicsDevice + " of type " + abstractGraphicsDevice.getClass().getSimpleName());
            }
            if (gLCapabilitiesImmutable.getGLProfile().usesNativeGLES()) {
                if (DEBUG) {
                    System.err.println("EGLGraphicsConfigurationFactory.choose..: Handle native device " + abstractGraphicsDevice.getClass().getSimpleName());
                }
                if (null == (abstractGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)capabilitiesImmutable, (GLCapabilitiesImmutable)capabilitiesImmutable2, (GLCapabilitiesChooser)capabilitiesChooser, abstractGraphicsScreen, n, false)) || 0 == abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE)) {
                    abstractGraphicsConfiguration = null;
                    if (DEBUG) {
                        System.err.println("EGLGraphicsConfigurationFactory.choose..: No native visual ID, fallback ..");
                    }
                }
            }
            if (null == abstractGraphicsConfiguration) {
                if (DEBUG) {
                    System.err.println("EGLGraphicsConfigurationFactory.choose..: Delegate to " + fallbackGraphicsConfigurationFactory.getClass().getSimpleName());
                }
                abstractGraphicsConfiguration = fallbackGraphicsConfigurationFactory.chooseGraphicsConfiguration(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, abstractGraphicsScreen, n);
            }
        }
        return abstractGraphicsConfiguration;
    }

    protected static List<GLCapabilitiesImmutable> getAvailableCapabilities(EGLDrawableFactory eGLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice) {
        EGLDrawableFactory.SharedResource sharedResource = eGLDrawableFactory.getOrCreateSharedResourceImpl(abstractGraphicsDevice);
        if (null == sharedResource) {
            throw new GLException("Shared resource for device n/a: " + abstractGraphicsDevice);
        }
        EGLGraphicsDevice eGLGraphicsDevice = sharedResource.getDevice();
        long l = eGLGraphicsDevice.getHandle();
        if (0L == l) {
            throw new GLException("null eglDisplay");
        }
        ArrayList<GLCapabilitiesImmutable> arrayList = null;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        if (!EGL.eglGetConfigs(l, null, 0, intBuffer)) {
            throw new GLException("Graphics configuration get maxConfigs (eglGetConfigs) call failed, error " + EGLGraphicsConfigurationFactory.toHexString(EGL.eglGetError()));
        }
        if (0 == intBuffer.get(0)) {
            throw new GLException("Graphics configuration get maxConfigs (eglGetConfigs) no configs");
        }
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)intBuffer.get(0));
        if (!EGL.eglGetConfigs(l, pointerBuffer, pointerBuffer.capacity(), intBuffer)) {
            throw new GLException("Graphics configuration get all configs (eglGetConfigs) call failed, error " + EGLGraphicsConfigurationFactory.toHexString(EGL.eglGetError()));
        }
        if (intBuffer.get(0) > 0 && null != (arrayList = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(eGLGraphicsDevice, null, pointerBuffer, intBuffer.get(0), 15, false, false)) && arrayList.size() > 1) {
            Collections.sort(arrayList, EglCfgIDComparator);
        }
        return arrayList;
    }

    public static final GLCapabilitiesImmutable castOrCopyImmutable(CapabilitiesImmutable capabilitiesImmutable) {
        if (capabilitiesImmutable instanceof GLCapabilitiesImmutable) {
            return (GLCapabilitiesImmutable)capabilitiesImmutable;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault(GLDrawableFactory.getEGLFactory().getDefaultDevice()));
        return gLCapabilities.copyFrom(capabilitiesImmutable);
    }

    public static EGLGraphicsConfiguration chooseGraphicsConfigurationStatic(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n, boolean bl) {
        GLCapabilities gLCapabilities;
        boolean bl2;
        EGLGraphicsDevice eGLGraphicsDevice;
        if (gLCapabilitiesImmutable == null) {
            gLCapabilitiesImmutable = new GLCapabilities(null);
        }
        if (null == abstractGraphicsScreen) {
            throw new GLException("Null AbstractGraphicsScreen");
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        if (null == abstractGraphicsDevice) {
            throw new GLException("Null AbstractGraphicsDevice");
        }
        if (abstractGraphicsDevice instanceof EGLGraphicsDevice) {
            eGLGraphicsDevice = (EGLGraphicsDevice)abstractGraphicsDevice;
            if (eGLGraphicsDevice.getHandle() == 0L) {
                throw new GLException("Invalid EGL display: " + eGLGraphicsDevice);
            }
            bl2 = false;
        } else {
            eGLGraphicsDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(abstractGraphicsDevice);
            eGLGraphicsDevice.open();
            bl2 = true;
        }
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixGLCapabilities(gLCapabilitiesImmutable, GLDrawableFactory.getEGLFactory(), abstractGraphicsDevice);
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(eGLGraphicsDevice, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen, n, bl);
        if (null == eGLGraphicsConfiguration) {
            if (DEBUG) {
                System.err.println("eglChooseConfig failed with given capabilities " + gLCapabilitiesImmutable);
            }
            gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(4);
            gLCapabilities.setRedBits(8);
            gLCapabilities.setGreenBits(8);
            gLCapabilities.setBlueBits(8);
            gLCapabilities.setDepthBits(16);
            if (!gLCapabilitiesImmutable.isOnscreen()) {
                gLCapabilities.setOnscreen(false);
                gLCapabilities.setPBuffer(gLCapabilitiesImmutable.isPBuffer());
                gLCapabilities.setFBO(gLCapabilitiesImmutable.isFBO());
            }
            if (DEBUG) {
                System.err.println("trying fixed caps (1): " + gLCapabilities);
            }
            eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(eGLGraphicsDevice, gLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen, n, false);
        }
        if (null == eGLGraphicsConfiguration) {
            gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setRedBits(5);
            gLCapabilities.setGreenBits(6);
            gLCapabilities.setBlueBits(5);
            gLCapabilities.setDepthBits(16);
            if (!gLCapabilitiesImmutable.isOnscreen()) {
                gLCapabilities.setOnscreen(false);
                gLCapabilities.setPBuffer(gLCapabilitiesImmutable.isPBuffer());
                gLCapabilities.setFBO(gLCapabilitiesImmutable.isFBO());
            }
            if (DEBUG) {
                System.err.println("trying fixed caps (2): " + gLCapabilities);
            }
            eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(eGLGraphicsDevice, gLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen, n, false);
        }
        if (null == eGLGraphicsConfiguration) {
            gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(4);
            gLCapabilities.setRedBits(5);
            gLCapabilities.setGreenBits(6);
            gLCapabilities.setBlueBits(5);
            gLCapabilities.setDepthBits(16);
            if (!gLCapabilitiesImmutable.isOnscreen()) {
                gLCapabilities.setOnscreen(false);
                gLCapabilities.setPBuffer(gLCapabilitiesImmutable.isPBuffer());
                gLCapabilities.setFBO(gLCapabilitiesImmutable.isFBO());
            }
            if (DEBUG) {
                System.err.println("trying fixed caps (3): " + gLCapabilities);
            }
            eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(eGLGraphicsDevice, gLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen, n, false);
        }
        if (null == eGLGraphicsConfiguration) {
            throw new GLException("Graphics configuration failed [direct caps, eglGetConfig/chooser and fixed-caps(1-3)]");
        }
        if (bl2) {
            ((EGLGLCapabilities)eGLGraphicsConfiguration.getChosenCapabilities()).setEGLConfig(0L);
            eGLGraphicsDevice.close();
        }
        return eGLGraphicsConfiguration;
    }

    static EGLGraphicsConfiguration eglChooseConfig(EGLGraphicsDevice eGLGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n, boolean bl) {
        int n2;
        Cloneable cloneable;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        long l = eGLGraphicsDevice.getHandle();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        GLRendererQuirks gLRendererQuirks = GLDrawableFactory.getEGLFactory().getRendererQuirks(eGLGraphicsDevice, gLProfile);
        int n3 = GLGraphicsConfigurationUtil.getExclusiveWinAttributeBits(gLCapabilitiesImmutable);
        ArrayList<GLCapabilitiesImmutable> arrayList = null;
        int n4 = -1;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        if (!EGL.eglGetConfigs(l, null, 0, intBuffer)) {
            throw new GLException("EGLGraphicsConfiguration.eglChooseConfig: Get maxConfigs (eglGetConfigs) call failed, error " + EGLGraphicsConfigurationFactory.toHexString(EGL.eglGetError()));
        }
        if (0 == intBuffer.get(0)) {
            throw new GLException("EGLGraphicsConfiguration.eglChooseConfig: Get maxConfigs (eglGetConfigs) no configs");
        }
        int n5 = intBuffer.get(0);
        if (DEBUG) {
            System.err.println("EGLGraphicsConfiguration.eglChooseConfig: eglChooseConfig eglDisplay " + EGLGraphicsConfigurationFactory.toHexString(l) + ", nativeVisualID " + EGLGraphicsConfigurationFactory.toHexString(n) + ", capsChosen " + gLCapabilitiesImmutable + ", winbits " + GLGraphicsConfigurationUtil.winAttributeBits2String(null, n3).toString() + ", fboAvail " + GLContext.isFBOAvailable(eGLGraphicsDevice, gLProfile) + ", device " + eGLGraphicsDevice + ", " + eGLGraphicsDevice.getUniqueID() + ", numEGLConfigs " + n5);
        }
        IntBuffer intBuffer2 = EGLGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable);
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)intBuffer.get(0));
        if (0 == n) {
            if (!EGL.eglChooseConfig(l, intBuffer2, pointerBuffer, pointerBuffer.capacity(), intBuffer)) {
                if (DEBUG) {
                    System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 eglChooseConfig: false");
                }
                intBuffer.put(0, 0);
                bl4 = false;
            } else {
                bl4 = intBuffer.get(0) > 0;
            }
        } else {
            if (DEBUG) {
                System.err.println("EGLGraphicsConfiguration.eglChooseConfig: Skipped due to given visualID: " + EGLGraphicsConfigurationFactory.toHexString(n));
            }
            bl4 = false;
        }
        boolean bl5 = gLCapabilitiesImmutable.isBitmap() || gLCapabilitiesImmutable.isPBuffer();
        boolean bl6 = GLRendererQuirks.exist(gLRendererQuirks, 24) || bl5 && GLRendererQuirks.exist(gLRendererQuirks, 25);
        boolean bl7 = !bl6 && bl4 && !bl && gLCapabilitiesImmutable.isBackgroundOpaque();
        boolean bl8 = bl3 = null == gLCapabilitiesChooser && bl7;
        if (bl4) {
            arrayList = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(eGLGraphicsDevice, gLProfile, pointerBuffer, intBuffer.get(0), n3, bl, bl3);
            if (arrayList.size() > 0) {
                if (bl7) {
                    n4 = 0;
                }
                if (DEBUG) {
                    long l2 = pointerBuffer.get(0);
                    System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 eglChooseConfig: recommended fbcfg " + EGLGraphicsConfigurationFactory.toHexString(l2) + ", idx " + n4);
                    System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 useRecommendedIndex " + bl7 + ", shallSkipCapsChooser " + bl3);
                    if (0 <= n4) {
                        System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 fbcfg recommended caps " + arrayList.get(n4));
                    }
                }
            } else if (DEBUG) {
                System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 eglChooseConfig: no caps for recommended fbcfg " + EGLGraphicsConfigurationFactory.toHexString(pointerBuffer.get(0)));
                System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 useRecommendedIndex " + bl7 + ", shallSkipCapsChooser " + bl3);
            }
        } else if (DEBUG) {
            System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 eglChooseConfig: no configs");
            System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 useRecommendedIndex " + bl7 + ", shallSkipCapsChooser " + bl3);
        }
        if (null == arrayList || 0 == arrayList.size()) {
            n4 = -1;
            if (!EGL.eglGetConfigs(l, pointerBuffer, pointerBuffer.capacity(), intBuffer)) {
                throw new GLException("EGLGraphicsConfiguration.eglChooseConfig: #2 Get all configs (eglGetConfigs) call failed, error " + EGLGraphicsConfigurationFactory.toHexString(EGL.eglGetError()));
            }
            if (intBuffer.get(0) > 0) {
                arrayList = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(eGLGraphicsDevice, gLProfile, pointerBuffer, intBuffer.get(0), n3, bl, false);
            }
        }
        if (null == arrayList || 0 == arrayList.size()) {
            if (DEBUG) {
                System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #2 Graphics configuration 1st choice and 2nd choice failed - no configs");
                arrayList = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(eGLGraphicsDevice, gLProfile, pointerBuffer, intBuffer.get(0), 15, bl, false);
                EGLGraphicsConfigurationFactory.printCaps("AllCaps", arrayList, System.err);
            }
            return null;
        }
        boolean bl9 = bl2 = bl3 && 0 <= n4;
        if (DEBUG) {
            System.err.println("EGLGraphicsConfiguration.eglChooseConfig: got configs: " + arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                System.err.println(i + ": " + arrayList.get(i));
            }
        }
        ArrayList arrayList2 = new ArrayList();
        if (!bl2 && bl5 && GLRendererQuirks.exist(gLRendererQuirks, 25)) {
            arrayList2.add(new CapabilitiesFilter.TestMoreColorCompBits(8));
        }
        if (0 != n) {
            arrayList2.add(new CapabilitiesFilter.TestUnmatchedNativeVisualID(n));
        }
        if (0 < gLCapabilitiesImmutable.getDepthBits()) {
            arrayList2.add(new GLCapabilitiesFilter.TestLessDepthBits(1));
        }
        if (arrayList2.size() > 0) {
            cloneable = CapabilitiesFilter.removeMatching(arrayList, arrayList2);
            if (((ArrayList)cloneable).size() > 0 && DEBUG) {
                System.err.println("EGLGraphicsConfiguration.eglChooseConfig: filtered configs: " + arrayList.size());
                for (int i = 0; i < arrayList.size(); ++i) {
                    System.err.println(i + ": " + arrayList.get(i));
                }
            }
            if (0 == arrayList.size()) {
                arrayList = cloneable;
                if (DEBUG) {
                    System.err.println("EGLGraphicsConfiguration.eglChooseConfig: post filter visualID " + EGLGraphicsConfigurationFactory.toHexString(n) + " no config found, revert to all");
                }
            }
        }
        if (0 > (n2 = bl2 ? n4 : EGLGraphicsConfigurationFactory.chooseCapabilities(gLCapabilitiesChooser, gLCapabilitiesImmutable, arrayList, n4))) {
            if (DEBUG) {
                System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #2 chooseCapabilities failed");
            }
            return null;
        }
        cloneable = (EGLGLCapabilities)arrayList.get(n2);
        EGLGraphicsConfiguration eGLGraphicsConfiguration = new EGLGraphicsConfiguration(abstractGraphicsScreen, (EGLGLCapabilities)cloneable, gLCapabilitiesImmutable2, gLCapabilitiesChooser);
        if (DEBUG) {
            System.err.println("EGLGraphicsConfiguration.eglChooseConfig: X chosen :" + n2 + ", eglConfig: " + EGLGraphicsConfigurationFactory.toHexString(((EGLGLCapabilities)cloneable).getEGLConfig()) + ": " + eGLGraphicsConfiguration);
        }
        return eGLGraphicsConfiguration;
    }

    static ArrayList<GLCapabilitiesImmutable> eglConfigs2GLCaps(EGLGraphicsDevice eGLGraphicsDevice, GLProfile gLProfile, PointerBuffer pointerBuffer, int n, int n2, boolean bl, boolean bl2) {
        GLRendererQuirks gLRendererQuirks = GLRendererQuirks.getStickyDeviceQuirks(GLDrawableFactory.getEGLFactory().getDefaultDevice());
        ArrayList<GLCapabilitiesImmutable> arrayList = new ArrayList<GLCapabilitiesImmutable>(n);
        for (int i = 0; i < n; ++i) {
            EGLGLCapabilities eGLGLCapabilities = EGLGraphicsConfiguration.EGLConfig2Capabilities(gLRendererQuirks, eGLGraphicsDevice, gLProfile, pointerBuffer.get(i), n2, bl);
            if (null == eGLGLCapabilities) continue;
            arrayList.add(eGLGLCapabilities);
            if (bl2) break;
        }
        return arrayList;
    }

    static void printCaps(String string, List<GLCapabilitiesImmutable> list, PrintStream printStream) {
        for (int i = 0; i < list.size(); ++i) {
            printStream.println(string + "[" + i + "] " + list.get(i));
        }
    }
}

