/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.test;

import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.ExifReader;
import java.io.File;
import junit.framework.TestCase;

public class ExifReaderTest
extends TestCase {
    public ExifReaderTest(String s) {
        super(s);
    }

    public void testLoadFujiFilmJpeg() throws Exception {
        String jpegWithExif = "src/com/drew/metadata/exif/test/withExif.jpg";
        Metadata metadata = new ExifReader(new File(jpegWithExif)).extract();
        Directory directory = metadata.getDirectory(ExifDirectory.class);
        ExifReaderTest.assertEquals((String)"80", (String)directory.getDescription(34855));
    }

    public void testLoadJpegWithoutExifData() throws Exception {
        String jpegNoExif = "src/com/drew/metadata/exif/test/noExif.jpg";
        Metadata metadata = new ExifReader(new File(jpegNoExif)).extract();
        ExifReaderTest.assertTrue((!metadata.containsDirectory(ExifDirectory.class) ? 1 : 0) != 0);
    }

    public void testLoadJpegWithBadExifData() throws Exception {
        String jpegBadExif = "src/com/drew/metadata/exif/test/badExif.jpg";
        Metadata metadata = new ExifReader(new File(jpegBadExif)).extract();
        ExifReaderTest.assertEquals((int)0, (int)metadata.getDirectory(ExifDirectory.class).getTagCount());
    }

    public void testCrashRegressionTest() throws Exception {
        String fileName = "src/com/drew/metadata/exif/test/crash01.jpg";
        Metadata metadata = new ExifReader(new File(fileName)).extract();
        ExifReaderTest.assertTrue((metadata.getDirectory(ExifDirectory.class).getTagCount() > 0 ? 1 : 0) != 0);
    }

    public void testThumbnailOffset() throws Exception {
        String fileName = "src/com/drew/metadata/exif/test/manuallyAddedThumbnail.jpg";
        Metadata metadata = new ExifReader(new File(fileName)).extract();
        Directory directory = metadata.getDirectory(ExifDirectory.class);
        ExifReaderTest.assertEquals((int)192, (int)directory.getInt(513));
    }

    public void testThumbnailLength() throws Exception {
        String fileName = "src/com/drew/metadata/exif/test/manuallyAddedThumbnail.jpg";
        Metadata metadata = new ExifReader(new File(fileName)).extract();
        Directory directory = metadata.getDirectory(ExifDirectory.class);
        ExifReaderTest.assertEquals((int)2970, (int)directory.getInt(514));
    }

    public void testDateTime() throws Exception {
        String fileName = "src/com/drew/metadata/exif/test/manuallyAddedThumbnail.jpg";
        Metadata metadata = new ExifReader(new File(fileName)).extract();
        Directory directory = metadata.getDirectory(ExifDirectory.class);
        ExifReaderTest.assertEquals((String)"2002:11:27 18:00:35", (String)directory.getString(306));
    }

    public void testXResolution() throws Exception {
        String fileName = "src/com/drew/metadata/exif/test/manuallyAddedThumbnail.jpg";
        Metadata metadata = new ExifReader(new File(fileName)).extract();
        Directory directory = metadata.getDirectory(ExifDirectory.class);
        Rational rational = directory.getRational(282);
        ExifReaderTest.assertEquals((int)72, (int)rational.getNumerator());
        ExifReaderTest.assertEquals((int)1, (int)rational.getDenominator());
    }

    public void testYResolution() throws Exception {
        String fileName = "src/com/drew/metadata/exif/test/manuallyAddedThumbnail.jpg";
        Metadata metadata = new ExifReader(new File(fileName)).extract();
        Directory directory = metadata.getDirectory(ExifDirectory.class);
        Rational rational = directory.getRational(283);
        ExifReaderTest.assertEquals((int)72, (int)rational.getNumerator());
        ExifReaderTest.assertEquals((int)1, (int)rational.getDenominator());
    }

    public void testCompression() throws Exception {
        String fileName = "src/com/drew/metadata/exif/test/manuallyAddedThumbnail.jpg";
        Metadata metadata = new ExifReader(new File(fileName)).extract();
        Directory directory = metadata.getDirectory(ExifDirectory.class);
        ExifReaderTest.assertEquals((int)6, (int)directory.getInt(259));
    }

    public void testStackOverflowOnRevisitationOfSameDirectory() throws Exception {
        File metadataFile = new File("src/com/drew/metadata/exif/test/recursiveDirectories.metadata");
        Metadata metadata = new ExifReader(JpegSegmentData.FromFile(metadataFile)).extract();
        metadata.getDirectory(ExifDirectory.class);
    }
}

