/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery.vectortile.mapbox;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.Command;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.CommandInteger;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.GeometryTypes;
import org.openstreetmap.josm.tools.I18n;

public class Geometry {
    final Collection<Shape> shapes;

    public Geometry(GeometryTypes geometryType, List<CommandInteger> commands) {
        if (geometryType == GeometryTypes.POINT) {
            this.shapes = new ArrayList<Shape>(commands.size());
            this.initializePoints(geometryType, commands);
        } else if (geometryType == GeometryTypes.LINESTRING || geometryType == GeometryTypes.POLYGON) {
            this.shapes = new ArrayList<Shape>(1);
            this.initializeWayGeometry(geometryType, commands);
        } else {
            this.shapes = Collections.emptyList();
        }
    }

    private void initializePoints(GeometryTypes geometryType, List<CommandInteger> commands) {
        for (CommandInteger command : commands) {
            short[] operations = command.getOperations();
            if (command.getType() == Command.MoveTo && operations.length % 2 == 0 && operations.length > 0) {
                for (int i = 0; i < operations.length / 2; ++i) {
                    this.shapes.add(new Ellipse2D.Float(operations[2 * i], operations[2 * i + 1], 0.0f, 0.0f));
                }
                continue;
            }
            throw new IllegalArgumentException(I18n.tr("{0} with {1} arguments is not understood", new Object[]{geometryType, operations.length}));
        }
    }

    private void initializeWayGeometry(GeometryTypes geometryType, List<CommandInteger> commands) {
        Path2D.Float line = null;
        Area area = null;
        int x = 0;
        int y = 0;
        int maxArraySize = commands.stream().filter(command -> command.getType() != Command.ClosePath).mapToInt(command -> command.getOperations().length).sum();
        ArrayList<Integer> xArray = new ArrayList<Integer>(maxArraySize);
        ArrayList<Integer> yArray = new ArrayList<Integer>(maxArraySize);
        for (CommandInteger command2 : commands) {
            short[] operations = command2.getOperations();
            if (command2.getType() == Command.MoveTo && operations.length == 2) {
                line = new Path2D.Float(1, commands.size());
                line.moveTo(x += operations[0], y += operations[1]);
                xArray.add(x);
                yArray.add(y);
                this.shapes.add(line);
                continue;
            }
            if (command2.getType() == Command.LineTo && operations.length % 2 == 0 && line != null) {
                for (int i2 = 0; i2 < operations.length / 2; ++i2) {
                    xArray.add(x += operations[2 * i2]);
                    yArray.add(y += operations[2 * i2 + 1]);
                    line.lineTo(x, y);
                }
                continue;
            }
            if (geometryType == GeometryTypes.POLYGON && command2.getType() == Command.ClosePath && line != null) {
                this.shapes.remove(line);
                if (area == null) {
                    area = new Area();
                    this.shapes.add(area);
                }
                double areaAreaSq = Geometry.calculateSurveyorsArea(xArray.stream().mapToInt(i -> i).toArray(), yArray.stream().mapToInt(i -> i).toArray());
                Area nArea = new Area(line);
                if (areaAreaSq > 0.0) {
                    area.add(nArea);
                } else if (areaAreaSq < 0.0) {
                    area.exclusiveOr(nArea);
                } else {
                    throw new IllegalArgumentException(I18n.tr("{0} cannot have zero area", new Object[]{geometryType}));
                }
                xArray.clear();
                yArray.clear();
                continue;
            }
            throw new IllegalArgumentException(I18n.tr("{0} with {1} arguments is not understood", new Object[]{geometryType, operations.length}));
        }
    }

    static double calculateSurveyorsArea(int[] xArray, int[] yArray) {
        if (xArray.length != yArray.length) {
            throw new IllegalArgumentException("Cannot calculate areas when arrays are uneven");
        }
        if (xArray.length < 3) {
            return 0.0;
        }
        int area = 0;
        for (int i = 0; i < xArray.length - 1; ++i) {
            area += xArray[i] * yArray[i + 1] - xArray[i + 1] * yArray[i];
        }
        return (double)(area += xArray[xArray.length - 1] * yArray[0] - xArray[0] * yArray[yArray.length - 1]) / 2.0;
    }

    public Collection<Shape> getShapes() {
        return Collections.unmodifiableCollection(this.shapes);
    }
}

