/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;

public final class PollFunction<K, V>
implements ListBucketBaseFunction<K, V, Collection<V>> {
    public static final AdvancedExternalizer<PollFunction> EXTERNALIZER = new Externalizer();
    private final boolean first;
    private final long count;

    public PollFunction(boolean first, long count) {
        this.first = first;
        this.count = count;
    }

    public Collection<V> apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            if (this.count == 0L) {
                return List.of();
            }
            ListBucket.ListBucketResult result = ((ListBucket)existing.get()).poll(this.first, this.count);
            if (result.bucket().isEmpty()) {
                entryView.remove();
            } else {
                entryView.set(result.bucket(), new MetaParam.Writable[0]);
            }
            return result.result();
        }
        return null;
    }

    private static class Externalizer
    implements AdvancedExternalizer<PollFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends PollFunction>> getTypeClasses() {
            return Collections.singleton(PollFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.POLL_FUNCTION;
        }

        public void writeObject(ObjectOutput output, PollFunction object) throws IOException {
            output.writeBoolean(object.first);
            output.writeLong(object.count);
        }

        public PollFunction readObject(ObjectInput input) throws IOException {
            return new PollFunction(input.readBoolean(), input.readLong());
        }
    }
}

