/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AssertionFailure;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.dialect.function.json.JsonTableFunction;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleTableGroupProducer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.JsonExistsErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonQueryEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonQueryErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonQueryWrapMode;
import org.hibernate.sql.ast.tree.expression.JsonTableColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableColumnsClause;
import org.hibernate.sql.ast.tree.expression.JsonTableErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonTableExistsColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableNestedColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableOrdinalityColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableQueryColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableValueColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonValueErrorBehavior;
import org.hibernate.type.spi.TypeConfiguration;

public class SQLServerJsonTableFunction
extends JsonTableFunction {
    public SQLServerJsonTableFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
    }

    @Override
    protected void renderJsonTable(SqlAppender sqlAppender, JsonTableFunction.JsonTableArguments arguments, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("(select");
        this.renderColumnSelects(sqlAppender, arguments.columnsClause(), 0, walker);
        sqlAppender.appendSql(" from openjson(");
        arguments.jsonDocument().accept(walker);
        if (arguments.jsonPath() != null) {
            sqlAppender.appendSql(',');
            String rawJsonPath = arguments.passingClause() != null ? JsonPathHelper.inlinedJsonPathIncludingPassingClause(arguments.jsonPath(), arguments.passingClause(), walker) : (String)walker.getLiteralValue(arguments.jsonPath());
            Object jsonPath = arguments.errorBehavior() == JsonTableErrorBehavior.ERROR ? "strict " + rawJsonPath : rawJsonPath;
            sqlAppender.appendSingleQuoteEscapedString((String)(((String)jsonPath).endsWith("[*]") ? ((String)jsonPath).substring(0, ((String)jsonPath).length() - 3) : jsonPath));
        } else if (arguments.errorBehavior() == JsonTableErrorBehavior.ERROR) {
            sqlAppender.appendSql(",'strict $'");
        }
        sqlAppender.appendSql(")");
        this.renderColumnDefinitions(sqlAppender, arguments.columnsClause(), 0, walker);
        sqlAppender.appendSql(" t0");
        this.renderNestedColumnJoins(sqlAppender, arguments.columnsClause(), 0, walker);
        sqlAppender.appendSql(')');
    }

    protected int renderNestedColumnJoins(SqlAppender sqlAppender, JsonTableColumnsClause jsonTableColumnsClause, int clauseLevel, SqlAstTranslator<?> walker) {
        int currentClauseLevel = clauseLevel;
        for (JsonTableColumnDefinition columnDefinition : jsonTableColumnsClause.getColumnDefinitions()) {
            if (!(columnDefinition instanceof JsonTableNestedColumnDefinition)) continue;
            JsonTableNestedColumnDefinition nestedColumnDefinition = (JsonTableNestedColumnDefinition)columnDefinition;
            int nextClauseLevel = currentClauseLevel + 1;
            sqlAppender.appendSql(" cross apply (select");
            this.renderColumnSelects(sqlAppender, nestedColumnDefinition.columns(), nextClauseLevel, walker);
            sqlAppender.appendSql(" from openjson(t");
            sqlAppender.appendSql(clauseLevel);
            sqlAppender.appendSql(".nested_");
            sqlAppender.appendSql(nextClauseLevel);
            sqlAppender.appendSql("_)");
            this.renderColumnDefinitions(sqlAppender, nestedColumnDefinition.columns(), nextClauseLevel, walker);
            sqlAppender.appendSql(" t");
            sqlAppender.appendSql(nextClauseLevel);
            sqlAppender.appendSql(") t");
            sqlAppender.appendSql(nextClauseLevel);
            currentClauseLevel = this.renderNestedColumnJoins(sqlAppender, nestedColumnDefinition.columns(), nextClauseLevel, walker);
        }
        return currentClauseLevel;
    }

    protected void renderColumnSelects(SqlAppender sqlAppender, JsonTableColumnsClause jsonTableColumnsClause, int clauseLevel, SqlAstTranslator<?> walker) {
        int currentClauseLevel = clauseLevel;
        int separator = 32;
        for (JsonTableColumnDefinition columnDefinition : jsonTableColumnsClause.getColumnDefinitions()) {
            sqlAppender.appendSql((char)separator);
            if (columnDefinition instanceof JsonTableValueColumnDefinition) {
                JsonTableValueColumnDefinition valueColumnDefinition = (JsonTableValueColumnDefinition)columnDefinition;
                if (valueColumnDefinition.errorBehavior() != null && valueColumnDefinition.errorBehavior() != JsonValueErrorBehavior.ERROR) {
                    throw new QueryException("Can't emulate on error clause for value within json_table() on SQL server");
                }
                sqlAppender.appendSql('t');
                sqlAppender.appendSql(clauseLevel);
                sqlAppender.appendSql('.');
                sqlAppender.appendSql(valueColumnDefinition.name());
            } else if (columnDefinition instanceof JsonTableQueryColumnDefinition) {
                JsonTableQueryColumnDefinition queryColumnDefinition = (JsonTableQueryColumnDefinition)columnDefinition;
                if (queryColumnDefinition.errorBehavior() != null && queryColumnDefinition.errorBehavior() != JsonQueryErrorBehavior.ERROR) {
                    throw new QueryException("Can't emulate on error clause for query within json_table() on SQL server");
                }
                if (queryColumnDefinition.emptyBehavior() == JsonQueryEmptyBehavior.EMPTY_ARRAY || queryColumnDefinition.emptyBehavior() == JsonQueryEmptyBehavior.EMPTY_OBJECT) {
                    sqlAppender.appendSql("coalesce(");
                }
                if (queryColumnDefinition.wrapMode() == JsonQueryWrapMode.WITH_WRAPPER) {
                    sqlAppender.appendSql("'['+");
                }
                sqlAppender.appendSql('t');
                sqlAppender.appendSql(clauseLevel);
                sqlAppender.appendSql('.');
                sqlAppender.appendSql(queryColumnDefinition.name());
                if (queryColumnDefinition.wrapMode() == JsonQueryWrapMode.WITH_WRAPPER) {
                    sqlAppender.appendSql("+']'");
                }
                if (queryColumnDefinition.emptyBehavior() == JsonQueryEmptyBehavior.EMPTY_ARRAY) {
                    sqlAppender.appendSql(",'[]')");
                } else if (queryColumnDefinition.emptyBehavior() == JsonQueryEmptyBehavior.EMPTY_OBJECT) {
                    sqlAppender.appendSql(",'{}')");
                }
                sqlAppender.appendSql(' ');
                sqlAppender.appendSql(queryColumnDefinition.name());
            } else if (columnDefinition instanceof JsonTableOrdinalityColumnDefinition) {
                JsonTableOrdinalityColumnDefinition ordinalityColumnDefinition = (JsonTableOrdinalityColumnDefinition)columnDefinition;
                sqlAppender.appendSql("row_number() over (order by (select null)) ");
                sqlAppender.appendSql(ordinalityColumnDefinition.name());
            } else if (columnDefinition instanceof JsonTableExistsColumnDefinition) {
                String terminalKey;
                JsonTableExistsColumnDefinition existsColumnDefinition = (JsonTableExistsColumnDefinition)columnDefinition;
                if (existsColumnDefinition.errorBehavior() == JsonExistsErrorBehavior.FALSE) {
                    throw new QueryException("Can't emulate exists false on error for json_table() on SQL Server");
                }
                Object jsonPath = existsColumnDefinition.jsonPath() == null ? "$." + existsColumnDefinition.name() : existsColumnDefinition.jsonPath();
                List<JsonPathHelper.JsonPathElement> pathElements = JsonPathHelper.parseJsonPathElements((String)jsonPath);
                JsonPathHelper.JsonPathElement lastPathElement = pathElements.get(pathElements.size() - 1);
                String prefix = JsonPathHelper.toJsonPath(pathElements, 0, pathElements.size() - 1);
                if (lastPathElement instanceof JsonPathHelper.JsonIndexAccess) {
                    JsonPathHelper.JsonIndexAccess indexAccess = (JsonPathHelper.JsonIndexAccess)lastPathElement;
                    terminalKey = String.valueOf(indexAccess.index());
                } else if (lastPathElement instanceof JsonPathHelper.JsonAttribute) {
                    JsonPathHelper.JsonAttribute attribute = (JsonPathHelper.JsonAttribute)lastPathElement;
                    terminalKey = attribute.attribute();
                } else {
                    throw new AssertionFailure("Unrecognized json path element: " + String.valueOf(lastPathElement));
                }
                sqlAppender.appendSql("coalesce((select 1 from openjson(t");
                sqlAppender.appendSql(clauseLevel);
                sqlAppender.appendSql(".");
                sqlAppender.appendSql(existsColumnDefinition.name());
                sqlAppender.appendSql(',');
                sqlAppender.appendSingleQuoteEscapedString(prefix);
                sqlAppender.appendSql(") t where t.[key]=");
                sqlAppender.appendSingleQuoteEscapedString(terminalKey);
                sqlAppender.appendSql("),0) ");
                sqlAppender.appendSql(existsColumnDefinition.name());
            } else {
                JsonTableNestedColumnDefinition nestedColumnDefinition = (JsonTableNestedColumnDefinition)columnDefinition;
                sqlAppender.appendSql("t");
                sqlAppender.appendSql(currentClauseLevel + 1);
                sqlAppender.appendSql(".*");
                currentClauseLevel += 1 + this.countNestedColumnDefinitions(nestedColumnDefinition.columns());
            }
            separator = 44;
        }
    }

    protected void renderColumnDefinitions(SqlAppender sqlAppender, JsonTableColumnsClause jsonTableColumnsClause, int clauseLevel, SqlAstTranslator<?> walker) {
        int currentClauseLevel = clauseLevel;
        String separator = " with (";
        for (JsonTableColumnDefinition columnDefinition : jsonTableColumnsClause.getColumnDefinitions()) {
            if (columnDefinition instanceof JsonTableOrdinalityColumnDefinition) continue;
            sqlAppender.appendSql(separator);
            if (columnDefinition instanceof JsonTableQueryColumnDefinition) {
                JsonTableQueryColumnDefinition definition = (JsonTableQueryColumnDefinition)columnDefinition;
                this.renderJsonQueryColumnDefinition(sqlAppender, definition, clauseLevel, walker);
            } else if (columnDefinition instanceof JsonTableValueColumnDefinition) {
                JsonTableValueColumnDefinition definition = (JsonTableValueColumnDefinition)columnDefinition;
                this.renderJsonValueColumnDefinition(sqlAppender, definition, clauseLevel, walker);
            } else if (columnDefinition instanceof JsonTableExistsColumnDefinition) {
                JsonTableExistsColumnDefinition definition = (JsonTableExistsColumnDefinition)columnDefinition;
                this.renderJsonExistsColumnDefinition(sqlAppender, definition, clauseLevel, walker);
            } else {
                JsonTableNestedColumnDefinition nestedColumnDefinition = (JsonTableNestedColumnDefinition)columnDefinition;
                currentClauseLevel = this.renderJsonNestedColumnDefinition(sqlAppender, nestedColumnDefinition, currentClauseLevel + 1, walker);
            }
            separator = ",";
        }
        if (",".equals(separator)) {
            sqlAppender.appendSql(')');
        }
    }

    @Override
    protected void renderColumnPath(String name, @Nullable String jsonPath, SqlAppender sqlAppender, SqlAstTranslator<?> walker) {
        if (jsonPath != null) {
            sqlAppender.appendSql(' ');
            sqlAppender.appendSingleQuoteEscapedString(jsonPath);
        }
    }

    @Override
    protected int renderJsonNestedColumnDefinition(SqlAppender sqlAppender, JsonTableNestedColumnDefinition definition, int clauseLevel, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("nested_");
        sqlAppender.appendSql(clauseLevel);
        sqlAppender.appendSql("_ nvarchar(max) ");
        String jsonPath = definition.jsonPath().endsWith("[*]") ? definition.jsonPath().substring(0, definition.jsonPath().length() - 3) : definition.jsonPath();
        sqlAppender.appendSingleQuoteEscapedString(jsonPath);
        sqlAppender.appendSql(" as json");
        return clauseLevel + this.countNestedColumnDefinitions(definition.columns());
    }

    @Override
    protected void renderJsonQueryColumnDefinition(SqlAppender sqlAppender, JsonTableQueryColumnDefinition definition, int clauseLevel, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(" nvarchar(max)");
        this.renderColumnPath(definition.name(), definition.jsonPath(), sqlAppender, walker);
        sqlAppender.appendSql(" as json");
    }

    @Override
    protected void renderJsonValueColumnDefinition(SqlAppender sqlAppender, JsonTableValueColumnDefinition definition, int clauseLevel, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(' ');
        sqlAppender.appendSql(this.determineColumnType(definition.type(), walker));
        this.renderColumnPath(definition.name(), definition.jsonPath(), sqlAppender, walker);
    }

    @Override
    protected void renderJsonExistsColumnDefinition(SqlAppender sqlAppender, JsonTableExistsColumnDefinition definition, int clauseLevel, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(" nvarchar(max) '$' as json");
    }
}

