/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.pagination;

import java.util.regex.Pattern;
import org.hibernate.dialect.pagination.AbstractSimpleLimitHandler;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class RowsLimitHandler
extends AbstractSimpleLimitHandler {
    public static final RowsLimitHandler INSTANCE = new RowsLimitHandler();
    private static final Pattern FOR_UPDATE_PATTERN = Pattern.compile("\\s+for\\s+update\\b|\\s+with\\s+lock\\b|\\s*;?\\s*$", 2);

    protected String limitClause(boolean hasFirstRow) {
        return hasFirstRow ? " rows ? to ?" : " rows ?";
    }

    protected String limitClause(boolean hasFirstRow, int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
        String firstParameter = parameterMarkerStrategy.createMarker(jdbcParameterCount + 1, null);
        if (hasFirstRow) {
            return " rows " + firstParameter + " to " + parameterMarkerStrategy.createMarker(jdbcParameterCount + 2, null);
        }
        return " rows " + firstParameter;
    }

    protected String offsetOnlyClause() {
        return " rows ? to 2147483647";
    }

    protected String offsetOnlyClause(int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
        return " rows " + parameterMarkerStrategy.createMarker(jdbcParameterCount + 1, null) + " to 2147483647";
    }

    public final boolean useMaxForLimit() {
        return true;
    }

    public int convertToFirstRowValue(int zeroBasedFirstResult) {
        return zeroBasedFirstResult + 1;
    }

    protected Pattern getForUpdatePattern() {
        return FOR_UPDATE_PATTERN;
    }

    public boolean supportsOffset() {
        return true;
    }

    public boolean processSqlMutatesState() {
        return false;
    }
}

