/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jsmpp.util.TimeFormatter;

public class RelativeTimeFormatter
implements TimeFormatter {
    private static TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
    private static final String DATE_FORMAT = "{0,number,00}{1,number,00}{2,number,00}{3,number,00}{4,number,00}{5,number,00}000R";

    @Override
    public String format(Calendar calendar) {
        Calendar smscCalendar = Calendar.getInstance();
        return this.format(calendar, smscCalendar);
    }

    public String format(Calendar calendar, Calendar smscCalendar) {
        if (calendar == null || smscCalendar == null) {
            return null;
        }
        long diffTimeInMillis = calendar.getTimeInMillis() - smscCalendar.getTimeInMillis();
        if (diffTimeInMillis < 0L) {
            throw new IllegalArgumentException("The requested relative time has already past.");
        }
        Calendar offsetEpoch = Calendar.getInstance(utcTimeZone);
        offsetEpoch.setTimeInMillis(diffTimeInMillis);
        int years = offsetEpoch.get(1) - 1970;
        int months = offsetEpoch.get(2);
        int days = offsetEpoch.get(5) - 1;
        int hours = offsetEpoch.get(11);
        int minutes = offsetEpoch.get(12);
        int seconds = offsetEpoch.get(13);
        if (years >= 100) {
            throw new IllegalArgumentException("The requested relative time is more then a century (" + years + " years).");
        }
        return RelativeTimeFormatter.format(years, months, days, hours, minutes, seconds);
    }

    @Override
    public String format(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return this.format(cal);
    }

    public static final String format(Integer year, Integer month, Integer day, Integer hour, Integer minute, Integer second) {
        Object[] args = new Object[]{year, month, day, hour, minute, second};
        return MessageFormat.format(DATE_FORMAT, args);
    }
}

