/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.VpnTunnelProvisioningStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActiveVpnTunnelStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActiveVpnTunnelStatus> {
    private static final SdkField<String> PHASE1_ENCRYPTION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Phase1EncryptionAlgorithm").getter(ActiveVpnTunnelStatus.getter(ActiveVpnTunnelStatus::phase1EncryptionAlgorithm)).setter(ActiveVpnTunnelStatus.setter(Builder::phase1EncryptionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1EncryptionAlgorithm").unmarshallLocationName("phase1EncryptionAlgorithm").build()}).build();
    private static final SdkField<String> PHASE2_ENCRYPTION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Phase2EncryptionAlgorithm").getter(ActiveVpnTunnelStatus.getter(ActiveVpnTunnelStatus::phase2EncryptionAlgorithm)).setter(ActiveVpnTunnelStatus.setter(Builder::phase2EncryptionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2EncryptionAlgorithm").unmarshallLocationName("phase2EncryptionAlgorithm").build()}).build();
    private static final SdkField<String> PHASE1_INTEGRITY_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Phase1IntegrityAlgorithm").getter(ActiveVpnTunnelStatus.getter(ActiveVpnTunnelStatus::phase1IntegrityAlgorithm)).setter(ActiveVpnTunnelStatus.setter(Builder::phase1IntegrityAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1IntegrityAlgorithm").unmarshallLocationName("phase1IntegrityAlgorithm").build()}).build();
    private static final SdkField<String> PHASE2_INTEGRITY_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Phase2IntegrityAlgorithm").getter(ActiveVpnTunnelStatus.getter(ActiveVpnTunnelStatus::phase2IntegrityAlgorithm)).setter(ActiveVpnTunnelStatus.setter(Builder::phase2IntegrityAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2IntegrityAlgorithm").unmarshallLocationName("phase2IntegrityAlgorithm").build()}).build();
    private static final SdkField<Integer> PHASE1_DH_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Phase1DHGroup").getter(ActiveVpnTunnelStatus.getter(ActiveVpnTunnelStatus::phase1DHGroup)).setter(ActiveVpnTunnelStatus.setter(Builder::phase1DHGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1DHGroup").unmarshallLocationName("phase1DHGroup").build()}).build();
    private static final SdkField<Integer> PHASE2_DH_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Phase2DHGroup").getter(ActiveVpnTunnelStatus.getter(ActiveVpnTunnelStatus::phase2DHGroup)).setter(ActiveVpnTunnelStatus.setter(Builder::phase2DHGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2DHGroup").unmarshallLocationName("phase2DHGroup").build()}).build();
    private static final SdkField<String> IKE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IkeVersion").getter(ActiveVpnTunnelStatus.getter(ActiveVpnTunnelStatus::ikeVersion)).setter(ActiveVpnTunnelStatus.setter(Builder::ikeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IkeVersion").unmarshallLocationName("ikeVersion").build()}).build();
    private static final SdkField<String> PROVISIONING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningStatus").getter(ActiveVpnTunnelStatus.getter(ActiveVpnTunnelStatus::provisioningStatusAsString)).setter(ActiveVpnTunnelStatus.setter(Builder::provisioningStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatus").unmarshallLocationName("provisioningStatus").build()}).build();
    private static final SdkField<String> PROVISIONING_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningStatusReason").getter(ActiveVpnTunnelStatus.getter(ActiveVpnTunnelStatus::provisioningStatusReason)).setter(ActiveVpnTunnelStatus.setter(Builder::provisioningStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatusReason").unmarshallLocationName("provisioningStatusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHASE1_ENCRYPTION_ALGORITHM_FIELD, PHASE2_ENCRYPTION_ALGORITHM_FIELD, PHASE1_INTEGRITY_ALGORITHM_FIELD, PHASE2_INTEGRITY_ALGORITHM_FIELD, PHASE1_DH_GROUP_FIELD, PHASE2_DH_GROUP_FIELD, IKE_VERSION_FIELD, PROVISIONING_STATUS_FIELD, PROVISIONING_STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ActiveVpnTunnelStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String phase1EncryptionAlgorithm;
    private final String phase2EncryptionAlgorithm;
    private final String phase1IntegrityAlgorithm;
    private final String phase2IntegrityAlgorithm;
    private final Integer phase1DHGroup;
    private final Integer phase2DHGroup;
    private final String ikeVersion;
    private final String provisioningStatus;
    private final String provisioningStatusReason;

    private ActiveVpnTunnelStatus(BuilderImpl builder) {
        this.phase1EncryptionAlgorithm = builder.phase1EncryptionAlgorithm;
        this.phase2EncryptionAlgorithm = builder.phase2EncryptionAlgorithm;
        this.phase1IntegrityAlgorithm = builder.phase1IntegrityAlgorithm;
        this.phase2IntegrityAlgorithm = builder.phase2IntegrityAlgorithm;
        this.phase1DHGroup = builder.phase1DHGroup;
        this.phase2DHGroup = builder.phase2DHGroup;
        this.ikeVersion = builder.ikeVersion;
        this.provisioningStatus = builder.provisioningStatus;
        this.provisioningStatusReason = builder.provisioningStatusReason;
    }

    public final String phase1EncryptionAlgorithm() {
        return this.phase1EncryptionAlgorithm;
    }

    public final String phase2EncryptionAlgorithm() {
        return this.phase2EncryptionAlgorithm;
    }

    public final String phase1IntegrityAlgorithm() {
        return this.phase1IntegrityAlgorithm;
    }

    public final String phase2IntegrityAlgorithm() {
        return this.phase2IntegrityAlgorithm;
    }

    public final Integer phase1DHGroup() {
        return this.phase1DHGroup;
    }

    public final Integer phase2DHGroup() {
        return this.phase2DHGroup;
    }

    public final String ikeVersion() {
        return this.ikeVersion;
    }

    public final VpnTunnelProvisioningStatus provisioningStatus() {
        return VpnTunnelProvisioningStatus.fromValue(this.provisioningStatus);
    }

    public final String provisioningStatusAsString() {
        return this.provisioningStatus;
    }

    public final String provisioningStatusReason() {
        return this.provisioningStatusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.phase1EncryptionAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.phase2EncryptionAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.phase1IntegrityAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.phase2IntegrityAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.phase1DHGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.phase2DHGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.ikeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningStatusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveVpnTunnelStatus)) {
            return false;
        }
        ActiveVpnTunnelStatus other = (ActiveVpnTunnelStatus)obj;
        return Objects.equals(this.phase1EncryptionAlgorithm(), other.phase1EncryptionAlgorithm()) && Objects.equals(this.phase2EncryptionAlgorithm(), other.phase2EncryptionAlgorithm()) && Objects.equals(this.phase1IntegrityAlgorithm(), other.phase1IntegrityAlgorithm()) && Objects.equals(this.phase2IntegrityAlgorithm(), other.phase2IntegrityAlgorithm()) && Objects.equals(this.phase1DHGroup(), other.phase1DHGroup()) && Objects.equals(this.phase2DHGroup(), other.phase2DHGroup()) && Objects.equals(this.ikeVersion(), other.ikeVersion()) && Objects.equals(this.provisioningStatusAsString(), other.provisioningStatusAsString()) && Objects.equals(this.provisioningStatusReason(), other.provisioningStatusReason());
    }

    public final String toString() {
        return ToString.builder((String)"ActiveVpnTunnelStatus").add("Phase1EncryptionAlgorithm", (Object)this.phase1EncryptionAlgorithm()).add("Phase2EncryptionAlgorithm", (Object)this.phase2EncryptionAlgorithm()).add("Phase1IntegrityAlgorithm", (Object)this.phase1IntegrityAlgorithm()).add("Phase2IntegrityAlgorithm", (Object)this.phase2IntegrityAlgorithm()).add("Phase1DHGroup", (Object)this.phase1DHGroup()).add("Phase2DHGroup", (Object)this.phase2DHGroup()).add("IkeVersion", (Object)this.ikeVersion()).add("ProvisioningStatus", (Object)this.provisioningStatusAsString()).add("ProvisioningStatusReason", (Object)this.provisioningStatusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Phase1EncryptionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.phase1EncryptionAlgorithm()));
            }
            case "Phase2EncryptionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.phase2EncryptionAlgorithm()));
            }
            case "Phase1IntegrityAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.phase1IntegrityAlgorithm()));
            }
            case "Phase2IntegrityAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.phase2IntegrityAlgorithm()));
            }
            case "Phase1DHGroup": {
                return Optional.ofNullable(clazz.cast(this.phase1DHGroup()));
            }
            case "Phase2DHGroup": {
                return Optional.ofNullable(clazz.cast(this.phase2DHGroup()));
            }
            case "IkeVersion": {
                return Optional.ofNullable(clazz.cast(this.ikeVersion()));
            }
            case "ProvisioningStatus": {
                return Optional.ofNullable(clazz.cast(this.provisioningStatusAsString()));
            }
            case "ProvisioningStatusReason": {
                return Optional.ofNullable(clazz.cast(this.provisioningStatusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Phase1EncryptionAlgorithm", PHASE1_ENCRYPTION_ALGORITHM_FIELD);
        map.put("Phase2EncryptionAlgorithm", PHASE2_ENCRYPTION_ALGORITHM_FIELD);
        map.put("Phase1IntegrityAlgorithm", PHASE1_INTEGRITY_ALGORITHM_FIELD);
        map.put("Phase2IntegrityAlgorithm", PHASE2_INTEGRITY_ALGORITHM_FIELD);
        map.put("Phase1DHGroup", PHASE1_DH_GROUP_FIELD);
        map.put("Phase2DHGroup", PHASE2_DH_GROUP_FIELD);
        map.put("IkeVersion", IKE_VERSION_FIELD);
        map.put("ProvisioningStatus", PROVISIONING_STATUS_FIELD);
        map.put("ProvisioningStatusReason", PROVISIONING_STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActiveVpnTunnelStatus, T> g) {
        return obj -> g.apply((ActiveVpnTunnelStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String phase1EncryptionAlgorithm;
        private String phase2EncryptionAlgorithm;
        private String phase1IntegrityAlgorithm;
        private String phase2IntegrityAlgorithm;
        private Integer phase1DHGroup;
        private Integer phase2DHGroup;
        private String ikeVersion;
        private String provisioningStatus;
        private String provisioningStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveVpnTunnelStatus model) {
            this.phase1EncryptionAlgorithm(model.phase1EncryptionAlgorithm);
            this.phase2EncryptionAlgorithm(model.phase2EncryptionAlgorithm);
            this.phase1IntegrityAlgorithm(model.phase1IntegrityAlgorithm);
            this.phase2IntegrityAlgorithm(model.phase2IntegrityAlgorithm);
            this.phase1DHGroup(model.phase1DHGroup);
            this.phase2DHGroup(model.phase2DHGroup);
            this.ikeVersion(model.ikeVersion);
            this.provisioningStatus(model.provisioningStatus);
            this.provisioningStatusReason(model.provisioningStatusReason);
        }

        public final String getPhase1EncryptionAlgorithm() {
            return this.phase1EncryptionAlgorithm;
        }

        public final void setPhase1EncryptionAlgorithm(String phase1EncryptionAlgorithm) {
            this.phase1EncryptionAlgorithm = phase1EncryptionAlgorithm;
        }

        @Override
        public final Builder phase1EncryptionAlgorithm(String phase1EncryptionAlgorithm) {
            this.phase1EncryptionAlgorithm = phase1EncryptionAlgorithm;
            return this;
        }

        public final String getPhase2EncryptionAlgorithm() {
            return this.phase2EncryptionAlgorithm;
        }

        public final void setPhase2EncryptionAlgorithm(String phase2EncryptionAlgorithm) {
            this.phase2EncryptionAlgorithm = phase2EncryptionAlgorithm;
        }

        @Override
        public final Builder phase2EncryptionAlgorithm(String phase2EncryptionAlgorithm) {
            this.phase2EncryptionAlgorithm = phase2EncryptionAlgorithm;
            return this;
        }

        public final String getPhase1IntegrityAlgorithm() {
            return this.phase1IntegrityAlgorithm;
        }

        public final void setPhase1IntegrityAlgorithm(String phase1IntegrityAlgorithm) {
            this.phase1IntegrityAlgorithm = phase1IntegrityAlgorithm;
        }

        @Override
        public final Builder phase1IntegrityAlgorithm(String phase1IntegrityAlgorithm) {
            this.phase1IntegrityAlgorithm = phase1IntegrityAlgorithm;
            return this;
        }

        public final String getPhase2IntegrityAlgorithm() {
            return this.phase2IntegrityAlgorithm;
        }

        public final void setPhase2IntegrityAlgorithm(String phase2IntegrityAlgorithm) {
            this.phase2IntegrityAlgorithm = phase2IntegrityAlgorithm;
        }

        @Override
        public final Builder phase2IntegrityAlgorithm(String phase2IntegrityAlgorithm) {
            this.phase2IntegrityAlgorithm = phase2IntegrityAlgorithm;
            return this;
        }

        public final Integer getPhase1DHGroup() {
            return this.phase1DHGroup;
        }

        public final void setPhase1DHGroup(Integer phase1DHGroup) {
            this.phase1DHGroup = phase1DHGroup;
        }

        @Override
        public final Builder phase1DHGroup(Integer phase1DHGroup) {
            this.phase1DHGroup = phase1DHGroup;
            return this;
        }

        public final Integer getPhase2DHGroup() {
            return this.phase2DHGroup;
        }

        public final void setPhase2DHGroup(Integer phase2DHGroup) {
            this.phase2DHGroup = phase2DHGroup;
        }

        @Override
        public final Builder phase2DHGroup(Integer phase2DHGroup) {
            this.phase2DHGroup = phase2DHGroup;
            return this;
        }

        public final String getIkeVersion() {
            return this.ikeVersion;
        }

        public final void setIkeVersion(String ikeVersion) {
            this.ikeVersion = ikeVersion;
        }

        @Override
        public final Builder ikeVersion(String ikeVersion) {
            this.ikeVersion = ikeVersion;
            return this;
        }

        public final String getProvisioningStatus() {
            return this.provisioningStatus;
        }

        public final void setProvisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
        }

        @Override
        public final Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            return this;
        }

        @Override
        public final Builder provisioningStatus(VpnTunnelProvisioningStatus provisioningStatus) {
            this.provisioningStatus(provisioningStatus == null ? null : provisioningStatus.toString());
            return this;
        }

        public final String getProvisioningStatusReason() {
            return this.provisioningStatusReason;
        }

        public final void setProvisioningStatusReason(String provisioningStatusReason) {
            this.provisioningStatusReason = provisioningStatusReason;
        }

        @Override
        public final Builder provisioningStatusReason(String provisioningStatusReason) {
            this.provisioningStatusReason = provisioningStatusReason;
            return this;
        }

        public ActiveVpnTunnelStatus build() {
            return new ActiveVpnTunnelStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActiveVpnTunnelStatus> {
        public Builder phase1EncryptionAlgorithm(String var1);

        public Builder phase2EncryptionAlgorithm(String var1);

        public Builder phase1IntegrityAlgorithm(String var1);

        public Builder phase2IntegrityAlgorithm(String var1);

        public Builder phase1DHGroup(Integer var1);

        public Builder phase2DHGroup(Integer var1);

        public Builder ikeVersion(String var1);

        public Builder provisioningStatus(String var1);

        public Builder provisioningStatus(VpnTunnelProvisioningStatus var1);

        public Builder provisioningStatusReason(String var1);
    }
}

