/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.misc;

import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.trace.Cdr;

@Cdr
public class CacheTable<K> {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private boolean noReverseMap;
    private String cacheType;
    private static final int INITIAL_SIZE = 64;
    private static final int MAX_SIZE = 0x40000000;
    private static final int INITIAL_THRESHHOLD = 48;
    private int size;
    private int threshhold;
    private int entryCount;
    private Entry<K>[] map;
    private Entry<K>[] rmap;
    private ORB orb;

    public CacheTable(String cacheType, ORB orb, boolean u) {
        this.orb = orb;
        this.cacheType = cacheType;
        this.noReverseMap = u;
        this.size = 64;
        this.threshhold = 48;
        this.entryCount = 0;
        this.initTables();
    }

    private void initTables() {
        this.map = new Entry[this.size];
        this.rmap = this.noReverseMap ? null : new Entry[this.size];
    }

    private void grow() {
        if (this.size == 0x40000000) {
            return;
        }
        Entry<K>[] oldMap = this.map;
        int oldSize = this.size;
        this.size <<= 1;
        this.threshhold <<= 1;
        this.initTables();
        for (int i = 0; i < oldSize; ++i) {
            Entry e = oldMap[i];
            while (e != null) {
                this.put_table(e.key, e.val);
                e = e.next;
            }
        }
    }

    private int hashModTableSize(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return (h ^ h >>> 7 ^ h >>> 4) & this.size - 1;
    }

    private int hash(K key) {
        return this.hashModTableSize(System.identityHashCode(key));
    }

    private int hash(int val) {
        return this.hashModTableSize(val);
    }

    public final void put(K key, int val) {
        if (this.put_table(key, val)) {
            ++this.entryCount;
            if (this.entryCount > this.threshhold) {
                this.grow();
            }
        }
    }

    @Cdr
    private boolean put_table(K key, int val) {
        int index = this.hash(key);
        Entry e = this.map[index];
        while (e != null) {
            if (e.key == key) {
                if (e.val != val) {
                    wrapper.duplicateIndirectionOffset();
                } else {
                    return false;
                }
            }
            e = e.next;
        }
        Entry<K> newEntry = new Entry<K>(key, val);
        ((Entry)newEntry).next = (Entry)this.map[index];
        this.map[index] = newEntry;
        if (!this.noReverseMap) {
            int rindex = this.hash(val);
            ((Entry)newEntry).rnext = (Entry)this.rmap[rindex];
            this.rmap[rindex] = newEntry;
        }
        return true;
    }

    public final boolean containsKey(K key) {
        return this.getVal(key) != -1;
    }

    public final int getVal(K key) {
        int index = this.hash(key);
        Entry e = this.map[index];
        while (e != null) {
            if (e.key == key) {
                return e.val;
            }
            e = e.next;
        }
        return -1;
    }

    public final boolean containsVal(int val) {
        return this.getKey(val) != null;
    }

    public final K getKey(int val) {
        if (this.noReverseMap) {
            throw wrapper.getKeyInvalidInCacheTable();
        }
        int index = this.hash(val);
        Entry e = this.rmap[index];
        while (e != null) {
            if (e.val == val) {
                return (K)e.key;
            }
            e = e.rnext;
        }
        return null;
    }

    public void done() {
        this.map = null;
        this.rmap = null;
    }

    private class Entry<K> {
        private K key;
        private int val;
        private Entry<K> next;
        private Entry<K> rnext;

        public Entry(K k, int v) {
            this.key = k;
            this.val = v;
            this.next = null;
            this.rnext = null;
        }
    }
}

