package App::Manoc::DB::ResultSet::IfStatus;
#ABSTRACT: ResultSet class for IfStatus
use strict;
use warnings;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use parent 'App::Manoc::DB::ResultSet';


sub search_unused {
    my ( $self, $device ) = @_;

    my $conditions = { 'mat_entry.macaddr' => undef };
    $device and $conditions->{'me.device_id'} = $device;

    my $rs = $self->search(
        $conditions,
        {
            alias => 'me',
            join  => 'mat_entry',
        }
    );
    return wantarray ? $rs->all : $rs;
}


sub search_mat_last_activity {
    my ( $self, $device ) = @_;

    my $conditions = {};
    $device and $conditions->{'me.device_id'} = $device;

    my $rs = $self->search(
        $conditions,
        {
            alias    => 'me',
            group_by => [qw(me.device_id me.interface)],
            select   => [ 'me.interface', { max => 'mat_entry.lastseen' }, ],
            as       => [qw(interface lastseen)],
            join     => 'mat_entry',
        }
    );
    return wantarray ? $rs->all : $rs;
}
1;

__END__

=pod

=head1 NAME

App::Manoc::DB::ResultSet::IfStatus - ResultSet class for IfStatus

=head1 VERSION

version 2.99.2

=head1 METHODS

=head2 search_unused(  $device )

Return a resultset containing all interfaces of <$device> which were never seen in
mac address table.

=head2 search_mat_last_activity (  $device )

Return a resultset containing all interfaces of <$device> with their corresponding
maximum value of lastseen in Mat.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
