package App::Manoc::Script::Daemon;
use Moose;

our $VERSION = '2.99.2'; ##TRIAL VERSION

# it must be a class in order to override foreground
extends 'App::Manoc::Script';
with 'MooseX::Daemonize';


sub main {
    die "This method must be overridden";
}

has cmd_stop => (
    metaclass   => 'Getopt',
    cmd_flag    => 'stop',
    cmd_aliases => 'k',
    isa         => 'Bool',
    is          => 'ro',
    default     => sub { 0 },

    documentation => 'kill the daemon',
);

has '+foreground' => ( writer => '_set_foreground', );

has cmd_status => (
    metaclass => 'Getopt',
    cmd_flag  => 'status',
    isa       => 'Bool',
    is        => 'ro',
    default   => sub { 0 },

    documentation => 'get daemon status',
);


sub run {
    my $self = shift;

    # when in foreground mode do not run Daemonize stuff
    # just call the main method
    if ( $self->foreground ) {
        return $self->main;
    }

    if ( $self->cmd_stop ) {
        $self->stop;
    }
    elsif ( $self->cmd_status ) {
        $self->status;
    }
    else {
        # when in debug mode do not fork
        $self->debug and $self->_set_foreground(1);

        $self->start;
    }

    print $self->status_message, "\n";
    exit( $self->exit_code );
}

after 'start' => sub {
    my $self = shift;
    return unless $self->is_daemon;
    $self->main;
};

# Clean up the namespace.
no Moose;
__PACKAGE__->meta->make_immutable;

# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Script::Daemon

=head1 VERSION

version 2.99.2

=head1 METHODS

=head2 main

Just a place holder: this method MUST be overriden by actual daemon class.

=head2 run

The script entry point.

The following command lines are supported beside the one from
L<MooseX::Daemonize> and L<App::Manoc::Script>.

=over 4

=item *

-k or --stop to terminate the daemon

=item *

--status to get info

=back

Process stay on foreground when started in debug mode.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
