/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public final class IdentityComparison
extends BinaryExpression {
    private boolean generateIdEmulation = false;

    public IdentityComparison(Expression p1, int op, Expression p2) {
        super(p1, op, p2);
    }

    public void setGenerateIdEmulation(boolean flag) {
        this.generateIdEmulation = flag;
    }

    public boolean isGenerateIdEmulation() {
        return this.generateIdEmulation;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        if (!this.generateIdEmulation && (Literal.isEmptySequence(this.operand0) || Literal.isEmptySequence(this.operand1))) {
            return Literal.makeEmptySequence();
        }
        RoleLocator role0 = new RoleLocator(1, Token.tokens[this.operator], 0);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, SequenceType.OPTIONAL_NODE, false, role0, visitor);
        RoleLocator role1 = new RoleLocator(1, Token.tokens[this.operator], 1);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, SequenceType.OPTIONAL_NODE, false, role1, visitor);
        if (!Cardinality.allowsZero(this.operand0.getCardinality()) && !Cardinality.allowsZero(this.operand1.getCardinality())) {
            this.generateIdEmulation = false;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression r = super.optimize(visitor, contextItemType);
        if (r != this && !this.generateIdEmulation && (Literal.isEmptySequence(this.operand0) || Literal.isEmptySequence(this.operand1))) {
            return Literal.makeEmptySequence();
        }
        return r;
    }

    public Expression copy() {
        IdentityComparison ic = new IdentityComparison(this.operand0.copy(), this.operator, this.operand1.copy());
        ic.generateIdEmulation = this.generateIdEmulation;
        return ic;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        NodeInfo node0 = IdentityComparison.getNode(this.operand0, context);
        if (node0 == null) {
            if (this.generateIdEmulation) {
                return BooleanValue.get(IdentityComparison.getNode(this.operand1, context) == null);
            }
            return null;
        }
        NodeInfo node1 = IdentityComparison.getNode(this.operand1, context);
        if (node1 == null) {
            if (this.generateIdEmulation) {
                return BooleanValue.FALSE;
            }
            return null;
        }
        return BooleanValue.get(this.compareIdentity(node0, node1));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        NodeInfo node0 = IdentityComparison.getNode(this.operand0, context);
        if (node0 == null) {
            return this.generateIdEmulation && IdentityComparison.getNode(this.operand1, context) == null;
        }
        NodeInfo node1 = IdentityComparison.getNode(this.operand1, context);
        return node1 != null && this.compareIdentity(node0, node1);
    }

    private boolean compareIdentity(NodeInfo node0, NodeInfo node1) {
        switch (this.operator) {
            case 20: {
                return node0.isSameNodeInfo(node1);
            }
            case 38: {
                return GlobalOrderComparer.getInstance().compare(node0, node1) < 0;
            }
            case 39: {
                return GlobalOrderComparer.getInstance().compare(node0, node1) > 0;
            }
        }
        throw new UnsupportedOperationException("Unknown node identity test");
    }

    private static NodeInfo getNode(Expression exp, XPathContext c) throws XPathException {
        return (NodeInfo)exp.evaluateItem(c);
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }
}

