### A Selection of bytes in a bitmapmatrix (where one can e.g. fill or change
### the inner colors)

use parent 'OnePassBitmapAlgorithmComponent';

sub new {
    my $class = shift;

    $self = SUPER::OnePassBitmapAlgorithmComponent->new(BagElement1);
    $self = { matrixbitmap => undef, matrixbitmapwithselection => undef,
	      index => -1, };
    
    bless $self, $class;
}

### returns bitmap matrix with only the selected color
sub getBitmapSelectionMatrix {
  my $self = shift;

  return $matrixbitmapwithselection;
}

### returns matrix of the changed bitmap matrix
sub getBitmap {
  my $self = shift;

  return $self->{matrixbitmap};
}

sub select {
    my ($self) = @_;
    
    my $matrixbitmapwithselectionobj = MatrixBitmapSelector->new;

    ### NOTE : uses WithClassOp, sets index (the base class only contains 1 idx)
    my $self->{index} = $self->addFunctor(OnePassFunctorWithClassOp->new(&$matrixbitmapwithselectionobj->selectColorAndSave));
    ### sets class on which this operates
    $self->indexFunctor($i)->setClassOp(\$matrixbitmapwithselectionobj);
}

### only one functor in this component, can be altered with class arithmetics
sub executeAllFunctors {
  my ($self, $matrixbitmapobj) = @_;

    my $resultmatrixobj = $self->indexFunctor($self->{index})->do($matrixbitmapobj);
    
    $self->indexFunctor($self->{index})->setResult($resultmatrixobj);
}

1;
