package Google::Ads::AdWords::v201206::Customer;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/mcm/v201206' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %customerId_of :ATTR(:get<customerId>);
my %currencyCode_of :ATTR(:get<currencyCode>);
my %dateTimeZone_of :ATTR(:get<dateTimeZone>);
my %descriptiveName_of :ATTR(:get<descriptiveName>);
my %canManageClients_of :ATTR(:get<canManageClients>);

__PACKAGE__->_factory(
    [ qw(        customerId
        currencyCode
        dateTimeZone
        descriptiveName
        canManageClients

    ) ],
    {
        'customerId' => \%customerId_of,
        'currencyCode' => \%currencyCode_of,
        'dateTimeZone' => \%dateTimeZone_of,
        'descriptiveName' => \%descriptiveName_of,
        'canManageClients' => \%canManageClients_of,
    },
    {
        'customerId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'currencyCode' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'dateTimeZone' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'descriptiveName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'canManageClients' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    },
    {

        'customerId' => 'customerId',
        'currencyCode' => 'currencyCode',
        'dateTimeZone' => 'dateTimeZone',
        'descriptiveName' => 'descriptiveName',
        'canManageClients' => 'canManageClients',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201206::Customer

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Customer from the namespace https://adwords.google.com/api/adwords/mcm/v201206.

Represents a customer for the CustomerService. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * customerId


=item * currencyCode


=item * dateTimeZone


=item * descriptiveName


=item * canManageClients




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201206::Customer
   customerId =>  $some_value, # long
   currencyCode =>  $some_value, # string
   dateTimeZone =>  $some_value, # string
   descriptiveName =>  $some_value, # string
   canManageClients =>  $some_value, # boolean
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

