# vim:set filetype=perl:
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 1.t'

#########################

use Test::More tests => 498;
use Carp;

use Lingua::Zompist::Verdurian 'scrifel';

sub form_ok {
    croak 'usage: form_ok($verb, $is, $should)' unless @_ >= 3;
    my($verb, $is, $should) = @_;

    is($is->[0], $should->[0], "I.sg. of $verb");
    is($is->[1], $should->[1], "II.sg. of $verb");
    is($is->[2], $should->[2], "III.sg. of $verb");
    is($is->[3], $should->[3], "I.pl. of $verb");
    is($is->[4], $should->[4], "II.pl. of $verb");
    is($is->[5], $should->[5], "III.pl. of $verb");
}

form_ok('lelen', scrifel('lelen'), [ qw( lelnai lelnei lelne lelnam lelno lelnu ) ]);
form_ok('badhir', scrifel('badhir'), [ qw( badhru badhreu badhre badhrum badhro badhr ) ]);
form_ok('elirec', scrifel('elirec'), [ qw( elircao elirceo elirce elircom elirco elircu ) ]);

form_ok('ocan', scrifel('ocan'), [ qw( osnai osnei osne osnam osno osnu ) ]);
form_ok('zhechir', scrifel('zhechir'), [ qw( zhedru zhedreu zhedre zhedrum zhedro zhedr ) ]);
form_ok('cuchec', scrifel('cuchec'), [ qw( cushcao cushceo cushce cushcom cushco cushcu ) ]);
form_ok('ldan', scrifel('ldan'), [ qw( lznai lznei lzne lznam lzno lznu ) ]);
form_ok('legan', scrifel('legan'), [ qw( lezhnai lezhnei lezhne lezhnam lezhno lezhnu ) ]);
form_ok('emec', scrifel('emec'), [ qw( encao enceo ence encom enco encu ) ]);
form_ok('visanir', scrifel('visanir'), [ qw( visandru visandreu visandre visandrum visandro visandr ) ]);
form_ok('rizir', scrifel('rizir'), [ qw( ridru ridreu ridre ridrum ridro ridr ) ]);
form_ok('mizec', scrifel('mizec'), [ qw( mizhao mizheo mizhe mizhom mizho mizhu ) ]);
form_ok('meclir', scrifel('meclir'), [ qw( mcliru meclireu mclire mclirum mcliro meclir ) ]);
form_ok('ivrec', scrifel('ivrec'), [ qw( ivricao ivriceo vrice vricom vrico vricu ) ]);

form_ok('esan', scrifel('esan'), [ qw( fuai fuei fue/esne fuam fuo fueu/esnu ) ]);

# test the general replacements
form_ok('aaacan', scrifel('aaacan'), [ qw( aaasnai aaasnei aaasne aaasnam aaasno aaasnu ) ]);
form_ok('aaachan', scrifel('aaachan'), [ qw( aaadnai aaadnei aaadne aaadnam aaadno aaadnu ) ]);
# don't confuse with a form of 'dan'
form_ok('aaaden', scrifel('aaaden'), [ qw( aaaznai aaaznei aaazne aaaznam aaazno aaaznu ) ]);
form_ok('aaagan', scrifel('aaagan'), [ qw( aaazhnai aaazhnei aaazhne aaazhnam aaazhno aaazhnu ) ]);

form_ok('aaachir', scrifel('aaachir'), [ qw( aaadru aaadreu aaadre aaadrum aaadro aaadr ) ]);
form_ok('aaamir', scrifel('aaamir'), [ qw( aaambru aaambreu aaambre aaambrum aaambro aaambr ) ]);
form_ok('aaanir', scrifel('aaanir'), [ qw( aaandru aaandreu aaandre aaandrum aaandro aaandr ) ]);
form_ok('aaazir', scrifel('aaazir'), [ qw( aaadru aaadreu aaadre aaadrum aaadro aaadr ) ]);

form_ok('aaacec', scrifel('aaacec'), [ qw( aaascao aaasceo aaasce aaascom aaasco aaascu ) ]);
form_ok('aaachec', scrifel('aaachec'), [ qw( aaashcao aaashceo aaashce aaashcom aaashco aaashcu ) ]);
form_ok('aaamec', scrifel('aaamec'), [ qw( aaancao aaanceo aaance aaancom aaanco aaancu ) ]);
form_ok('aaasec', scrifel('aaasec'), [ qw( aaashao aaasheo aaashe aaashom aaasho aaashu ) ]);
form_ok('aaazec', scrifel('aaazec'), [ qw( aaazhao aaazheo aaazhe aaazhom aaazho aaazhu ) ]);

# test the unstressed vowel insertion
form_ok('aaaccclan', scrifel('aaaccclan'), [ qw( aaaccclinai aaaccclinei aacccline aaccclinam aaccclino aaccclinu ) ]);
form_ok('aaacccran', scrifel('aaacccran'), [ qw( aaacccrinai aaacccrinei aacccrine aacccrinam aacccrino aacccrinu ) ]);
form_ok('eeeccclan', scrifel('eeeccclan'), [ qw( eeeccclinai eeeccclinei eecccline eeccclinam eeccclino eeccclinu ) ]);
form_ok('eeecccran', scrifel('eeecccran'), [ qw( eeecccrinai eeecccrinei eecccrine eecccrinam eecccrino eecccrinu ) ]);
form_ok('iiiccclan', scrifel('iiiccclan'), [ qw( iiiccclinai iiiccclinei iicccline iiccclinam iiccclino iiccclinu ) ]);
form_ok('iiicccran', scrifel('iiicccran'), [ qw( iiicccrinai iiicccrinei iicccrine iicccrinam iicccrino iicccrinu ) ]);
form_ok('oooccclan', scrifel('oooccclan'), [ qw( oooccclinai oooccclinei oocccline ooccclinam ooccclino ooccclinu ) ]);
form_ok('ooocccran', scrifel('ooocccran'), [ qw( ooocccrinai ooocccrinei oocccrine oocccrinam oocccrino oocccrinu ) ]);
form_ok('uuuccclan', scrifel('uuuccclan'), [ qw( uuuccclinai uuuccclinei uucccline uuccclinam uuccclino uuccclinu ) ]);
form_ok('uuucccran', scrifel('uuucccran'), [ qw( uuucccrinai uuucccrinei uucccrine uucccrinam uucccrino uucccrinu ) ]);

form_ok('aaaccclen', scrifel('aaaccclen'), [ qw( aaaccclinai aaaccclinei aacccline aaccclinam aaccclino aaccclinu ) ]);
form_ok('aaacccren', scrifel('aaacccren'), [ qw( aaacccrinai aaacccrinei aacccrine aacccrinam aacccrino aacccrinu ) ]);
form_ok('eeeccclen', scrifel('eeeccclen'), [ qw( eeeccclinai eeeccclinei eecccline eeccclinam eeccclino eeccclinu ) ]);
form_ok('eeecccren', scrifel('eeecccren'), [ qw( eeecccrinai eeecccrinei eecccrine eecccrinam eecccrino eecccrinu ) ]);
form_ok('iiiccclen', scrifel('iiiccclen'), [ qw( iiiccclinai iiiccclinei iicccline iiccclinam iiccclino iiccclinu ) ]);
form_ok('iiicccren', scrifel('iiicccren'), [ qw( iiicccrinai iiicccrinei iicccrine iicccrinam iicccrino iicccrinu ) ]);
form_ok('oooccclen', scrifel('oooccclen'), [ qw( oooccclinai oooccclinei oocccline ooccclinam ooccclino ooccclinu ) ]);
form_ok('ooocccren', scrifel('ooocccren'), [ qw( ooocccrinai ooocccrinei oocccrine oocccrinam oocccrino oocccrinu ) ]);
form_ok('uuuccclen', scrifel('uuuccclen'), [ qw( uuuccclinai uuuccclinei uucccline uuccclinam uuccclino uuccclinu ) ]);
form_ok('uuucccren', scrifel('uuucccren'), [ qw( uuucccrinai uuucccrinei uucccrine uucccrinam uucccrino uucccrinu ) ]);

form_ok('aaaccclir', scrifel('aaaccclir'), [ qw( aacccliru aaaccclireu aaccclire aaccclirum aacccliro aaaccclir ) ]);
form_ok('aaacccrir', scrifel('aaacccrir'), [ qw( aacccriru aaacccrireu aacccrire aacccrirum aacccriro aaacccrir ) ]);
form_ok('eeeccclir', scrifel('eeeccclir'), [ qw( eecccliru eeeccclireu eeccclire eeccclirum eecccliro eeeccclir ) ]);
form_ok('eeecccrir', scrifel('eeecccrir'), [ qw( eecccriru eeecccrireu eecccrire eecccrirum eecccriro eeecccrir ) ]);
form_ok('iiiccclir', scrifel('iiiccclir'), [ qw( iicccliru iiiccclireu iiccclire iiccclirum iicccliro iiiccclir ) ]);
form_ok('iiicccrir', scrifel('iiicccrir'), [ qw( iicccriru iiicccrireu iicccrire iicccrirum iicccriro iiicccrir ) ]);
form_ok('oooccclir', scrifel('oooccclir'), [ qw( oocccliru oooccclireu ooccclire ooccclirum oocccliro oooccclir ) ]);
form_ok('ooocccrir', scrifel('ooocccrir'), [ qw( oocccriru ooocccrireu oocccrire oocccrirum oocccriro ooocccrir ) ]);
form_ok('uuuccclir', scrifel('uuuccclir'), [ qw( uucccliru uuuccclireu uuccclire uuccclirum uucccliro uuuccclir ) ]);
form_ok('uuucccrir', scrifel('uuucccrir'), [ qw( uucccriru uuucccrireu uucccrire uucccrirum uucccriro uuucccrir ) ]);

form_ok('aaacccler', scrifel('aaacccler'), [ qw( aacccliru aaaccclireu aaccclire aaccclirum aacccliro aaaccclir ) ]);
form_ok('aaacccrer', scrifel('aaacccrer'), [ qw( aacccriru aaacccrireu aacccrire aacccrirum aacccriro aaacccrir ) ]);
form_ok('eeecccler', scrifel('eeecccler'), [ qw( eecccliru eeeccclireu eeccclire eeccclirum eecccliro eeeccclir ) ]);
form_ok('eeecccrer', scrifel('eeecccrer'), [ qw( eecccriru eeecccrireu eecccrire eecccrirum eecccriro eeecccrir ) ]);
form_ok('iiicccler', scrifel('iiicccler'), [ qw( iicccliru iiiccclireu iiccclire iiccclirum iicccliro iiiccclir ) ]);
form_ok('iiicccrer', scrifel('iiicccrer'), [ qw( iicccriru iiicccrireu iicccrire iicccrirum iicccriro iiicccrir ) ]);
form_ok('ooocccler', scrifel('ooocccler'), [ qw( oocccliru oooccclireu ooccclire ooccclirum oocccliro oooccclir ) ]);
form_ok('ooocccrer', scrifel('ooocccrer'), [ qw( oocccriru ooocccrireu oocccrire oocccrirum oocccriro ooocccrir ) ]);
form_ok('uuucccler', scrifel('uuucccler'), [ qw( uucccliru uuuccclireu uuccclire uuccclirum uucccliro uuuccclir ) ]);
form_ok('uuucccrer', scrifel('uuucccrer'), [ qw( uucccriru uuucccrireu uucccrire uucccrirum uucccriro uuucccrir ) ]);

form_ok('aaaccclec', scrifel('aaaccclec'), [ qw( aaaccclicao aaacccliceo aaccclice aaccclicom aaccclico aaccclicu ) ]);
form_ok('aaacccrec', scrifel('aaacccrec'), [ qw( aaacccricao aaacccriceo aacccrice aacccricom aacccrico aacccricu ) ]);
form_ok('eeeccclec', scrifel('eeeccclec'), [ qw( eeeccclicao eeecccliceo eeccclice eeccclicom eeccclico eeccclicu ) ]);
form_ok('eeecccrec', scrifel('eeecccrec'), [ qw( eeecccricao eeecccriceo eecccrice eecccricom eecccrico eecccricu ) ]);
form_ok('iiiccclec', scrifel('iiiccclec'), [ qw( iiiccclicao iiicccliceo iiccclice iiccclicom iiccclico iiccclicu ) ]);
form_ok('iiicccrec', scrifel('iiicccrec'), [ qw( iiicccricao iiicccriceo iicccrice iicccricom iicccrico iicccricu ) ]);
form_ok('oooccclec', scrifel('oooccclec'), [ qw( oooccclicao ooocccliceo ooccclice ooccclicom ooccclico ooccclicu ) ]);
form_ok('ooocccrec', scrifel('ooocccrec'), [ qw( ooocccricao ooocccriceo oocccrice oocccricom oocccrico oocccricu ) ]);
form_ok('uuuccclec', scrifel('uuuccclec'), [ qw( uuuccclicao uuucccliceo uuccclice uuccclicom uuccclico uuccclicu ) ]);
form_ok('uuucccrec', scrifel('uuucccrec'), [ qw( uuucccricao uuucccriceo uucccrice uucccricom uucccrico uucccricu ) ]);


form_ok('dan', scrifel('dan'), [ qw( donai donei done donam dono donu ) ]);
form_ok('kies', scrifel('kies'), [ qw( kaivai kaivei kaive kaivam kaivo kaivu ) ]);

# I think 'fassec' should conjugate like this:
form_ok('fassec', scrifel('fassec'), [ qw( fashshao fashsheo fashshe fashshom fashsho fashshu ) ]);
# and 'shushchan' like this:
form_ok('shushchan', scrifel('shushchan'), [ qw( shushdai shushdei shushde shushdam shushdo shushdu ) ]);

# "numonten" did the wrong thing in the past -- o went to 
form_ok('numonten', scrifel('numonten'), [ qw( numontnai numontnei numontne numontnam numontno numontnu ) ]);
