package Acme::CPANAuthors::BackPAN::OneHundred;
use strict;
use warnings;

{
    no strict "vars";
    $VERSION = "1.12";
}

use Acme::CPANAuthors::Register (

    'ADAMK'         => 'Adam Kennedy',
    'AUTRIJUS'      => 'Audrey Tang',
    'BARBIE'        => 'Barbie',
    'BDFOY'         => 'brian d foy',
    'BINGOS'        => 'Chris Williams',
    'BOBTFISH'      => 'Tomas Doran',
    'DAGOLDEN'      => 'David Golden',
    'DMAKI'         => 'Daisuke Maki',
    'DMUEY'         => 'Daniel Muey',
    'DROLSKY'       => 'Dave Rolsky',
    'ETHER'         => 'Karen Etheridge',
    'FAYLAND'       => 'Fayland Lin',
    'FLORA'         => 'Florian Ragwitz',
    'GETTY'         => 'Torsten Raudssus',
    'GUGOD'         => 'Liu Kang Min',
    'INGY'          => 'Ingy dot Net',
    'JGNI'          => 'John Imrie',
    'JHTHORSEN'     => 'Jan Henning Thorsen',
    'KENTNL'        => 'Kent Fredric',
    'LBROCARD'      => 'Leon Brocard',
    'LEOCHARRE'     => 'Leo Charre',
    'MANWAR'        => 'Mohammad S Anwar',
    'MARCEL'        => 'Marcel Gruenauer',
    'MIYAGAWA'      => 'Tatsuhiko Miyagawa',
    'MLEHMANN'      => '???',
    'MRAMBERG'      => 'Marcus Ramberg',
    'NEILB'         => 'Neil Bowers',
    'NUFFIN'        => 'Yuval Kogman',
    'PERLANCAR'     => 'perlancar',
    'PEVANS'        => 'Paul Evans',
    'PLICEASE'      => 'Graham Ollis',
    'PSIXDISTS'     => 'Perl 6 Modules',
    'RENEEB'        => 'Renee Baecker',
    'RJBS'          => 'Ricardo SIGNES',
    'RRWO'          => 'Robert Rothenberg',
    'RSAVAGE'       => 'Ron Savage',
    'SALVA'         => 'Salvador Fandino Garcia',
    'SHARYANTO'     => 'Steven Haryanto',
    'SHLOMIF'       => 'Shlomi Fish',
    'SIMON'         => 'Simon Cozens',
    'SKIM'          => 'Michal Josef Spacek',
    'SMUELLER'      => 'Steffen Mueller',
    'SZABGAB'       => 'Gabor Szabo',
    'TEAM'          => 'Tom Molesworth',
    'TOBYINK'       => 'Toby Inkster',
    'TOKUHIROM'     => '???',
    'VVELOX'        => '???',
    'YANICK'        => 'Yanick Champoux',
    'ZOFFIX'        => 'Zoffix Znet',

);

q<
We are programmed just to do
Anything you want us to

We are the robots, we are the robots
We are the robots, we are the robots

Lyrics copyright Ralf Htter
>

__END__

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::BackPAN::OneHundred - The CPAN Authors who have 100+ distributions on BackPAN

=head1 DESCRIPTION

This class provides a hash of CPAN authors' PAUSE ID and name to be 
used with the C<Acme::CPANAuthors> module.

This module was created to capture all those CPAN Authors who have valiantly
submitted their modules and distributions to CPAN, and now have the honour of
having submitted 100 or more distributions to CPAN. 

Note that the CPAN authors listed here may not be maintaining 100 or more
distributions on CPAN, but have submitted 100 or more distributions to PAUSE, 
where some older distributions may have been deprecated or adopted by other 
authors. The numbers here represent the number of distributions a CPAN author 
has listed on BackPAN.

See L<http://backpan.cpantesters.org>.

=head1 THE AUTHORS

   1.  1932  PERLANCAR     perlancar
   2.  550  PSIXDISTS     Perl 6 Modules
   3.  509  SHARYANTO     Steven Haryanto
   4.  329  TOBYINK       Toby Inkster
   5.  312  RJBS          Ricardo SIGNES
   6.  293  ZOFFIX        Zoffix Znet
   7.  287  ADAMK         Adam Kennedy
   8.  279  ETHER         Karen Etheridge
   9.  252  TOKUHIROM     ???
  10.  250  JGNI          John Imrie
  11.  246  MIYAGAWA      Tatsuhiko Miyagawa
  12.  223  INGY          Ingy dot Net
  13.  221  BINGOS        Chris Williams
  14.  210  FLORA         Florian Ragwitz
  15.  206  PLICEASE      Graham Ollis
  16.  204  DAGOLDEN      David Golden
  17.  192  SMUELLER      Steffen Mueller
  18.  189  KENTNL        Kent Fredric
  19.  182  MARCEL        Marcel Gruenauer
  20.  178  PEVANS        Paul Evans
  21.  172  BOBTFISH      Tomas Doran
  22.  172  DROLSKY       Dave Rolsky
  23.  161  NUFFIN        Yuval Kogman
  24.  160  SHLOMIF       Shlomi Fish
  25.  155  MANWAR        Mohammad S Anwar
  26.  151  NEILB         Neil Bowers
  27.  149  GUGOD         Liu Kang Min
  28.  142  RSAVAGE       Ron Savage
  29.  142  SKIM          Michal Josef Spacek
  30.  138  BDFOY         brian d foy
  31.  137  DMAKI         Daisuke Maki
  32.  134  BARBIE        Barbie
  33.  133  FAYLAND       Fayland Lin
  34.  125  AUTRIJUS      Audrey Tang
  35.  124  SZABGAB       Gabor Szabo
  36.  121  MRAMBERG      Marcus Ramberg
  37.  121  SIMON         Simon Cozens
  38.  116  SALVA         Salvador Fandino Garcia
  39.  115  MLEHMANN      ???
  40.  113  DMUEY         Daniel Muey
  41.  113  RRWO          Robert Rothenberg
  42.  113  YANICK        Yanick Champoux
  43.  111  LBROCARD      Leon Brocard
  44.  111  RENEEB        Renee Baecker
  45.  108  GETTY         Torsten Raudssus
  46.  106  JHTHORSEN     Jan Henning Thorsen
  47.  106  VVELOX        ???
  48.  102  TEAM          Tom Molesworth
  49.  101  LEOCHARRE     Leo Charre

List last updated: 2019-08-11T07:18:36

=head1 MAINTENANCE

If you are aware of any CPAN author that has attained the heady heights of 100
distributions on CPAN, and who is not listed here, please send me their ID/name
via email or RT, and I will update the module. If there are any mistakes, 
please contact me as soon as possible, and I'll amend the entry right away.

=head1 SEE ALSO

L<Acme::CPANAuthors> - Main class to manipulate this one

L<Acme::CPANAuthors::CPAN::OneHundred> - 100+ distributions on CPAN.

=head1 SUPPORT

Bugs, patches and feature requests can be reported at:

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Acme-CPANAuthors-BackPAN-OneHundred>

=item * GitHub

L<http://github.com/barbie/acme-cpanauthors-backpan-onehundred>

=back

There are no known bugs at the time of this release. However, if you spot a
bug or are experiencing difficulties that are not explained within the POD
documentation, please send an email to barbie@cpan.org or submit a bug to 
the RT queue. However, it would help greatly if you are able to pinpoint 
problems or even supply a patch. 

Fixes are dependent upon their severity and my availability. Should a fix 
not be forthcoming, please feel free to (politely) remind me.

=head1 ACKNOWLEDGEMENTS

Thanks to Kenichi Ishigaki for writing C<Acme::CPANAuthors>.

=head1 AUTHOR

  Barbie, <barbie@cpan.org>
  for Miss Barbell Productions <http://www.missbarbell.co.uk>.

=head1 COPYRIGHT & LICENSE

  Copyright 2014-2019 Barbie for Miss Barbell Productions.

  This distribution is free software; you can redistribute it and/or
  modify it under the Artistic License 2.0.

=cut
