# Generated by default/object.tt
package Paws::CodeBuild::ReportGroupTrendStats;
  use Moose;
  has Average => (is => 'ro', isa => 'Str', request_name => 'average', traits => ['NameInRequest']);
  has Max => (is => 'ro', isa => 'Str', request_name => 'max', traits => ['NameInRequest']);
  has Min => (is => 'ro', isa => 'Str', request_name => 'min', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeBuild::ReportGroupTrendStats

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeBuild::ReportGroupTrendStats object:

  $service_obj->Method(Att1 => { Average => $value, ..., Min => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeBuild::ReportGroupTrendStats object:

  $result = $service_obj->Method(...);
  $result->Att1->Average

=head1 DESCRIPTION

Contains trend statistics for a set of reports. The actual values
depend on the type of trend being collected. For more information, see
.

=head1 ATTRIBUTES


=head2 Average => Str

Contains the average of all values analyzed.


=head2 Max => Str

Contains the maximum value analyzed.


=head2 Min => Str

Contains the minimum value analyzed.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeBuild>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

