#!/usr/bin/perl
#
# prepare.t
#

BEGIN { $| = 1; print "1..8\n"; }
END {print "not ok 1\n" unless $loaded;}

#use diagnostics;
require URBL::Prepare;

$loaded = 1;
print "ok 1\n";
######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

$test = 2;

require 'recurse2txt';

sub ok {
  print "ok $test\n";
  ++$test;
}

sub chkstr {
  my($g,$e) = @_;
  print "got: $g\nexp: $e\nnot "
        unless $g eq $e;
  &ok;
}

my $whitefile = ['cache/white'];

# check level 3 tld's before level 2
my $tldfiles = [qw(
	cache/level3
	cache/level2
)];

my $ubp = new URBL::Prepare;

# test 2	check caching of white file, no pointer
my $exp = q|0	= [];
|;
my $whitelist = $ubp->cachewhite();
my $got = Dumper($whitelist);
chkstr($got,$exp);

# test 3	empty list
$whitelist = $ubp->cachewhite([]);
$got = Dumper($whitelist);
chkstr($got,$exp);

# test 4	fill the list
$exp = q|203	= ['example\.com','example\.net','example\.org','126\.com','163\.com','2o7\.net','4at1\.com','5iantlavalamp\.com','about\.com','adelphia\.net','adobe\.com','advertising\.com','agora-inc\.com','agoramedia\.com','akamai\.net','akamaitech\.net','amazon\.com','ancestry\.com','aol\.com','apache\.org','apple\.com','arcamax\.com','astrology\.com','atdmt\.com','att\.net','aweber\.com','bbc\.co\.uk','bcentral\.com','beliefnet\.com','bellsouth\.net','bfi0\.com','blogspot\.com','bridgetrack\.com','cafe24\.com','charter\.net','chtah\.com','citibank\.com','citizensbank\.com','cjb\.net','classmates\.com','click-url\.com','clickbank\.net','cnet\.com','cnn\.com','com\.com','com\.ne\.kr','comcast\.net','constantcontact\.com','corporate-ir\.net','cox\.net','cs\.com','custhelp\.com','daum\.net','dd\.se','debian\.org','dell\.com','directtrack\.com','domain\.com','doubleclick\.net','dsbl\.org','earthlink\.net','ebay\.co\.uk','ebay\.com','ebayimg\.com','ebaystatic\.com','ed10\.net','ed4\.net','edgesuite\.net','ediets\.com','egroups\.com','emode\.com','exacttarget\.com','excite\.com','exct\.net','f-secure\.com','flowgo\.com','free\.fr','freebsd\.org','freelotto\.com','gentoo\.org','geocities\.com','gmail\.com','gmx\.net','go\.com','google\.com','googleadservices\.com','grisoft\.com','hallmark\.com','hinet\.net','hotbar\.com','hotmail\.com','hotpop\.com','hp\.com','ibm\.com','ientrymail\.com','incredimail\.com','investorplace\.com','ivillage\.com','joingevalia\.com','juno\.com','kernel\.org','livejournal\.com','lycos\.com','m0\.net','m7z\.net','mac\.com','macromedia\.com','mail\.com','mail\.ru','mailscanner\.info','marketwatch\.com','mcafee\.com','mchsi\.com','mediaplex\.com','messagelabs\.com','microsoft\.com','military\.com','mindspring\.com','mit\.edu','monster\.com','msn\.com','nate\.com','netatlantic\.com','netflix\.com','netscape\.com','netscape\.net','netzero\.net','norman\.com','nytimes\.com','optonline\.net','osdn\.com','overstock\.com','p0\.com','pacbell\.net','pandasoftware\.com','partner2profit\.com','paypal\.com','peoplepc\.com','plaxo\.com','pm0\.net','postdirect\.com','prodigy\.net','radaruol\.com\.br','real\.com','redhat\.com','regions\.com','regionsnet\.com','rm04\.net','rogers\.com','rr\.com','rs6\.net','rsvp0\.net','sbcglobal\.net','sec\.gov','sf\.net','shaw\.ca','shockwave\.com','smileycentral\.com','smithbarney\.com','sourceforge\.net','spamcop\.net','speedera\.net','sportsline\.com','sun\.com','suntrust\.com','sympatico\.ca','t-online\.de','tails\.nl','telus\.net','terra\.com\.br','ticketmaster\.com','tickle\.com','tinyurl\.com','tiscali\.co\.uk','tom\.com','tone\.co\.nz','topica\.com','tux\.org','uol\.com\.br','ups\.com','verizon\.net','vistaprint\.com','w3\.org','wamu\.com','wanadoo\.fr','washingtonpost\.com','weatherbug\.com','web\.de','webshots\.com','webtv\.net','wsj\.com','xmr3\.com','yahoo\.ca','yahoo\.co\.kr','yahoo\.co\.uk','yahoo\.com','yahoo\.com\.br','yahoogroups\.com','yimg\.com','yopi\.de','yourfreedvds\.com','yoursite\.com','zdnet\.com',];
|;
$whitelist = $ubp->cachewhite($whitefile);
$got = Dumper($whitelist);
chkstr($got,$exp);

# test 5	check caching of tld file, no pointer
$exp = q|0	= [];
|;
my $tldlist = $ubp->cachetlds();
$got = Dumper($tldlist);
chkstr($got,$exp);

# test 6	empty list
$tldlist = $ubp->cachetlds([]);
$got = Dumper($tldlist);
chkstr($got,$exp);

# test 7	fill the list
$exp = q|4120	= ['act\.edu\.au','act\.gov\.au','bay\.livefilestore\.com','blog\.friendster\.com','blogger\.co\.id','blogger\.co\.il','blogger\.com\.au','blogger\.com\.co','blogger\.com\.my','blogger\.com\.pe','blogger\.com\.ph','blogspot\.co\.nz','blogspot\.co\.uk','blogspot\.com\.ar','blogspot\.com\.au','blogspot\.com\.br','blogspot\.com\.es','blu\.livefilestore\.com','bo\.nordland\.no','bo\.telemark\.no','city\.chiba\.jp','city\.fukuoka\.jp','city\.hiroshima\.jp','city\.kawasaki\.jp','city\.kitakyushu\.jp','city\.kobe\.jp','city\.kyoto\.jp','city\.nagoya\.jp','city\.niigata\.jp','city\.okayama\.jp','city\.osaka\.jp','city\.saitama\.jp','city\.sapporo\.jp','city\.sendai\.jp','city\.shizuoka\.jp','city\.yokohama\.jp','cloud\.prohosting\.com','co\.at\.lv','co\.at\.pn','co\.at\.tc','co\.uk\.pn','co\.uk\.tc','com\.au\.ms','com\.au\.pn','com\.au\.tc','com\.sapo\.pt','do\.sapo\.pt','docs\.google\.com','en\.alibaba\.com','groups\.live\.com','gs\.aa\.no','gs\.ah\.no','gs\.bu\.no','gs\.fm\.no','gs\.hl\.no','gs\.hm\.no','gs\.jan-mayen\.no','gs\.mr\.no','gs\.nl\.no','gs\.nt\.no','gs\.of\.no','gs\.ol\.no','gs\.oslo\.no','gs\.rl\.no','gs\.sf\.no','gs\.st\.no','gs\.svalbard\.no','gs\.tm\.no','gs\.tr\.no','gs\.va\.no','gs\.vf\.no','heroy\.more-og-romsdal\.no','heroy\.nordland\.no','home\.sapo\.pt','homepage\.t-online\.de','lkd\.co\.im','ltd\.co\.im','me\.uk\.tc','metro\.tokyo\.jp','mobile\.web\.tr','nes\.akershus\.no','nes\.buskerud\.no','no-ip\.co\.uk','no\.sapo\.pt','nsw\.edu\.au','nsw\.gov\.au','nt\.edu\.au','nt\.gov\.au','or\.at\.lv','org\.uk\.tc','os\.hedmark\.no','os\.hordaland\.no','pa\.gov\.pl','paginas\.sapo\.pt','perso\.sfr\.fr','plc\.co\.im','po\.gov\.pl','pref\.aichi\.jp','pref\.akita\.jp','pref\.aomori\.jp','pref\.chiba\.jp','pref\.ehime\.jp','pref\.fukui\.jp','pref\.fukuoka\.jp','pref\.fukushima\.jp','pref\.gifu\.jp','pref\.gunma\.jp','pref\.hiroshima\.jp','pref\.hokkaido\.jp','pref\.hyogo\.jp','pref\.ibaraki\.jp','pref\.ishikawa\.jp','pref\.iwate\.jp','pref\.kagawa\.jp','pref\.kagoshima\.jp','pref\.kanagawa\.jp','pref\.kochi\.jp','pref\.kumamoto\.jp','pref\.kyoto\.jp','pref\.mie\.jp','pref\.miyagi\.jp','pref\.miyazaki\.jp','pref\.nagano\.jp','pref\.nagasaki\.jp','pref\.nara\.jp','pref\.niigata\.jp','pref\.oita\.jp','pref\.okayama\.jp','pref\.okinawa\.jp','pref\.osaka\.jp','pref\.saga\.jp','pref\.saitama\.jp','pref\.shiga\.jp','pref\.shimane\.jp','pref\.shizuoka\.jp','pref\.tochigi\.jp','pref\.tokushima\.jp','pref\.tottori\.jp','pref\.toyama\.jp','pref\.wakayama\.jp','pref\.yamagata\.jp','pref\.yamaguchi\.jp','pref\.yamanashi\.jp','privat\.t-online\.de','profile\.live\.com','qld\.edu\.au','qld\.gov\.au','sa\.edu\.au','sa\.gov\.au','sakura\.ne\.jp','sande\.more-og-romsdal\.no','sande\.vestfold\.no','skydrive\.live\.com','so\.gov\.pl','spaces\.live\.com','spaces\.msn\.com','sr\.gov\.pl','starostwo\.gov\.pl','tas\.edu\.au','tas\.gov\.au','ug\.gov\.pl','um\.gov\.pl','upow\.gov\.pl','uw\.gov\.pl','valer\.hedmark\.no','valer\.ostfold\.no','vic\.edu\.au','vic\.gov\.au','wa\.edu\.au','wa\.gov\.au','web\.aplus\.net','web\.fc2\.com','web\.officelive\.com','0\.bg','0fees\.net','1\.bg','110mb\.com','150m\.com','163\.to','1blu\.de','2\.bg','2000\.hu','3\.bg','3dn\.ru','4\.bg','5\.bg','5ballov\.ru','6\.bg','6a\.org','6bone\.pl','6te\.net','7\.bg','8\.bg','9\.bg','9k\.com','a\.bg','a\.se','aa\.no','aarborte\.no','ab\.ca','ab\.se','abo\.pa','ac\.ae','ac\.am','ac\.at','ac\.bd','ac\.be','ac\.ci','ac\.cn','ac\.com','ac\.cr','ac\.cy','ac\.fj','ac\.fk','ac\.gg','ac\.gn','ac\.hu','ac\.id','ac\.il','ac\.im','ac\.in','ac\.ir','ac\.je','ac\.jp','ac\.ke','ac\.kr','ac\.lk','ac\.ma','ac\.me','ac\.mu','ac\.mw','ac\.ng','ac\.nz','ac\.om','ac\.pa','ac\.pg','ac\.pr','ac\.rs','ac\.ru','ac\.rw','ac\.se','ac\.sz','ac\.th','ac\.tj','ac\.tz','ac\.ug','ac\.uk','ac\.vn','ac\.yu','ac\.za','ac\.zm','ac\.zw','aca\.pro','academy\.museum','accident-investigation\.aero','accident-prevention\.aero','act\.au','ad\.jp','addr\.com','adm\.br','adult\.ht','adv\.br','adygeya\.ru','ae\.org','aejrie\.no','aero\.mv','aero\.tt','aerobatic\.aero','aeroclub\.aero','aerodrome\.aero','aeroport\.fr','afjord\.no','ag\.it','agdenes\.no','agents\.aero','agr\.br','agrar\.hu','agriculture\.museum','agrigento\.it','agrinet\.tn','agro\.pl','ah\.cn','ah\.no','aichi\.jp','aid\.pl','aip\.ee','air-surveillance\.aero','air-traffic-control\.aero','air\.museum','aircraft\.aero','airguard\.museum','airline\.aero','airport\.aero','airtraffic\.aero','ak\.us','akita\.jp','aknoluokta\.no','akrehamn\.no','al\.it','al\.no','al\.us','alabama\.museum','alaheadju\.no','aland\.fi','alaska\.museum','alderney\.gg','alessandria\.it','alesund\.no','algard\.no','alstahaug\.no','alt\.na','alt\.za','alta\.no','altai\.ru','altervista\.org','alto-adige\.it','altoadige\.it','alvdal\.no','am\.br','amber\.museum','ambulance\.aero','ambulance\.museum','american\.museum','americana\.museum','americanantiques\.museum','americanart\.museum','amli\.no','amot\.no','amsterdam\.museum','amur\.ru','amursk\.ru','amusement\.aero','an\.it','ancona\.it','and\.museum','andasuolo\.no','andebu\.no','andoy\.no','angelfire\.com','annefrank\.museum','anthro\.museum','anthropology\.museum','antiques\.museum','ao\.it','aomori\.jp','aosta\.it','aoste\.it','ap\.it','appspot\.com','aq\.it','aquarium\.museum','aquila\.it','ar\.com','ar\.it','ar\.us','arboretum\.museum','archaeological\.museum','archaeology\.museum','architecture\.museum','ardal\.no','aremark\.no','arendal\.no','arezzo\.it','arkhangelsk\.ru','army\.mil','arna\.no','arq\.br','art\.br','art\.do','art\.dz','art\.ht','art\.museum','art\.pl','artanddesign\.museum','artcenter\.museum','artdeco\.museum','arteducation\.museum','artgallery\.museum','arts\.co','arts\.museum','arts\.nf','arts\.ro','arts\.ve','artsandcrafts\.museum','as\.us','ascoli-piceno\.it','ascolipiceno\.it','aseral\.no','asker\.no','askim\.no','askoy\.no','askvoll\.no','asmatart\.museum','asn\.au','asn\.lv','asnes\.no','ass\.dz','ass\.km','assassination\.museum','assedic\.fr','assisi\.museum','assn\.lk','asso\.ci','asso\.dz','asso\.fr','asso\.gp','asso\.ht','asso\.km','asso\.ma','asso\.mc','asso\.re','asso\.st','asso\.ws','association\.aero','association\.museum','asti\.it','astrakhan\.ru','astronomy\.museum','at\.it','at\.lv','at\.pn','at\.tc','at\.tf','at\.tt','ath\.cx','atlanta\.museum','atm\.pl','ato\.br','au\.com','au\.ms','au\.pn','au\.tc','au\.tt','audnedaln\.no','augustow\.pl','aukra\.no','aure\.no','aurland\.no','aurskog-holand\.no','austevoll\.no','austin\.museum','australia\.museum','austrheim\.no','author\.aero','auto\.pl','automotive\.museum','av\.it','av\.tr','avellino\.it','averoy\.no','aviation\.museum','avocat\.fr','avoues\.fr','axis\.museum','az\.us','b\.bg','b\.se','ba\.it','babia-gora\.pl','badaddja\.no','badajoz\.museum','baghdad\.museum','bahcavuotna\.no','bahccavuotna\.no','bahn\.museum','baidar\.no','baikal\.ru','bajddar\.no','balat\.no','bale\.museum','balestrand\.no','ballangen\.no','ballooning\.aero','balsan\.it','balsfjord\.no','baltimore\.museum','bamble\.no','bar\.pro','barcelona\.museum','bardu\.no','bari\.it','barletta-andria-trani\.it','barlettaandriatrani\.it','barreau\.fr','barum\.no','baseball\.museum','basel\.museum','bashkiria\.ru','baths\.museum','batsfjord\.no','bauern\.museum','bbs\.tr','bc\.ca','bd\.se','be\.tc','be\.tt','bearalvahki\.no','beardu\.no','beauxarts\.museum','bedzin\.pl','bee\.pl','beeldengeluid\.museum','beiarn\.no','bel\.tr','belau\.pw','belgie\.be','belgorod\.ru','bellevue\.museum','belluno\.it','benevento\.it','berg\.no','bergamo\.it','bergbau\.museum','bergen\.no','berkeley\.museum','berlevag\.no','berlin\.museum','bern\.museum','beskidy\.pl','bg\.it','bg\.tc','bg\.tf','bi\.it','bialowieza\.pl','bialystok\.pl','bib\.ve','bible\.museum','bielawa\.pl','biella\.it','bieszczady\.pl','bievat\.no','bij\.pl','bilbao\.museum','bill\.museum','bindal\.no','bio\.br','bir\.ru','birdart\.museum','birkenes\.no','birthplace\.museum','biz\.az','biz\.bh','biz\.cy','biz\.et','biz\.fj','biz\.ki','biz\.ly','biz\.mv','biz\.mw','biz\.nf','biz\.nr','biz\.om','biz\.pk','biz\.pl','biz\.pr','biz\.st','biz\.tj','biz\.tm','biz\.tr','biz\.tt','biz\.ua','biz\.vn','bj\.cn','bjarkoy\.no','bjerkreim\.no','bjugn\.no','bl\.it','bl\.uk','blog\.br','blog\.cat','blog\.com','blog\.ru','blog4ever\.com','blogger\.ca','blogger\.cf','blogger\.ch','blogger\.cv','blogger\.jp','blogger\.pl','blogger\.re','blogger\.se','blogspot\.ca','blogspot\.com','blogspot\.cv','blogspot\.de','blogspot\.fr','blogspot\.in','blogspot\.it','blogspot\.jp','blogspot\.mx','blogspot\.pt','blogspot\.re','blogspot\.se','bmd\.br','bn\.it','bo\.it','bodo\.no','bokn\.no','boleslawiec\.pl','bologna\.it','bolt\.hu','bolzano\.it','bomlo\.no','bonn\.museum','boston\.museum','botanical\.museum','botanicalgarden\.museum','botanicgarden\.museum','botany\.museum','bourse\.za','bozen\.it','br\.com','br\.it','br\.ms','br\.tc','brand\.se','brandywinevalley\.museum','brasil\.museum','bravehost\.com','bravepages\.com','bremanger\.no','brescia\.it','brindisi\.it','bristol\.museum','british-library\.uk','british\.museum','britishcolumbia\.museum','broadcast\.museum','broker\.aero','bronnoy\.no','bronnoysund\.no','brumunddal\.no','brunel\.museum','brussel\.museum','brussels\.museum','bruxelles\.museum','bryansk\.ru','bryne\.no','bs\.it','bu\.no','budejju\.no','building\.museum','burghof\.museum','buryatia\.ru','bus\.museum','busan\.kr','bushey\.museum','by\.ru','bydgoszcz\.pl','bygland\.no','bykle\.no','bytom\.pl','bz\.cm','bz\.it','c\.bg','c\.la','c\.se','ca\.it','ca\.na','ca\.pn','ca\.tf','ca\.tt','ca\.us','caa\.aero','cadaques\.museum','cagliari\.it','cahcesuolo\.no','california\.museum','caltanissetta\.it','cambridge\.museum','campobasso\.it','can\.br','can\.museum','canada\.museum','capebreton\.museum','cargo\.aero','carrier\.museum','cartoonart\.museum','casadelamoneda\.museum','caserta\.it','casino\.hu','castle\.museum','castres\.museum','catania\.it','catanzaro\.it','catering\.aero','cb\.it','cbg\.ru','cc\.bh','cc\.cc','cc\.na','cci\.fr','ce\.it','ce\.ms','celtic\.museum','center\.museum','certification\.aero','ch\.it','ch\.lv','ch\.pn','ch\.tc','ch\.tf','ch\.vu','chambagri\.fr','championship\.aero','charter\.aero','chat\.ru','chattanooga\.museum','chel\.ru','cheltenham\.museum','chelyabinsk\.ru','cherkassy\.ua','chernigov\.ua','chernovtsy\.ua','chesapeakebay\.museum','chiba\.jp','chicago\.museum','chieti\.it','children\.museum','childrens\.museum','childrensgarden\.museum','chiropractic\.museum','chirurgiens-dentistes\.fr','chita\.ru','chocolate\.museum','christiansburg\.museum','chukotka\.ru','chungbuk\.kr','chungnam\.kr','chuvashia\.ru','cieszyn\.pl','cim\.br','cincinnati\.museum','cinema\.museum','circus\.museum','city\.hu','city\.za','civilaviation\.aero','civilisation\.museum','civilization\.museum','civilwar\.museum','cjb\.net','ck\.ua','cl\.it','clickbank\.net','clinton\.museum','clock\.museum','club\.aero','club\.tw','cmw\.ru','cn\.com','cn\.im','cn\.it','cn\.ms','cn\.pn','cn\.ua','cng\.br','cnt\.br','co\.ae','co\.ag','co\.am','co\.ao','co\.at','co\.ba','co\.be','co\.bi','co\.bw','co\.cc','co\.ci','co\.ck','co\.cm','co\.cr','co\.cu','co\.dk','co\.ee','co\.fk','co\.gg','co\.gy','co\.hu','co\.id','co\.il','co\.im','co\.in','co\.ir','co\.it','co\.je','co\.jp','co\.ke','co\.kg','co\.kr','co\.lc','co\.ls','co\.ma','co\.me','co\.mp','co\.mu','co\.mw','co\.mz','co\.na','co\.nf','co\.nr','co\.nu','co\.nz','co\.om','co\.pn','co\.pw','co\.rs','co\.rw','co\.sh','co\.st','co\.sz','co\.th','co\.tj','co\.tm','co\.tt','co\.tv','co\.tz','co\.ua','co\.ug','co\.uk','co\.us','co\.uz','co\.ve','co\.vi','co\.yu','co\.za','co\.zm','co\.zw','coal\.museum','coastaldefence\.museum','cody\.museum','coldwar\.museum','collection\.museum','colonialwilliamsburg\.museum','coloradoplateau\.museum','columbia\.museum','columbus\.museum','com\.ac','com\.ae','com\.af','com\.ag','com\.ai','com\.al','com\.am','com\.an','com\.ar','com\.au','com\.aw','com\.az','com\.ba','com\.bb','com\.bd','com\.bh','com\.bi','com\.bm','com\.bn','com\.bo','com\.br','com\.bs','com\.bt','com\.by','com\.bz','com\.cd','com\.ch','com\.ci','com\.cm','com\.cn','com\.co','com\.cu','com\.cy','com\.de','com\.dm','com\.do','com\.dz','com\.ec','com\.ee','com\.eg','com\.er','com\.es','com\.et','com\.fj','com\.fk','com\.fr','com\.ge','com\.gh','com\.gi','com\.gn','com\.gp','com\.gr','com\.gt','com\.gu','com\.gy','com\.hk','com\.hn','com\.hr','com\.ht','com\.io','com\.iq','com\.is','com\.jm','com\.jo','com\.kg','com\.kh','com\.ki','com\.km','com\.kw','com\.ky','com\.kz','com\.la','com\.lb','com\.lc','com\.li','com\.lk','com\.lr','com\.lv','com\.ly','com\.mg','com\.mk','com\.ml','com\.mm','com\.mn','com\.mo','com\.mt','com\.mu','com\.mv','com\.mw','com\.mx','com\.my','com\.na','com\.nc','com\.nf','com\.ng','com\.ni','com\.np','com\.nr','com\.nu','com\.om','com\.pa','com\.pe','com\.pf','com\.pg','com\.ph','com\.pk','com\.pl','com\.pr','com\.ps','com\.pt','com\.py','com\.qa','com\.re','com\.ro','com\.ru','com\.rw','com\.sa','com\.sb','com\.sc','com\.sd','com\.sg','com\.sh','com\.sl','com\.st','com\.sv','com\.sy','com\.tj','com\.tm','com\.tn','com\.to','com\.tr','com\.tt','com\.tv','com\.tw','com\.ua','com\.uy','com\.uz','com\.vc','com\.ve','com\.vi','com\.vn','com\.vu','com\.ws','com\.ye','com\.zm','communication\.museum','communications\.museum','community\.museum','como\.it','computer\.museum','computerhistory\.museum','conf\.au','conf\.lv','conference\.aero','congresodelalengua3\.ar','consulado\.st','consultant\.aero','consulting\.aero','contemporary\.museum','contemporaryart\.museum','control\.aero','convent\.museum','coolpage\.biz','coop\.br','coop\.ht','coop\.km','coop\.mv','coop\.mw','coop\.tt','copenhagen\.museum','corp\.st','corporation\.museum','corvette\.museum','cosenza\.it','costume\.museum','council\.aero','countryestate\.museum','county\.museum','cp\.cx','cpa\.pro','cq\.cn','cr\.it','crafts\.museum','cranbrook\.museum','creation\.museum','cremona\.it','crew\.aero','cri\.nz','crimea\.ua','crotone\.it','cs\.it','csiro\.au','ct\.it','ct\.us','cu\.cc','cuccfree\.com','cul\.na','cultural\.museum','culturalcenter\.museum','culture\.museum','cuneo\.it','cv\.ua','cx\.cc','cyber\.museum','cymru\.museum','cyt\.cu','cz\.cc','cz\.it','cz\.tc','cz\.tf','cz\.tl','czeladz\.pl','czest\.pl','d\.bg','d\.se','daegu\.kr','daejeon\.kr','dagestan\.ru','dali\.museum','dallas\.museum','database\.museum','davvenjarga\.no','davvesiida\.no','dc\.us','ddns\.me','ddr\.museum','de\.be','de\.com','de\.ki','de\.lv','de\.ms','de\.net','de\.pn','de\.tc','de\.tf','de\.tl','de\.tt','de\.us','de\.vu','deatnu\.no','decorativearts\.museum','defense\.tn','delaware\.museum','delmenhorst\.museum','denmark\.museum','dep\.no','depot\.museum','design\.aero','design\.museum','detroit\.museum','dgca\.aero','dielddanuorri\.no','dinosaur\.museum','discovery\.museum','divtasvuodna\.no','divttasvuotna\.no','dk\.org','dk\.tc','dk\.tt','dlugoleka\.pl','dn\.ua','dnepropetrovsk\.ua','dni\.us','dns\.be','dolls\.museum','donetsk\.ua','donna\.no','donostia\.museum','dovre\.no','dp\.ua','dpn\.br','dr\.na','dr\.tr','drammen\.no','drangedal\.no','drobak\.no','dudinka\.ru','durham\.museum','dyndns-at-home\.com','dyndns-at-work\.com','dyndns-blog\.com','dyndns-free\.com','dyndns-home\.com','dyndns-ip\.com','dyndns-mail\.com','dyndns-office\.com','dyndns-pics\.com','dyndns-remote\.com','dyndns-server\.com','dyndns-web\.com','dyndns-wiki\.com','dyndns-work\.com','dyndns\.biz','dyndns\.dk','dyndns\.info','dyndns\.org','dyndns\.tv','dyndns\.ws','dyroy\.no','e-burg\.ru','e-famoso\.it','e\.bg','e\.se','e12\.ve','e164\.arpa','eastafrica\.museum','eastcoast\.museum','ebiz\.tw','ecn\.br','ed\.ao','ed\.ci','ed\.cr','ed\.jp','ed\.pw','edenvale\.info','edu\.ac','edu\.af','edu\.ai','edu\.al','edu\.am','edu\.an','edu\.ar','edu\.au','edu\.az','edu\.ba','edu\.bb','edu\.bd','edu\.bh','edu\.bi','edu\.bm','edu\.bn','edu\.bo','edu\.br','edu\.bs','edu\.bt','edu\.bz','edu\.ci','edu\.ck','edu\.cn','edu\.co','edu\.cu','edu\.dm','edu\.do','edu\.dz','edu\.ec','edu\.ee','edu\.eg','edu\.er','edu\.es','edu\.et','edu\.ge','edu\.gh','edu\.gi','edu\.gn','edu\.gp','edu\.gr','edu\.gt','edu\.gu','edu\.hk','edu\.hn','edu\.ht','edu\.hu','edu\.in','edu\.iq','edu\.is','edu\.it','edu\.jm','edu\.jo','edu\.kg','edu\.kh','edu\.ki','edu\.km','edu\.kn','edu\.kw','edu\.ky','edu\.kz','edu\.la','edu\.lb','edu\.lc','edu\.lk','edu\.lr','edu\.lv','edu\.ly','edu\.me','edu\.mg','edu\.mk','edu\.ml','edu\.mm','edu\.mn','edu\.mo','edu\.mp','edu\.mt','edu\.mv','edu\.mw','edu\.mx','edu\.my','edu\.na','edu\.ng','edu\.ni','edu\.np','edu\.nr','edu\.om','edu\.pa','edu\.pe','edu\.pf','edu\.ph','edu\.pk','edu\.pl','edu\.pn','edu\.pr','edu\.ps','edu\.pt','edu\.py','edu\.qa','edu\.rs','edu\.ru','edu\.rw','edu\.sa','edu\.sb','edu\.sc','edu\.sd','edu\.sg','edu\.sh','edu\.sk','edu\.sl','edu\.st','edu\.sv','edu\.sy','edu\.tc','edu\.tf','edu\.tj','edu\.to','edu\.tr','edu\.tt','edu\.tw','edu\.ua','edu\.uk','edu\.uy','edu\.vc','edu\.ve','edu\.vi','edu\.vn','edu\.vu','edu\.ws','edu\.ye','edu\.yu','edu\.za','edu\.zm','educ\.ar','education\.museum','educational\.museum','educator\.aero','edunet\.tn','egersund\.no','egyptian\.museum','ehime\.jp','eid\.no','eidfjord\.no','eidsberg\.no','eidskog\.no','eidsvoll\.no','eigersund\.no','eisenbahn\.museum','ekloges\.cy','elblag\.pl','elburg\.museum','elk\.pl','elvendrell\.museum','elverum\.no','embaixada\.st','embroidery\.museum','emergency\.aero','en\.it','encyclopedic\.museum','enebakk\.no','eng\.br','eng\.pro','engerdal\.no','engine\.aero','engineer\.aero','england\.museum','enna\.it','ens\.tn','entertainment\.aero','entomology\.museum','environment\.museum','environmentalconservation\.museum','epilepsy\.museum','equipment\.aero','ernet\.in','erotica\.hu','erotika\.hu','es\.kr','es\.pn','es\.tc','es\.tl','es\.tt','esp\.br','essex\.museum','est\.pr','estate\.museum','etc\.br','ethnology\.museum','eti\.br','etne\.no','etnedal\.no','eu\.com','eu\.im','eu\.int','eu\.org','eu\.tc','eu\.tf','eu\.tt','eu5\.org','eun\.eg','euro\.tm','evenassi\.no','evenes\.no','evje-og-hornnes\.no','exchange\.aero','exeter\.museum','exhibition\.museum','experts-comptables\.fr','express\.aero','extra\.hu','f\.bg','f\.se','fam\.pk','family\.museum','far\.br','fareast\.ru','farm\.museum','farmequipment\.museum','farmers\.museum','farmstead\.museum','farsund\.no','fauske\.no','fax\.nr','fc\.it','fe\.it','fed\.us','federation\.aero','fedje\.no','fermo\.it','ferrara\.it','fet\.no','fetsund\.no','fg\.it','fgov\.be','fh\.se','fhs\.no','fhsk\.se','fhv\.se','fi\.cr','fi\.it','fie\.ee','field\.museum','figueres\.museum','filatelia\.museum','film\.hu','film\.museum','fin\.ec','fin\.tn','fineart\.museum','finearts\.museum','finland\.museum','finnoy\.no','firenze\.it','firm\.co','firm\.ht','firm\.in','firm\.nf','firm\.ro','firm\.ve','fitjar\.no','fj\.cn','fjaler\.no','fjell\.no','fl\.us','fla\.no','flakstad\.no','flanders\.museum','flatanger\.no','flekkefjord\.no','flesberg\.no','flight\.aero','flog\.br','flora\.no','florence\.it','florida\.museum','floro\.no','fm\.br','fm\.no','fnd\.br','foggia\.it','folkebibl\.no','folldal\.no','force\.museum','forde\.no','forli-cesena\.it','forlicesena\.it','forsand\.no','fortmissoula\.museum','fortworth\.museum','forum\.hu','fosnes\.no','fot\.br','foundation\.museum','fr\.cr','fr\.it','fr\.ms','fr\.nf','fr\.pn','fr\.tc','fr\.tt','fr\.vu','frana\.no','francaise\.museum','frankfurt\.museum','franziskaner\.museum','fredrikstad\.no','free\.fr','freehostia\.com','freemasonry\.museum','freeoda\.com','freeservercity\.com','freetzi\.com','freevar\.com','frei\.no','freiburg\.museum','freight\.aero','fribourg\.museum','frog\.museum','frogn\.no','froland\.no','from\.hr','fromru\.su','front\.ru','frosinone\.it','frosta\.no','froya\.no','fst\.br','fuel\.aero','fukui\.jp','fukuoka\.jp','fukushima\.jp','fundacio\.museum','funpic\.de','fuoisku\.no','fuossko\.no','furniture\.museum','fusa\.no','fx\.to','fylkesbibl\.no','fyresdal\.no','g\.bg','g\.se','g12\.br','ga\.us','gaivuotna\.no','gallery\.museum','galsa\.no','game\.tw','games\.hu','gamvik\.no','gangaviika\.no','gangwon\.kr','garden\.museum','gateway\.museum','gaular\.no','gausdal\.no','gb\.com','gb\.net','gbr\.me','gc\.ca','gd\.cn','gda\.pl','gdansk\.pl','gdynia\.pl','ge\.it','geek\.nz','geelvinck\.museum','gemological\.museum','gen\.in','gen\.nz','gen\.tr','genoa\.it','genova\.it','geocities\.com','geocities\.jp','geology\.museum','geometre-expert\.fr','georgia\.museum','get\.cu','getmyip\.com','ggf\.br','giehtavuoatna\.no','giessen\.museum','gifu\.jp','gigazu\.net','gildeskal\.no','giske\.no','gjemnes\.no','gjerdrum\.no','gjerstad\.no','gjesdal\.no','gjovik\.no','glas\.museum','glass\.museum','gliding\.aero','gliwice\.pl','glogow\.pl','gloppen\.no','gmina\.pl','gmxhome\.de','gniezno\.pl','go\.ci','go\.com','go\.cr','go\.id','go\.it','go\.jp','go\.ke','go\.kr','go\.pw','go\.ro','go\.th','go\.tj','go\.tz','go\.ug','gob\.ar','gob\.bo','gob\.cl','gob\.do','gob\.ec','gob\.es','gob\.gt','gob\.hn','gob\.mx','gob\.ni','gob\.pa','gob\.pe','gob\.pk','gob\.sv','gob\.ve','gobiernoelectronico\.ar','gok\.pk','gol\.no','gon\.pk','googlegroups\.com','googlepages\.com','gop\.pk','gorge\.museum','gorizia\.it','gorlice\.pl','gos\.pk','gouv\.ci','gouv\.fr','gouv\.ht','gouv\.km','gouv\.ml','gouv\.rw','gov\.ac','gov\.ae','gov\.af','gov\.ai','gov\.al','gov\.am','gov\.ar','gov\.as','gov\.au','gov\.az','gov\.ba','gov\.bb','gov\.bd','gov\.bf','gov\.bh','gov\.bm','gov\.bn','gov\.bo','gov\.br','gov\.bs','gov\.bt','gov\.by','gov\.bz','gov\.cd','gov\.ch','gov\.ck','gov\.cl','gov\.cm','gov\.cn','gov\.co','gov\.cu','gov\.cx','gov\.cy','gov\.dm','gov\.do','gov\.dz','gov\.ec','gov\.ee','gov\.eg','gov\.er','gov\.et','gov\.fj','gov\.fk','gov\.ge','gov\.gg','gov\.gh','gov\.gi','gov\.gn','gov\.gr','gov\.gu','gov\.hk','gov\.hu','gov\.ie','gov\.il','gov\.im','gov\.in','gov\.io','gov\.iq','gov\.ir','gov\.is','gov\.it','gov\.je','gov\.jm','gov\.jo','gov\.jp','gov\.kg','gov\.kh','gov\.ki','gov\.km','gov\.kn','gov\.kw','gov\.ky','gov\.kz','gov\.la','gov\.lb','gov\.lc','gov\.li','gov\.lk','gov\.lr','gov\.lt','gov\.lu','gov\.lv','gov\.ly','gov\.ma','gov\.me','gov\.mg','gov\.mk','gov\.ml','gov\.mm','gov\.mn','gov\.mo','gov\.mp','gov\.mr','gov\.mt','gov\.mu','gov\.mv','gov\.mw','gov\.my','gov\.ng','gov\.np','gov\.nr','gov\.om','gov\.ph','gov\.pk','gov\.pl','gov\.pn','gov\.pr','gov\.ps','gov\.pt','gov\.py','gov\.qa','gov\.rs','gov\.ru','gov\.rw','gov\.sa','gov\.sb','gov\.sc','gov\.sd','gov\.sg','gov\.sh','gov\.sk','gov\.sl','gov\.st','gov\.sy','gov\.tj','gov\.tl','gov\.tm','gov\.tn','gov\.to','gov\.tp','gov\.tr','gov\.tt','gov\.tv','gov\.tw','gov\.ua','gov\.uk','gov\.vc','gov\.ve','gov\.vi','gov\.vn','gov\.ws','gov\.ye','gov\.za','gov\.zm','gov\.zw','government\.aero','government\.pn','govt\.nz','gr\.com','gr\.it','gr\.jp','grajewo\.pl','gran\.no','grandrapids\.museum','grane\.no','granvin\.no','gratangen\.no','gratishost\.com','graz\.museum','greta\.fr','grimstad\.no','grong\.no','grosseto\.it','groundhandling\.aero','group\.aero','grouply\.com','grozny\.ru','grp\.lk','grue\.no','gs\.cn','gsm\.pl','gu\.us','gub\.uy','guernsey\.gg','guernsey\.museum','gulen\.no','gunma\.jp','guovdageaidnu\.no','gv\.ao','gv\.at','gv\.vg','gwangju\.kr','gx\.cn','gyeongbuk\.kr','gyeonggi\.kr','gyeongnam\.kr','gz\.cn','h\.bg','h\.se','ha\.cn','ha\.no','habmer\.no','hadsel\.no','hagebostad\.no','halden\.no','halloffame\.museum','halsa\.no','hamar\.no','hamaroy\.no','hamburg\.museum','hammarfeasta\.no','hammerfest\.no','handson\.museum','hanggliding\.aero','hapmir\.no','haram\.no','hareid\.no','harstad\.no','harvestcelebration\.museum','hasvik\.no','hattfjelldal\.no','haugesund\.no','hawaii\.museum','hb\.cn','he\.cn','health\.museum','health\.vn','heimatunduhren\.museum','hellas\.museum','helloweb\.eu','helsinki\.museum','hembygdsforbund\.museum','hemne\.no','hemnes\.no','hemsedal\.no','herad\.no','heritage\.museum','hi\.cn','hi\.us','hiroshima\.jp','histoire\.museum','historical\.museum','historicalsociety\.museum','historichouses\.museum','historisch\.museum','historisches\.museum','history\.museum','historyofscience\.museum','hitra\.no','hjartdal\.no','hjelmeland\.no','hk\.cn','hk\.ms','hk\.tc','hk\.vg','hl\.cn','hl\.no','hm\.no','hn\.cn','hobol\.no','hof\.no','hokkaido\.jp','hokksund\.no','hol\.no','hole\.no','holmestrand\.no','holtalen\.no','home\.pl','home\.ro','homebuilt\.aero','homeip\.net','honefoss\.no','hornindal\.no','horology\.museum','horten\.no','host\.sk','hostevo\.com','hotbox\.ru','hotel\.hu','hotel\.lk','hotmail\.ru','house\.museum','hoyanger\.no','hoylandet\.no','hs\.kr','hu\.com','hu\.tc','hu2\.ru','huissier-justice\.fr','humanities\.museum','hurdal\.no','hurum\.no','hut2\.ru','hvaler\.no','hyllestad\.no','hyogo\.jp','i\.bg','i\.ph','i\.se','ia\.us','ibaraki\.jp','ibelgique\.com','ibestad\.no','ibiz\.cc','iblogger\.org','ic\.cz','icnet\.uk','id\.au','id\.fj','id\.ir','id\.lv','id\.ly','id\.ru','id\.us','idf\.il','idn\.sg','idoo\.com','idrett\.no','idv\.hk','idv\.tw','ie\.tc','iespana\.es','if\.ua','ifrance\.com','iim\.bz','il\.im','il\.us','ilawa\.pl','illustration\.museum','im\.it','imageandsound\.museum','imb\.br','imperia\.it','in\.na','in\.rs','in\.th','in\.ua','in\.us','incheon\.kr','ind\.br','ind\.er','ind\.gg','ind\.gt','ind\.in','ind\.je','ind\.tn','inderoy\.no','indian\.museum','indiana\.museum','indianapolis\.museum','indianmarket\.museum','inf\.br','inf\.cu','inf\.mk','info\.au','info\.az','info\.bh','info\.co','info\.cu','info\.cy','info\.ec','info\.et','info\.fj','info\.ht','info\.hu','info\.ki','info\.la','info\.ms','info\.mv','info\.na','info\.nf','info\.nr','info\.pk','info\.pl','info\.pr','info\.ro','info\.sd','info\.tn','info\.tr','info\.tt','info\.ve','info\.vn','infos\.st','ing\.pa','ingatlan\.hu','inima\.al','insurance\.aero','int\.am','int\.ar','int\.az','int\.bo','int\.ci','int\.co','int\.is','int\.la','int\.lk','int\.mv','int\.mw','int\.pt','int\.ru','int\.rw','int\.tc','int\.tf','int\.tj','int\.tt','int\.ve','int\.vn','intelligence\.museum','interactive\.museum','interia\.pl','interii\.pl','intl\.tn','ip6\.arpa','iquebec\.com','iraq\.museum','irc\.pl','iris\.arpa','irkutsk\.ru','iron\.museum','is\.it','isa\.us','isernia\.it','ishikawa\.jp','isla\.pr','isleofman\.museum','isuisse\.com','it\.ao','it\.pn','it\.tc','it\.tt','its\.me','ivano-frankivsk\.ua','ivanovo\.ru','iveland\.no','ivgu\.no','iwate\.jp','iwebsource\.com','iwi\.nz','iz\.hr','izhevsk\.ru','j\.bg','jamal\.ru','jamison\.museum','jan-mayen\.no','jar\.ru','jaworzno\.pl','jefferson\.museum','jeju\.kr','jelenia-gora\.pl','jeonbuk\.kr','jeonnam\.kr','jersey\.je','jerusalem\.museum','jessheim\.no','jet\.uk','jevnaker\.no','jewelry\.museum','jewish\.museum','jewishart\.museum','jfk\.museum','jgora\.pl','jimdo\.com','jino-net\.ru','jl\.cn','jobs\.tt','jogasz\.hu','jolster\.no','jondal\.no','jor\.br','jorpeland\.no','joshkar-ola\.ru','journal\.aero','journalism\.museum','journalist\.aero','jp\.net','jp\.pn','jpn\.com','js\.cn','judaica\.museum','judygarland\.museum','juedisches\.museum','juif\.museum','jur\.pro','jus\.br','jx\.cn','k-uralsk\.ru','k\.bg','k\.se','k12\.ec','k12\.il','k12\.tr','k12\.vi','kafjord\.no','kagawa\.jp','kagoshima\.jp','kalisz\.pl','kalmykia\.ru','kaluga\.ru','kamchatka\.ru','kanagawa\.jp','kanazawa\.jp','karasjohka\.no','karasjok\.no','karate\.museum','karelia\.ru','karikatur\.museum','karlsoy\.no','karmoy\.no','karpacz\.pl','kartuzy\.pl','kaszuby\.pl','katowice\.pl','kautokeino\.no','kawasaki\.jp','kazan\.ru','kazimierz-dolny\.pl','kchr\.ru','kemerovo\.ru','kepno\.pl','ketrzyn\.pl','kg\.kr','kh\.ua','khabarovsk\.ru','khakassia\.ru','kharkov\.ua','kherson\.ua','khmelnitskiy\.ua','khv\.ru','kickme\.to','kids\.museum','kids\.us','kiev\.ua','kimsufi\.com','kirkenes\.no','kirov\.ru','kirovograd\.ua','kitakyushu\.jp','klabu\.no','klepp\.no','klodzko\.pl','km\.ua','kms\.ru','kobe\.jp','kobierzyce\.pl','kochi\.jp','koebenhavn\.museum','koeln\.museum','koenig\.ru','kolobrzeg\.pl','komforb\.se','komi\.ru','kommunalforbund\.se','kommune\.no','komvux\.se','kongsberg\.no','kongsvinger\.no','konin\.pl','konskowola\.pl','konyvelo\.hu','kopervik\.no','kostroma\.ru','kr\.com','kr\.it','kr\.tc','kr\.ua','kraanghke\.no','kragero\.no','krakow\.pl','krasnoyarsk\.ru','kristiansand\.no','kristiansund\.no','krodsherad\.no','krokstadelva\.no','krovatka\.su','ks\.ua','ks\.us','kuban\.ru','kumamoto\.jp','kunst\.museum','kunstsammlung\.museum','kunstunddesign\.museum','kurgan\.ru','kursk\.ru','kustanai\.ru','kutno\.pl','kuzbass\.ru','kv\.ua','kvafjord\.no','kvalsund\.no','kvam\.no','kvanangen\.no','kvinesdal\.no','kvinnherad\.no','kviteseid\.no','kvitsoy\.no','kwik\.to','ky\.us','kyonggi\.kr','kyoto\.jp','l\.bg','l\.se','la-spezia\.it','la\.us','laakesvuemie\.no','labor\.museum','labour\.museum','lahppi\.no','lajolla\.museum','lakas\.hu','lanarb\.se','lanbib\.se','lancashire\.museum','land\.ru','landes\.museum','langevag\.no','lans\.museum','lapy\.pl','laquila\.it','lardal\.no','larsson\.museum','larvik\.no','laspezia\.it','latina\.it','lavagis\.no','lavangen\.no','law\.pro','law\.za','lc\.it','le\.it','leangaviika\.no','leasing\.aero','lebesby\.no','lebork\.pl','lecce\.it','lecco\.it','legnica\.pl','leikanger\.no','leirfjord\.no','leirvik\.no','leka\.no','leksvik\.no','lel\.br','lenvik\.no','lerdal\.no','lesja\.no','levanger\.no','lewismiller\.museum','lezajsk\.pl','lg\.jp','lg\.ua','li\.it','lib\.ee','lier\.no','lierne\.no','lillehammer\.no','lillesand\.no','limanowa\.pl','limewebs\.com','lincoln\.museum','lindas\.no','lindesnes\.no','linz\.museum','lipetsk\.ru','livejournal\.com','living\.museum','livinghistory\.museum','livorno\.it','ln\.cn','lo\.it','loabat\.no','localhistory\.museum','lodi\.it','lodingen\.no','lodz\.pl','logistics\.aero','lom\.no','lomza\.pl','london\.museum','loppa\.no','lorenskog\.no','losangeles\.museum','loten\.no','louvre\.museum','lowicz\.pl','loyalist\.museum','lt\.it','ltd\.cy','ltd\.gg','ltd\.gi','ltd\.je','ltd\.lk','ltd\.uk','lu\.it','lubin\.pl','lublin\.pl','lucca\.it','lucerne\.museum','lugansk\.ua','lukow\.pl','lund\.no','lunner\.no','luroy\.no','luster\.no','lutsk\.ua','luxembourg\.museum','luzern\.museum','lviv\.ua','lyngdal\.no','lyngen\.no','m\.bg','m\.se','ma\.us','macerata\.it','mad\.museum','madrid\.museum','magadan\.ru','magazine\.aero','magnitka\.ru','mail\.pl','mail\.ru','mail15\.su','mail2k\.ru','mail333\.su','maintenance\.aero','malatvuopmi\.no','malbork\.pl','mallorca\.museum','malopolska\.pl','malselv\.no','malvik\.no','manchester\.museum','mandal\.no','mansion\.museum','mansions\.museum','mantova\.it','manx\.museum','maori\.nz','marburg\.museum','mari-el\.ru','mari\.ru','marine\.ru','maritime\.museum','maritimo\.museum','marker\.no','marketplace\.aero','marnardal\.no','maryland\.museum','marylhurst\.museum','masfjorden\.no','masoy\.no','massa-carrara\.it','massacarrara\.it','mat\.br','matera\.it','matsuyama\.jp','matta-varjjat\.no','mazowsze\.pl','mazury\.pl','mb\.ca','mbone\.pl','mc\.it','md\.ci','md\.us','me\.it','me\.uk','me\.us','mecon\.ar','med\.br','med\.ec','med\.ee','med\.ht','med\.ly','med\.om','med\.pa','med\.pl','med\.pro','med\.sa','med\.sd','medecin\.fr','medecin\.km','media\.aero','media\.hu','media\.museum','media\.pl','medical\.museum','medizinhistorisches\.museum','meeres\.museum','meland\.no','meldal\.no','melhus\.no','meloy\.no','memorial\.museum','meraker\.no','mesaverde\.museum','messina\.it','mi\.it','mi\.th','mi\.us','miasta\.pl','michigan\.museum','microlight\.aero','midatlantic\.museum','midsund\.no','midtre-gauldal\.no','mie\.jp','mielec\.pl','mielno\.pl','mil\.ac','mil\.ae','mil\.am','mil\.ar','mil\.az','mil\.ba','mil\.bd','mil\.bo','mil\.br','mil\.by','mil\.cn','mil\.co','mil\.do','mil\.ec','mil\.eg','mil\.er','mil\.fj','mil\.ge','mil\.gh','mil\.gt','mil\.gu','mil\.hn','mil\.id','mil\.in','mil\.io','mil\.iq','mil\.jo','mil\.kg','mil\.kh','mil\.km','mil\.kr','mil\.kw','mil\.kz','mil\.lb','mil\.lt','mil\.lu','mil\.lv','mil\.mg','mil\.mv','mil\.my','mil\.no','mil\.np','mil\.nz','mil\.om','mil\.pe','mil\.ph','mil\.pl','mil\.ru','mil\.rw','mil\.se','mil\.sh','mil\.sk','mil\.st','mil\.sy','mil\.tj','mil\.tm','mil\.to','mil\.tr','mil\.tw','mil\.uk','mil\.uy','mil\.vc','mil\.ve','mil\.ye','mil\.za','milan\.it','milano\.it','military\.museum','mill\.museum','mincom\.tn','mine\.nu','miners\.museum','mining\.museum','minnesota\.museum','missile\.museum','missoula\.museum','miyagi\.jp','miyazaki\.jp','mjondalen\.no','mk\.ua','mn\.it','mn\.us','mo-i-rana\.no','mo\.cn','mo\.it','mo\.us','moareke\.no','mob\.nr','mobi\.gp','mobi\.na','mobi\.tt','mobil\.nr','mobile\.nr','mod\.gi','mod\.om','mod\.uk','modalen\.no','modelling\.aero','modena\.it','modern\.museum','modum\.no','molde\.no','moma\.museum','money\.museum','monmouth\.museum','monticello\.museum','montreal\.museum','monza\.it','mooo\.com','mordovia\.ru','moscow\.museum','mosjoen\.no','moskenes\.no','mosreg\.ru','moss\.no','mosvik\.no','motorcycle\.museum','mr\.no','mragowo\.pl','ms\.it','ms\.kr','ms\.us','msk\.ru','mt\.it','mt\.us','muenchen\.museum','muenster\.museum','muf\.mobi','mulhouse\.museum','muncie\.museum','muni\.il','muosat\.no','murmansk\.ru','mus\.br','museet\.museum','museum\.mn','museum\.mv','museum\.mw','museum\.no','museum\.om','museum\.tt','museumcenter\.museum','museumvereniging\.museum','music\.mobi','music\.museum','mx\.na','mx\.tc','mydyndns\.org','mytis\.ru','myvnc\.com','n\.bg','n\.se','na\.by','na\.it','naamesjevuemie\.no','nacion\.ar','nagano\.jp','nagasaki\.jp','nagoya\.jp','nakhodka\.ru','naklo\.pl','nalchik\.ru','namdalseid\.no','name\.ae','name\.az','name\.cy','name\.et','name\.fj','name\.hr','name\.jo','name\.mk','name\.mv','name\.my','name\.na','name\.pr','name\.tj','name\.tr','name\.tt','name\.vn','namsos\.no','namsskogan\.no','nannestad\.no','naples\.it','napoli\.it','nara\.jp','narod\.ru','naroy\.no','narviika\.no','narvik\.no','nat\.tn','national-library-scotland\.uk','national\.museum','nationalfirearms\.museum','nationalheritage\.museum','nativeamerican\.museum','naturalhistory\.museum','naturalhistorymuseum\.museum','naturalsciences\.museum','naturbruksgymn\.se','nature\.museum','naturhistorisches\.museum','natuurwetenschappen\.museum','naumburg\.museum','naustdal\.no','naval\.museum','navigation\.aero','navuotna\.no','navy\.mil','nb\.ca','nc\.us','nd\.us','ne\.jp','ne\.ke','ne\.kr','ne\.pw','ne\.tz','ne\.ug','ne\.us','nebraska\.museum','nedre-eiker\.no','nel\.uk','neostrada\.pl','nesna\.no','nesodden\.no','nesoddtangen\.no','nesseby\.no','nesset\.no','net\.ac','net\.ae','net\.af','net\.ag','net\.ai','net\.al','net\.am','net\.an','net\.ar','net\.au','net\.az','net\.ba','net\.bb','net\.bd','net\.bh','net\.bm','net\.bn','net\.bo','net\.br','net\.bs','net\.bt','net\.bz','net\.cd','net\.ch','net\.ci','net\.ck','net\.cm','net\.cn','net\.co','net\.cu','net\.cy','net\.dm','net\.do','net\.dz','net\.ec','net\.eg','net\.er','net\.et','net\.fj','net\.fk','net\.ge','net\.gg','net\.gn','net\.gp','net\.gr','net\.gt','net\.gu','net\.gy','net\.hk','net\.hn','net\.ht','net\.id','net\.il','net\.im','net\.in','net\.io','net\.iq','net\.ir','net\.is','net\.je','net\.jm','net\.jo','net\.jp','net\.kg','net\.kh','net\.ki','net\.kn','net\.kw','net\.ky','net\.kz','net\.la','net\.lb','net\.lc','net\.li','net\.lk','net\.lr','net\.lu','net\.lv','net\.ly','net\.ma','net\.me','net\.mk','net\.ml','net\.mm','net\.mo','net\.mp','net\.ms','net\.mt','net\.mu','net\.mv','net\.mw','net\.mx','net\.my','net\.na','net\.nc','net\.nf','net\.ng','net\.ni','net\.np','net\.nr','net\.nz','net\.om','net\.pa','net\.pe','net\.pg','net\.ph','net\.pk','net\.pl','net\.pn','net\.pr','net\.ps','net\.pt','net\.py','net\.qa','net\.ru','net\.rw','net\.sa','net\.sb','net\.sc','net\.sd','net\.sg','net\.sh','net\.sl','net\.st','net\.sy','net\.tc','net\.tf','net\.th','net\.tj','net\.tm','net\.tn','net\.to','net\.tr','net\.tt','net\.tv','net\.tw','net\.ua','net\.uk','net\.uy','net\.uz','net\.vc','net\.ve','net\.vi','net\.vn','net\.vu','net\.ws','net\.ye','net\.za','net\.zm','netau\.net','netfirms\.com','netsolhost\.com','neues\.museum','new\.ke','newhampshire\.museum','newjersey\.museum','newmail\.ru','newmexico\.museum','newport\.museum','news\.hu','newspaper\.museum','newyork\.museum','nextmail\.ru','nf\.ca','ngo\.lk','ngo\.ph','ngo\.pl','ngo\.za','nh\.us','nhs\.uk','nic\.ar','nic\.im','nic\.in','nic\.tt','nic\.uk','niepce\.museum','nieruchomosci\.pl','nightmail\.ru','niigata\.jp','nikolaev\.ua','ning\.com','nissedal\.no','nittedal\.no','nj\.us','nkz\.ru','nl\.ca','nl\.no','nls\.uk','nm\.cn','nm\.ru','nm\.us','nnov\.ru','no-ip\.biz','no-ip\.ca','no-ip\.com','no-ip\.info','no-ip\.net','no-ip\.org','no\.com','no\.it','no\.tc','noads\.biz','nom\.ad','nom\.ag','nom\.br','nom\.co','nom\.es','nom\.fk','nom\.fr','nom\.km','nom\.mg','nom\.ni','nom\.pa','nom\.pe','nom\.pl','nom\.re','nom\.ro','nom\.sh','nom\.ve','nom\.za','nome\.pt','nord-aurdal\.no','nord-fron\.no','nord-odal\.no','norddal\.no','nordkapp\.no','nordre-land\.no','nordreisa\.no','nore-og-uvdal\.no','norfolk\.museum','norilsk\.ru','north\.museum','not\.br','notaires\.fr','notaires\.km','notlong\.com','notodden\.no','notteroy\.no','nov\.ru','novara\.it','novosibirsk\.ru','nowaruda\.pl','nrw\.museum','ns\.ca','nsk\.ru','nsn\.us','nsw\.au','nt\.au','nt\.ca','nt\.no','nt\.ro','ntr\.br','nu\.ca','nu\.it','nuernberg\.museum','nui\.hu','nuoro\.it','nuremberg\.museum','nv\.us','nx\.cn','ny\.us','nyc\.museum','nyny\.museum','nysa\.pl','o\.bg','o\.se','oceanographic\.museum','oceanographique\.museum','od\.ua','odda\.no','odessa\.ua','odo\.br','of\.no','off\.ai','og\.ao','oh\.us','oita\.jp','ok\.us','okayama\.jp','okinawa\.jp','oksnes\.no','ol\.no','olawa\.pl','olecko\.pl','olkusz\.pl','olsztyn\.pl','omaha\.museum','omasvuotna\.no','omsk\.ru','on\.ca','one\.pl','online\.museum','onmbl\.com','ontario\.museum','openair\.museum','opoczno\.pl','opole\.pl','oppdal\.no','oppegard\.no','or\.at','or\.bi','or\.ci','or\.cr','or\.id','or\.it','or\.jp','or\.ke','or\.kr','or\.mu','or\.na','or\.pw','or\.th','or\.tz','or\.ug','or\.us','oregon\.museum','oregontrail\.museum','orenburg\.ru','org\.ac','org\.ae','org\.af','org\.ag','org\.ai','org\.al','org\.am','org\.an','org\.ar','org\.au','org\.az','org\.ba','org\.bb','org\.bd','org\.bh','org\.bi','org\.bm','org\.bn','org\.bo','org\.br','org\.bs','org\.bt','org\.bw','org\.bz','org\.cd','org\.ch','org\.ci','org\.ck','org\.cn','org\.co','org\.cu','org\.cy','org\.dm','org\.do','org\.dz','org\.ec','org\.ee','org\.eg','org\.er','org\.es','org\.et','org\.fj','org\.fk','org\.ge','org\.gg','org\.gh','org\.gi','org\.gn','org\.gp','org\.gr','org\.gt','org\.gu','org\.hk','org\.hn','org\.ht','org\.hu','org\.il','org\.im','org\.in','org\.io','org\.iq','org\.ir','org\.is','org\.je','org\.jm','org\.jo','org\.jp','org\.kg','org\.kh','org\.ki','org\.km','org\.kn','org\.kw','org\.ky','org\.kz','org\.la','org\.lb','org\.lc','org\.li','org\.lk','org\.lr','org\.ls','org\.lu','org\.lv','org\.ly','org\.ma','org\.me','org\.mg','org\.mk','org\.ml','org\.mm','org\.mn','org\.mo','org\.mp','org\.mt','org\.mu','org\.mv','org\.mw','org\.mx','org\.my','org\.na','org\.nc','org\.ng','org\.ni','org\.np','org\.nr','org\.nz','org\.om','org\.pa','org\.pe','org\.pf','org\.ph','org\.pk','org\.pl','org\.pn','org\.pr','org\.ps','org\.pt','org\.py','org\.qa','org\.ro','org\.rs','org\.ru','org\.rw','org\.sa','org\.sb','org\.sc','org\.sd','org\.se','org\.sg','org\.sh','org\.sl','org\.st','org\.sv','org\.sy','org\.sz','org\.tj','org\.tm','org\.tn','org\.to','org\.tr','org\.tt','org\.tv','org\.tw','org\.ua','org\.uk','org\.uy','org\.uz','org\.vc','org\.ve','org\.vi','org\.vn','org\.vu','org\.ws','org\.ye','org\.yu','org\.za','org\.zm','org\.zw','orge\.pl','oristano\.it','orkanger\.no','orkdal\.no','orland\.no','orskog\.no','orsta\.no','oryol\.ru','osa\.pl','osaka\.jp','osen\.no','oskol\.ru','oslo\.no','osoyro\.no','osteroy\.no','ostre-toten\.no','ostroda\.pl','ostroleka\.pl','ostrowiec\.pl','ostrowwlkp\.pl','otago\.museum','otc\.au','other\.nf','overhalla\.no','ovh\.net','ovre-eiker\.no','oxford\.museum','oyer\.no','oygarden\.no','oystre-slidre\.no','oz\.au','p\.bg','p\.se','pa\.it','pa\.us','pacific\.museum','paderborn\.museum','padova\.it','padua\.it','page\.tl','palace\.museum','palana\.ru','paleo\.museum','palermo\.it','palmsprings\.museum','panama\.museum','parachuting\.aero','paragliding\.aero','paris\.museum','parliament\.cy','parliament\.uk','parma\.it','parti\.se','pasadena\.museum','passenger-association\.aero','pavia\.it','pb\.ao','pc\.it','pc\.pl','pd\.it','pe\.ca','pe\.it','pe\.kr','penza\.ru','per\.kh','per\.la','per\.nf','per\.sg','perm\.ru','perso\.ht','perso\.tc','perso\.tn','perugia\.it','pesaro-urbino\.it','pesarourbino\.it','pescara\.it','pg\.it','ph\.tc','pharmacien\.fr','pharmaciens\.km','pharmacy\.museum','philadelphia\.museum','philadelphiaarea\.museum','philately\.museum','phoenix\.museum','photography\.museum','pi\.it','piacenza\.it','pila\.pl','pilot\.aero','pilots\.museum','pisa\.it','pisem\.su','pistoia\.it','pisz\.pl','pittsburgh\.museum','pl\.tc','pl\.tf','pl\.ua','planetarium\.museum','plantation\.museum','plants\.museum','plaza\.museum','plc\.ly','plc\.uk','plo\.ps','pn\.it','po\.it','pochta\.com','pochta\.ru','pochtamt\.ru','podhale\.pl','podlasie\.pl','pol\.dz','pol\.ht','pol\.tr','police\.uk','polkowice\.pl','poltava\.ua','pomorskie\.pl','pomorze\.pl','pop3\.ru','populus\.ch','pordenone\.it','porsanger\.no','porsangu\.no','porsgrunn\.no','port\.fr','portal\.museum','portland\.museum','portlligat\.museum','posts-and-telecommunications\.museum','potenza\.it','powiat\.pl','poznan\.pl','pp\.az','pp\.ru','pp\.se','pp\.ua','ppg\.br','pr\.it','pr\.us','prato\.it','prd\.fr','prd\.km','prd\.mg','preservation\.museum','presidio\.museum','press\.aero','press\.cy','press\.ma','press\.museum','press\.se','presse\.ci','presse\.fr','presse\.km','pri\.ee','principe\.st','priv\.at','priv\.hu','priv\.me','priv\.no','priv\.pl','pro\.ae','pro\.az','pro\.br','pro\.cy','pro\.ec','pro\.fj','pro\.ht','pro\.mv','pro\.na','pro\.om','pro\.pr','pro\.tc','pro\.tt','pro\.vn','proboards\.com','prochowice\.pl','production\.aero','prof\.pr','project\.museum','promocion\.ar','prserv\.net','pruszkow\.pl','przeworsk\.pl','psc\.br','psi\.br','pskov\.ru','pt\.it','ptz\.ru','pu\.it','pub\.sa','publ\.pt','public\.museum','pubol\.museum','pulawy\.pl','pv\.it','pvt\.ge','pyatigorsk\.ru','pz\.it','q\.bg','qc\.ca','qc\.com','qh\.cn','qld\.au','qsl\.br','quebec\.museum','r\.bg','r\.se','ra\.it','rade\.no','radikal\.ru','radom\.pl','radoy\.no','ragusa\.it','rahkkeravju\.no','raholt\.no','railroad\.museum','railway\.museum','raisa\.no','rakkestad\.no','ralingen\.no','rana\.no','randaberg\.no','rauma\.no','ravenna\.it','rawa-maz\.pl','rbcmail\.ru','rc\.it','re\.it','re\.kr','realestate\.pl','rec\.br','rec\.co','rec\.nf','rec\.ro','rec\.ve','recreation\.aero','red\.sv','redirectme\.net','reggio-calabria\.it','reggio-emilia\.it','reggiocalabria\.it','reggioemilia\.it','reklam\.hu','rel\.ht','rel\.pl','rendalen\.no','rennebu\.no','rennesoy\.no','repbody\.aero','republika\.pl','res\.aero','res\.in','research\.aero','research\.museum','resistance\.museum','retina\.ar','rg\.it','ri\.it','ri\.us','rieti\.it','riik\.ee','rimini\.it','rindal\.no','ringebu\.no','ringerike\.no','ringsaker\.no','riodejaneiro\.museum','risor\.no','rissa\.no','rl\.no','rm\.it','rm\.ru','rn\.it','rnd\.ru','rnrt\.tn','rns\.tn','rnu\.tn','ro\.im','ro\.it','roan\.no','rochester\.museum','rockart\.museum','rodoy\.no','rollag\.no','roma\.it','roma\.museum','rome\.it','romsa\.no','romskog\.no','roros\.no','rost\.no','rotorcraft\.aero','rovigo\.it','rovno\.ua','royken\.no','royrvik\.no','rs\.ba','ru\.com','ru\.tc','ru\.tf','rubtsovsk\.ru','ruovat\.no','russia\.museum','rv\.ua','ryazan\.ru','rybnik\.pl','rygge\.no','rzeszow\.pl','s\.bg','s\.se','sa\.au','sa\.com','sa\.cr','sa\.it','safety\.aero','saga\.jp','saintlouis\.museum','saitama\.jp','sakhalin\.ru','salangen\.no','salat\.no','salem\.museum','salerno\.it','saltdal\.no','salvadordali\.museum','salzburg\.museum','samara\.ru','samnanger\.no','sandefjord\.no','sandiego\.museum','sandnes\.no','sandnessjoen\.no','sandoy\.no','sanfrancisco\.museum','sanok\.pl','santabarbara\.museum','santacruz\.museum','santafe\.museum','saotome\.st','sapo\.pt','sapporo\.jp','saratov\.ru','sark\.gg','sarpsborg\.no','saskatchewan\.museum','sassari\.it','satx\.museum','sauda\.no','sauherad\.no','savannahga\.museum','savona\.it','sc\.cn','sc\.ke','sc\.kr','sc\.ug','sc\.us','sch\.ae','sch\.gg','sch\.id','sch\.ir','sch\.je','sch\.jo','sch\.lk','sch\.ly','sch\.ng','sch\.om','sch\.sa','sch\.sd','sch\.uk','sch\.zm','schlesisches\.museum','schoenbrunn\.museum','schokoladen\.museum','school\.fj','school\.museum','school\.na','school\.nz','school\.za','schweiz\.museum','sci\.eg','science-fiction\.museum','science\.museum','scienceandhistory\.museum','scienceandindustry\.museum','sciencecenter\.museum','sciencecenters\.museum','sciencehistory\.museum','sciences\.museum','sciencesnaturelles\.museum','scientist\.aero','scotland\.museum','sd\.cn','sd\.us','se\.com','se\.net','se\.tc','se\.tt','seaport\.museum','sebastopol\.ua','sec\.ps','sejny\.pl','sel\.no','selbu\.no','selfip\.com','selfip\.net','selje\.no','seljord\.no','sendai\.jp','seoul\.kr','servebbs\.com','serveftp\.com','services\.aero','settlement\.museum','settlers\.museum','sex\.hu','sex\.pl','sf\.no','sg\.tf','sh\.cn','sharepoint\.com','shell\.museum','sherbrooke\.museum','shiga\.jp','shimane\.jp','shizuoka\.jp','shop\.co','shop\.ht','shop\.hu','shop\.ms','shop\.pl','shop\.tc','show\.aero','shutterfly\.com','si\.it','sibenik\.museum','siellak\.no','siena\.it','sigdal\.no','siljan\.no','silk\.museum','simbirsk\.ru','siracusa\.it','sirdal\.no','site\.tc','site90\.net','sk\.ca','skanit\.no','skanland\.no','skaun\.no','skedsmo\.no','skedsmokorset\.no','ski\.museum','ski\.no','skien\.no','skierva\.no','skiptvet\.no','skjak\.no','skjervoy\.no','sklep\.pl','skoczow\.pl','skodje\.no','skole\.museum','skydiving\.aero','slask\.pl','slattum\.no','sld\.cu','sld\.do','sld\.pa','slg\.br','slupsk\.pl','smola\.no','smolensk\.ru','smtp\.ru','sn\.cn','snaase\.no','snasa\.no','snillfjord\.no','snoasa\.no','snz\.ru','so\.it','soc\.lk','societe\.st','society\.museum','software\.aero','sogndal\.no','sogne\.no','sokndal\.no','sol\.ru','sola\.no','sologne\.museum','solund\.no','somna\.no','sondre-land\.no','sondrio\.it','songdalen\.no','sopot\.pl','sor-aurdal\.no','sor-fron\.no','sor-odal\.no','sor-varanger\.no','sorfold\.no','soros\.al','sorreisa\.no','sortland\.no','sorum\.no','sos\.pl','sosblog\.com','sosnowiec\.pl','soundandvision\.museum','southcarolina\.museum','southwest\.museum','sp\.it','sp\.ru','space\.museum','spb\.ru','spjelkavik\.no','sport\.hu','spy\.museum','spydeberg\.no','square\.museum','sr\.it','srv\.br','ss\.it','sshn\.se','st\.no','stadt\.museum','stalbans\.museum','stalowa-wola\.pl','stange\.no','starachowice\.pl','stargard\.pl','starnberg\.museum','stat\.no','state\.museum','stateofdelaware\.museum','stathelle\.no','station\.museum','stavanger\.no','stavern\.no','stavropol\.ru','steam\.museum','steiermark\.museum','steigen\.no','steinkjer\.no','stjohn\.museum','stjordal\.no','stjordalshalsen\.no','stockholm\.museum','stokke\.no','stor-elvdal\.no','stord\.no','stordal\.no','store\.co','store\.nf','store\.ro','store\.st','store\.ve','storfjord\.no','stpetersburg\.museum','strand\.no','stranda\.no','stryn\.no','student\.aero','stuttgart\.museum','stv\.ru','suedtirol\.it','suisse\.museum','sula\.no','suldal\.no','suli\.hu','sumy\.ua','sund\.no','sunndal\.no','surgeonshall\.museum','surgut\.ru','surnadal\.no','surrey\.museum','suwalki\.pl','sv\.it','svalbard\.no','sveio\.no','svelvik\.no','svizzera\.museum','sweden\.museum','swidnica\.pl','swiebodzin\.pl','swinoujscie\.pl','sx\.cn','sydney\.museum','sykkylven\.no','syzran\.ru','szczecin\.pl','szczytno\.pl','szex\.hu','szkola\.pl','szm\.com','t\.bg','t\.se','t3\.to','t35\.com','t35\.me','t35\.net','ta\.it','takamatsu\.jp','tambov\.ru','tana\.no','tananger\.no','tank\.museum','taranto\.it','targi\.pl','tarnobrzeg\.pl','tas\.au','tatarstan\.ru','taxi\.aero','tcm\.museum','te\.it','te\.ua','tec\.ve','technology\.museum','tel\.no','tel\.nr','tel\.tr','telecom\.na','telekommunikation\.museum','telememo\.au','television\.museum','teramo\.it','terni\.it','ternopil\.ua','test\.ru','texas\.museum','textile\.museum','tgory\.pl','th\.tc','theater\.museum','time\.museum','time\.no','timekeeping\.museum','tingvoll\.no','tinn\.no','tirana\.al','tj\.cn','tjeldsund\.no','tjome\.no','tld\.am','tld\.tc','tld\.tl','tlf\.nr','tm\.cy','tm\.fr','tm\.hu','tm\.km','tm\.mc','tm\.mg','tm\.mt','tm\.no','tm\.pl','tm\.ro','tm\.se','tm\.za','tmp\.br','tn\.it','tn\.us','to\.it','tochigi\.jp','tokke\.no','tokushima\.jp','tokyo\.jp','tolga\.no','tom\.ru','tomsk\.ru','tonsberg\.no','topology\.museum','torino\.it','torino\.museum','torsken\.no','torun\.pl','tottori\.jp','touch\.museum','tourism\.pl','tourism\.tn','town\.museum','toyama\.jp','tozsde\.hu','tp\.it','tr\.it','tr\.no','trader\.aero','trading\.aero','trainer\.aero','trana\.no','tranby\.no','tranoy\.no','transport\.museum','trapani\.it','travel\.pl','travel\.tt','trd\.br','tree\.museum','trentino\.it','trento\.it','treviso\.it','trieste\.it','tripod\.com','troandin\.no','trogstad\.no','trolley\.museum','tromsa\.no','tromso\.no','trondheim\.no','trust\.museum','trustee\.museum','trysil\.no','ts\.it','tsaritsyn\.ru','tsk\.ru','tula\.ru','tumblr\.com','tur\.ar','tur\.br','tur\.cu','turek\.pl','turen\.tn','turin\.it','turystyka\.pl','tuva\.ru','tv\.bo','tv\.br','tv\.it','tv\.na','tv\.sd','tvedestrand\.no','tver\.ru','tw\.cn','tx\.us','tychy\.pl','tydal\.no','tynset\.no','tysfjord\.no','tysnes\.no','tysvar\.no','tyumen\.ru','u\.bg','u\.se','ua\.tc','uba\.ar','ucoz\.com','ucoz\.net','ucoz\.ru','ud\.it','udine\.it','udm\.ru','udmurtia\.ru','ueuo\.com','uhren\.museum','uk\.com','uk\.mn','uk\.net','uk\.pn','uk\.tc','uk\.to','uk\.tt','ulan-ude\.ru','ullensaker\.no','ullensvang\.no','ulm\.museum','ulsan\.kr','ulvik\.no','unam\.na','unbi\.ba','unblog\.fr','undersea\.museum','uni\.cc','uni\.me','uni7\.net','union\.aero','uniti\.al','university\.museum','unjarga\.no','unlugar\.com','unsa\.ba','upt\.al','uri\.arpa','url\.st','urn\.arpa','us\.com','us\.ms','us\.na','us\.org','us\.tc','us\.tf','us\.to','us\.tt','usa\.cc','usa\.museum','usantiques\.museum','usarts\.museum','uscountryestate\.museum','usculture\.museum','usdecorativearts\.museum','usenet\.pl','usgarden\.museum','ushistory\.museum','ushuaia\.museum','uslivinghistory\.museum','ustka\.pl','ut\.us','utah\.museum','utazas\.hu','utsira\.no','utsunomiya\.jp','uu\.mt','uvic\.museum','uy\.com','uz\.ua','uzhgorod\.ua','v\.bg','va\.it','va\.no','va\.us','vaapste\.no','vacau\.com','vadso\.no','vaga\.no','vagan\.no','vagsoy\.no','vaksdal\.no','valle\.no','valley\.museum','vang\.no','vantaa\.museum','vanylven\.no','vardo\.no','varese\.it','varggat\.no','varoy\.no','vatican\.va','vb\.it','vc\.it','vdonsk\.ru','ve\.it','vefsn\.no','vega\.no','vegarshei\.no','venezia\.it','venice\.it','vennesla\.no','verbania\.it','vercelli\.it','verdal\.no','verona\.it','verran\.no','versailles\.museum','vestby\.no','vestnes\.no','vestre-slidre\.no','vestre-toten\.no','vestvagoy\.no','vet\.br','veterinaire\.fr','veterinaire\.km','vevelstad\.no','vf\.no','vgs\.no','vi\.it','vi\.us','vibo-valentia\.it','vibovalentia\.it','vic\.au','vicenza\.it','video\.hu','vik\.no','viking\.museum','vikna\.no','village\.museum','vindafjord\.no','vinnica\.ua','virginia\.museum','virtual\.museum','virtuel\.museum','viterbo\.it','vlaanderen\.museum','vladikavkaz\.ru','vladimir\.ru','vladivostok\.ru','vlog\.br','vn\.ua','voagat\.no','volda\.no','volgograd\.ru','volkenkunde\.museum','vologda\.ru','voronezh\.ru','voss\.no','vossevangen\.no','vr\.it','vrn\.ru','vt\.it','vt\.us','vv\.cc','vv\.it','vyatka\.ru','w\.bg','w\.se','wa\.au','wa\.us','wakayama\.jp','walbrzych\.pl','wales\.museum','wallonie\.museum','war\.museum','warmia\.pl','warszawa\.pl','washingtondc\.museum','watch-and-clock\.museum','watchandclock\.museum','waw\.pl','we\.bs','weather\.mobi','web-soft\.ru','web\.co','web\.do','web\.id','web\.lk','web\.nf','web\.pk','web\.tj','web\.tr','web\.ve','web\.za','webcindario\.com','webgarden\.es','webs\.com','weebly\.com','wegrow\.pl','western\.museum','westfalen\.museum','whaling\.museum','whsites\.net','wi\.us','wielun\.pl','wiki\.br','wildlife\.museum','williamsburg\.museum','windmill\.museum','wlocl\.pl','wloclawek\.pl','wodzislaw\.pl','wolomin\.pl','wordpress\.com','workinggroup\.aero','works\.aero','workshop\.museum','wroc\.pl','wroclaw\.pl','ws\.na','wv\.us','www\.ro','wy\.us','wz\.cz','x\.bg','x\.se','xanga\.com','xf\.cz','xj\.cn','xn--aroport-bya\.ci','xn--drbak-wua\.no','xn--leagaviika-52b\.no','xn--ostery-fya\.no','xn--tysvr-vra\.no','xn--unjrga-rta\.no','xn--vegrshei-c0a\.no','xorg\.pl','xz\.cn','y\.bg','y\.se','yakutia\.ru','yamagata\.jp','yamaguchi\.jp','yamal\.ru','yamanashi\.jp','yaroslavl\.ru','yekaterinburg\.ru','yk\.ca','yn\.cn','yokohama\.jp','york\.museum','yorkshire\.museum','yosemite\.museum','youth\.museum','yuzhno-sakhalinsk\.ru','z\.bg','z\.se','z8\.ru','za\.com','za\.net','za\.org','za\.pl','zachpomor\.pl','zagan\.pl','zakopane\.pl','zaporizhzhe\.ua','zapto\.org','zarow\.pl','ze\.cx','zgora\.pl','zgorzelec\.pl','zgrad\.ru','zhitomir\.ua','zj\.cn','zlg\.br','zmail\.ru','zone\.be','zoological\.museum','zoology\.museum','zp\.ua','zt\.ua',];
|;
$tldlist = $ubp->cachetlds($tldfiles);
$got = Dumper($tldlist);
chkstr($got,$exp);

# test 8	check domain resolution
my @urls = qw(
	www.bizsystems.com
	sex.xxx.qld.au
	www.is.a.mess.com.au.pn
	hello.goodbye.com
	a.host.named.yahoo.com
);

$exp = q|
bizsystems.com for www.bizsystems.com
xxx.qld.au for sex.xxx.qld.au
mess.com.au.pn for www.is.a.mess.com.au.pn
goodbye.com for hello.goodbye.com
a.host.named.yahoo.com is whitelisted
|;
$got = "\n";

foreach my $host (@urls) {
  my $domain = $ubp->urbldomain($host);
  unless ($domain) {
    $got .= "$host is whitelisted\n";
  } else {
    $got .= "$domain for $host\n";
  }
}

chkstr($got,$exp);
