use strict;
use warnings;
package Math::HexGrid;
$Math::HexGrid::VERSION = '0.01';
# ABSTRACT: Math::HexGrid - create hex coordinate grids

use Math::HexGrid::Hex;
use List::Util qw/min max/;




sub new_hexagon
{
  my ($class, $radius) = @_;

  my %map;
  for (my $q = - $radius; $q <= $radius; $q++)
  {
    my $r1 = max(-$radius, -$q - $radius);
    my $r2 = min($radius, -$q + $radius);

    for (my $r = $r1; $r <= $r2; $r++)
    {
      $map{"$q$r"} = Math::HexGrid::Hex->new($q, $r);
    }
  }

  bless {
    map => \%map,
  }, $class;
}


sub get_hex
{
  my ($self, $q, $r) = @_;
  $self->{map}{"$q$r"};
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Math::HexGrid - Math::HexGrid - create hex coordinate grids

=head1 VERSION

version 0.01

=head1 DESCRIPTION

This module is for creating hex grids of L<Math::HexGrid::Grid> objects. For
now it only supports hexagonally-shaped grids. It supports both cube and
axial (trapezoidal) coordinate systems.

=head1 METHODS

=head2 new_hexagon ($radius)

Constructs a new hexagonally-shaped grid of size C<$radius>.

=head2 get_hex ($q, $r)

Returns the hex at location C<$q> and C<$r>.

=head1 SEE ALSO

This code was helped by Amit Patel's L<articles|http://www.redblobgames.com/grids/hexagons/> on hexagonal grids.

=head1 AUTHOR

David Farrell <dfarrell@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by David Farrell.

This is free software, licensed under:

  The (two-clause) FreeBSD License

=cut
