#ifndef OPENMW_COMPONENTS_NIFBULLET_BULLETNIFLOADER_HPP
#define OPENMW_COMPONENTS_NIFBULLET_BULLETNIFLOADER_HPP

#include <cassert>
#include <string>
#include <set>
#include <map>

#include <osg/Matrixf>
#include <osg/BoundingBox>
#include <osg/ref_ptr>
#include <osg/Referenced>

#include <BulletCollision/CollisionShapes/btCompoundShape.h>

#include <components/debug/debuglog.hpp>
#include <components/nif/niffile.hpp>
#include <components/resource/bulletshape.hpp>

class btTriangleMesh;
class btCompoundShape;
class btCollisionShape;

namespace Nif
{
    class Node;
    struct Transformation;
    struct NiTriShape;
    struct NiTriStrips;
}

namespace NifBullet
{

/**
*Load bulletShape from NIF files.
*/
class BulletNifLoader
{
public:
    void warn(const std::string &msg)
    {
        Log(Debug::Warning) << "NIFLoader: Warn:" << msg;
    }

    void fail(const std::string &msg)
    {
        Log(Debug::Error) << "NIFLoader: Fail: "<< msg;
        abort();
    }

    osg::ref_ptr<Resource::BulletShape> load(const Nif::File& file);

private:
    bool findBoundingBox(const Nif::Node* node);

    void handleNode(const std::string& fileName, Nif::Node const *node, int flags, bool isCollisionNode,
                    bool isAnimated=false, bool autogenerated=false, bool avoid=false);

    bool hasAutoGeneratedCollision(const Nif::Node *rootNode);

    void handleNiTriShape(const Nif::Node *nifNode, int flags, const osg::Matrixf& transform, bool isAnimated, bool avoid);

    std::unique_ptr<btCompoundShape> mCompoundShape;

    std::unique_ptr<btTriangleMesh> mStaticMesh;

    std::unique_ptr<btTriangleMesh> mAvoidStaticMesh;

    osg::ref_ptr<Resource::BulletShape> mShape;
};

}

#endif
