#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Mark of the Ninja expansions:
# - Special Edition
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250615.3

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='mark-of-the-ninja'
GAME_NAME='Mark of the Ninja'

EXPANSION_ID='special-edition'
EXPANSION_NAME='Special Edition'

## This Linux build is no longer available for sale from GOG,
## they now only sell a Windows build.
ARCHIVE_BASE_0_NAME='gog_mark_of_the_ninja_special_edition_dlc_2.0.0.4.sh'
ARCHIVE_BASE_0_MD5='bbce70b80932ec9c14fbedf0b6b33eb1'
ARCHIVE_BASE_0_SIZE='250000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.4'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN64_FILES='
ninja-bin64'
CONTENT_GAME_BIN32_FILES='
ninja-bin32'
CONTENT_GAME_DATA_FILES='
dlc'

APP_MAIN_EXE_BIN64='bin/ninja-bin64'
APP_MAIN_EXE_BIN32='bin/ninja-bin32'
## Work around a rendering failure with sdl12-compat.
## cf. https://github.com/libsdl-org/sdl12-compat/issues/315
APP_MAIN_PRERUN='
# Work around a rendering failure with sdl12-compat.
# cf. https://github.com/libsdl-org/sdl12-compat/issues/315
export SDL12COMPAT_OPENGL_SCALING=0
'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_PROVIDES="
$GAME_ID"
PKG_BIN64_PROVIDES="$PKG_BIN_PROVIDES"
PKG_BIN32_PROVIDES="$PKG_BIN_PROVIDES"
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_PARENT_LIBS
PKG_PARENT_DATA
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
libSDL-1.2.so.0
libstdc++.so.6'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID="${GAME_ID}-${EXPANSION_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_PARENT_LIBS_ID="${GAME_ID}-libs"
PKG_PARENT_DATA_ID="${GAME_ID}-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Write launchers

## Run the game binary from its parent directory.
game_exec_line() {
	cat <<- EOF
	cd bin
	./$(basename "$(application_exe 'APP_MAIN')") "\$@"
	EOF
}

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
