       SUBROUTINE SST004(WIN,WOUT,NSIZIN,NSIZOT,ISCR,SPTYPE)
C
C THIS ROUTINE ACCEPTS A SYMMETRY PACKED FOUR-INDEX LIST AND RETURNS
C   THE SAME LIST BUT WITH AN ALTERNATIVE SCHEME FOR SYMMETRY PACKING.
C
C THE LIST (A,B;I,J) IS PRESUMED TO BE PACKED AB-IJ.  THIS ROUTINE RETURNS
C   THE LIST PACKED IN TWO POSSIBLE WAYS (SEE BELOW).
C
C INPUT: 
C           WIN  - THE SYMMETRY PACKED AB-IJ LIST.
C         NSIZIN - THE TOTAL SIZE OF THE SYM. PACKED INPUT VECTOR.
C         NSIZOT - THE TOTAL SIZE OF THE SYM. PACKED OUTPUT VECTOR.
C         SPTYPE - THE SPIN TYPE FOR THE INPUT LIST
C
C                        'AAAA' FOR (AI-BJ) RETURNED
C                        'BBBB' FOR (ai-bj) RETURNED
C
C OUTPUT: 
C          WOUT  - THE SYMMETRY PACKED AI-BJ or ai-bj LIST.
C       
C SCRATCH:
C         ISCR   - SCRATCH AREA TO HOLD THE SYMMETRY VECTORS AND INVERSE
C                   SYMMETRY VECTORS WHICH ARE NEEDED. 
C                   (SIZE: NVRT*NVRT+NOCC*NOCC+NVRT*NOCC)
C         
CEND
      IMPLICIT INTEGER (A-Z)
      DOUBLE PRECISION WIN(NSIZIN),WOUT(NSIZOT)
      CHARACTER*4 SPTYPE
      DIMENSION ISCR(1)
C
      COMMON/SYM/POP(8,2),VRT(8,2),NT(2),NFMI(2),NFEA(2)
C
      IRREPX=1
C
      IF(SPTYPE.EQ.'AAAA')THEN
       CALL SSTGEN(WIN,WOUT,NSIZIN,VRT(1,1),VRT(1,1),POP(1,1),
     &             POP(1,1),ISCR,IRREPX,'1324')
      ELSEIF(SPTYPE.EQ.'BBBB')THEN
       CALL SSTGEN(WIN,WOUT,NSIZIN,VRT(1,2),VRT(1,2),POP(1,2),
     &             POP(1,2),ISCR,IRREPX,'1324')
      ENDIF
C
      RETURN
      END
