; A variant of write-objects-to-file for use during make-event, etc.
;
; Copyright (C) 2017-2024 Kestrel Institute
;
; License: A 3-clause BSD license. See the file books/3BSD-mod.txt.
;
; Author: Eric Smith (eric.smith@kestrel.edu)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "ACL2")

(include-book "write-objects-to-channel")
(local (include-book "kestrel/utilities/state" :dir :system))
(local (include-book "open-output-channel-bang"))

(defttag file-io!)

(local (in-theory (disable open-output-channel-p1 put-global)))

;; Writes the OBJECTS to FILENAME, each on a separate line, overwriting the
;; previous contents of FILENAME.  Returns (mv erp state).  The ttag is needed
;; because this calls open-output-channel!, but that makes this version usable
;; during make-event expansion, clause-processors, etc.
(defund write-objects-to-file! (objects filename ctx state)
  (declare (xargs :stobjs state
                  :guard (and (true-listp objects)
                              (stringp filename))))
  (mv-let (channel state)
    (open-output-channel! filename :object state)
    (if (not channel)
        (prog2$ (er hard? ctx "Unable to open file ~s0 for :object output." filename)
                (mv t state))
      (pprogn (write-objects-to-channel objects channel state)
              (close-output-channel channel state)
              (mv nil state)))))
