/*
 * Copyright (C) 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.clearsilver.jsilver.functions.operators;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.functions.NonEscapingFunction;
import com.google.clearsilver.jsilver.values.Value;
import static com.google.clearsilver.jsilver.values.Value.literalValue;

/**
 * X + Y (string).
 */
public class AddFunction extends NonEscapingFunction {

  public Value execute(Value... args) {
    Value left = args[0];
    Value right = args[1];
    EscapeMode mode = EscapeMode.combineModes(left.getEscapeMode(), right.getEscapeMode());
    return literalValue(left.asString() + right.asString(), mode, left.isPartiallyEscaped()
        || right.isPartiallyEscaped());
  }

}
