IF (LIBPCRE_INCLUDE_DIR AND LIBPCRE_LIBRARIES)
   # in cache already
   SET(LibPcre_FIND_QUIETLY TRUE)
ENDIF (LIBPCRE_INCLUDE_DIR AND LIBPCRE_LIBRARIES)

IF (NOT WIN32)
   # use pkg-config to get the directories and then use these values
   # in the FIND_PATH() and FIND_LIBRARY() calls
   INCLUDE(UsePkgConfig)
   PKGCONFIG(libpcre LIBPCRE_INCLUDES LIBPCRE_LIB_DIR LIBPCRE_LDFLAGS LIBPCRE_CFLAGS)
   SET(LIBPCRE_DEFINITIONS ${LIBPCRE_CFLAGS})
ENDIF (NOT WIN32)

FIND_PATH(LIBPCRE_INCLUDE_DIR pcre.h
          PATHS ${LIBPCRE_INCLUDES})

FIND_LIBRARY(LIBPCRE_LIBRARIES
             NAMES pcre libpcre
             PATHS ${LIBPCRE_LIB_DIR})

IF (LIBPCRE_INCLUDE_DIR AND LIBPCRE_LIBRARIES)
   SET(LIBPCRE_FOUND TRUE)
ELSE (LIBPCRE_INCLUDE_DIR AND LIBPCRE_LIBRARIES)
   SET(LIBPCRE_FOUND FALSE)
ENDIF (LIBPCRE_INCLUDE_DIR AND LIBPCRE_LIBRARIES)

IF (LIBPCRE_FOUND)
   IF (NOT LibPcre_FIND_QUIETLY)
      MESSAGE(STATUS "Found LibPcre: ${LIBPCRE_LIBRARIES}")
   ENDIF (NOT LibPcre_FIND_QUIETLY)
ELSE (LIBPCRE_FOUND)
   IF (LibPcre_FIND_REQUIRED)
      MESSAGE(SEND_ERROR "Could NOT find LibPcre")
   ENDIF (LibPcre_FIND_REQUIRED)
ENDIF (LIBPCRE_FOUND)

MARK_AS_ADVANCED(LIBPCRE_INCLUDE_DIR LIBPCRE_LIBRARIES)

