// SPDX-License-Identifier: LGPL-3.0-or-later
// Author: Kristian Lytje

#pragma once

namespace ausaxs::constants::radius::vdw {
    // Rowland 1996, crystallographic
    constexpr double H  = 1.1;

    // wikipedia, likely also crystallographic
    constexpr double He = 1.4;
    constexpr double Ne = 1.54;
    constexpr double Ar = 1.88;

    // Batsanov, 2001, equilibrium values
    constexpr double Li = 2.63;
    constexpr double Be = 2.23;
    constexpr double B  = 2.05;
    constexpr double C  = 1.96;
    constexpr double N  = 1.79;
    constexpr double O  = 1.71;
    constexpr double F  = 1.65;

    constexpr double Na = 2.77;
    constexpr double Mg = 2.42;
    constexpr double Al = 2.40;
    constexpr double Si = 2.26;
    constexpr double P  = 2.14;
    constexpr double S  = 2.06;
    constexpr double Cl = 2.05;

    constexpr double K  = 3.02;
    constexpr double Ca = 2.78;
    constexpr double Sc = 2.62;
    constexpr double Ti = 2.44;
    constexpr double V  = 2.27;
    constexpr double Cr = 2.23;
    constexpr double Mn = 2.25;
    constexpr double Fe = 2.27;
    constexpr double Co = 2.25;
    constexpr double Ni = 2.23;
    constexpr double Cu = 2.27;
    constexpr double Zn = 2.24;
    constexpr double Ga = 2.41;
    constexpr double Ge = 2.32;
    constexpr double As = 2.25;
    constexpr double Se = 2.18;
    constexpr double Br = 2.10;

    constexpr double Rb = 3.15;
    constexpr double Sr = 2.94;
    constexpr double Y  = 2.71;
    constexpr double Zr = 2.57;
    constexpr double Nb = 2.46;
    constexpr double Mo = 2.39;
    constexpr double Tc = 2.37;
    constexpr double Ru = 2.37;
    constexpr double Rh = 2.32;
    constexpr double Pd = 2.35;
    constexpr double Ag = 2.37;
    constexpr double Cd = 2.37;
    constexpr double In = 2.53;
    constexpr double Sn = 2.46;
    constexpr double Sb = 2.41;
    constexpr double Te = 2.36;
    constexpr double I  = 2.22;

    constexpr double Cs = 3.30;
    constexpr double Ba = 3.05;
    constexpr double La = 2.81;
    constexpr double Hf = 2.52;
    constexpr double Ta = 2.42;
    constexpr double W  = 2.36;
    constexpr double Re = 2.35;
    constexpr double Os = 2.33;
    constexpr double Ir = 2.34;
    constexpr double Pt = 2.37;
    constexpr double Au = 2.41;
    constexpr double Hg = 2.25;
    constexpr double Tl = 2.53;
    constexpr double Pb = 2.53;
    constexpr double Bi = 3.52;
}