package org.broadinstitute.barclay.argparser;

import java.lang.annotation.*;

/**
 * Used to annotate @Arguments of a CommandLineProgram that are a workflow input, used by auto WDL generation.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@Documented
public @interface WorkflowInput {
    /**
     * @return array of names of required companion files that should travel with this resource. For example,
     * a (Genomic Reference) FASTA file might have two associated companion files that must be supplied as
     * arguments to the workflow, so the WorkflowInput would use the attribute values:
     *
     * @WorkflowInput(requiredCompanions = {"referenceDictionary", "referenceIndex" }
     *
     * The associated workflow and workflow input JSON (but not the task) generated by Barclay will contain two
     * additional required parameters with these names, allowing callers to optionally provide name values for
     * the companion files.
     */
    String[] requiredCompanions() default {};

    /**
     * @return array of names of optional companion files that should travel with this resource. For example,
     * a (Genomic Reference) FASTA file might have two associated companion files that can optionally be supplied as
     * arguments to the workflow, so the WorkflowOutput would use the attribute values:
     *
     * @WorkflowInput(optionalCompanions = {"referenceDictionary", "referenceIndex" }
     *
     * The associated workflow and workflow input JSON (but not the task) generated by Barclay will contain two
     * additional optional parameters with these names, allowing callers to optionally provide name values for
     * the companion files.
     */
    String[] optionalCompanions() default {};

    /**
     * Return a boolean specifying whether this input should have the "localization optional" attribute set.
     * Defaults to false. A value of true should only be used for input arguments on tools that can handle
     * inputs on non-local/remote file systems. This attribute is propagated to this input's companion files.
     */
    boolean localizationOptional() default false;
}
