/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc.pict;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Rect
extends Rectangle2D {
    public int top = 0;
    public int left = 0;
    public int bottom = 0;
    public int right = 0;

    public static Rect read(DataInputStream in) throws IOException {
        Rect r = new Rect();
        r.top = in.readShort();
        r.left = in.readShort();
        r.bottom = in.readShort();
        r.right = in.readShort();
        return r;
    }

    public Rect() {
        this.left = 0;
        this.top = 0;
        this.right = 0;
        this.bottom = 0;
    }

    public Rect(int x, int y, int width, int height) {
        this.left = x;
        this.top = y;
        this.right = x + width;
        this.bottom = y + height;
    }

    public Rect(Rectangle r) {
        this.left = r.x;
        this.top = r.y;
        this.right = r.x + r.width;
        this.bottom = r.y + r.height;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.top);
        out.writeShort(this.left);
        out.writeShort(this.bottom);
        out.writeShort(this.right);
    }

    public Rectangle toRectangle() {
        return new Rectangle(this.left, this.top, this.right - this.left, this.bottom - this.top);
    }

    public String toString() {
        return String.valueOf(this.left) + "," + this.top + "," + this.right + "," + this.bottom;
    }

    @Override
    public Rectangle2D createIntersection(Rectangle2D r) {
        return this.toRectangle().createIntersection(r);
    }

    @Override
    public Rectangle2D createUnion(Rectangle2D r) {
        return this.toRectangle().createUnion(r);
    }

    @Override
    public int outcode(double x, double y) {
        return this.toRectangle().outcode(x, y);
    }

    @Override
    public void setRect(double x, double y, double w, double h) {
        this.top = (int)y;
        this.left = (int)x;
        this.bottom = (int)(y + h);
        this.right = (int)(x + w);
    }

    @Override
    public double getHeight() {
        return this.bottom - this.top;
    }

    @Override
    public double getWidth() {
        return this.right - this.left;
    }

    @Override
    public double getX() {
        return this.left;
    }

    @Override
    public double getY() {
        return this.top;
    }

    @Override
    public boolean isEmpty() {
        return this.left == this.right || this.top == this.bottom;
    }
}

