LOCAL_PATH := $(call my-dir)/../..
include $(CLEAR_VARS)
LOCAL_CFLAGS    := -std=c99 -W -Wall -pthread -pipe $(COPT)
LOCAL_MODULE    := civetweb
LOCAL_SRC_FILES := src/main.c src/civetweb.c
LOCAL_C_INCLUDES := $(LOCAL_PATH)/include $(LOCAL_PATH)/src/third_party

ifdef WITH_DEBUG
  LOCAL_CFLAGS += -DDEBUG
  NDK_DEBUG = 1
else
  LOCAL_CFLAGS += -DNDEBUG
  NDK_DEBUG = 0
endif

ifdef WITH_ALL
  WITH_WEBSOCKET = 1
  WITH_IPV6 = 1
  WITH_LUA = 1
  WITH_DUKTAPE = 1
  WITH_SERVER_STATS = 1
  WITH_ZLIB = 1
  WITH_EXPERIMENTAL = 1
  #WITH_CPP is not defined, ALL means only real features, not wrappers
endif

# Use Lua?
ifdef WITH_LUA_VERSION
  WITH_LUA = 1
endif

ifdef WITH_LUA_SHARED
  WITH_LUA = 1
endif

ifdef WITH_LUAJIT_SHARED
  WITH_LUA_SHARED = 1
  WITH_LUA = 1
  WITH_LUA_VERSION = 501
endif

ifdef WITH_LUA
  LOCAL_CFLAGS += -DLUA_USE_C89 -D"getlocaledecpoint() ('.');"
  include $(LOCAL_PATH)/resources/Makefile.in-lua
endif

# Use Duktape?
ifdef WITH_SSJS
  WITH_DUKTAPE = 1
endif

ifdef WITH_DUKTAPE_VERSION
  WITH_DUKTAPE = 1
endif

ifdef WITH_DUKTAPE_SHARED
  WITH_DUKTAPE = 1
endif

# Use zlib?
ifdef WITH_COMPRESSION
  WITH_ZLIB = 1
endif

ifdef WITH_ZLIB
  LOCAL_LDLIBS += -lz
  LOCAL_CFLAGS += -DUSE_ZLIB
endif

# Other features
ifdef WITH_EXPERIMENTAL
  LOCAL_CFLAGS += -DMG_EXPERIMENTAL_INTERFACES
endif

ifdef WITH_IPV6
  LOCAL_CFLAGS += -DUSE_IPV6
endif

ifdef WITH_WEBSOCKET
  LOCAL_CFLAGS += -DUSE_WEBSOCKET
endif
ifdef WITH_WEBSOCKETS
  LOCAL_CFLAGS += -DUSE_WEBSOCKET
endif

ifdef WITH_SERVER_STAT
  LOCAL_CFLAGS += -DUSE_SERVER_STATS
endif
ifdef WITH_SERVER_STATS
  LOCAL_CFLAGS += -DUSE_SERVER_STATS
endif

ifdef WITH_DAEMONIZE
  PID_FILE ?= /var/run/$(LOCAL_MODULE).pid
  LOCAL_CFLAGS += -DDAEMONIZE -DPID_FILE=\"$(PID_FILE)\"
endif

# File names
ifdef CONFIG_FILE
  LOCAL_CFLAGS += -DCONFIG_FILE=\"$(CONFIG_FILE)\"
endif

ifdef CONFIG_FILE2
  LOCAL_CFLAGS += -DCONFIG_FILE2=\"$(CONFIG_FILE2)\"
endif

ifdef SSL_LIB
  LOCAL_CFLAGS += -DSSL_LIB=\"$(SSL_LIB)\"
endif

ifdef CRYPTO_LIB
  LOCAL_CFLAGS += -DCRYPTO_LIB=\"$(CRYPTO_LIB)\"
endif

ifdef WITH_LUAJIT_SHARED
  LOCAL_LDLIBS += -lluajit-5.1
else
ifdef WITH_LUA_SHARED
  LOCAL_LDLIBS += $(LUA_SHARED_LIB_FLAG)
endif
endif

LOCAL_SRC_FILES += $(OBJECTS:.o=.c)
LOCAL_CFLAGS += $(CFLAGS)
LOCAL_C_INCLUDES += $(LOCAL_PATH)/$(LUA_DIR)

ifdef WITH_DUKTAPE
  include $(LOCAL_PATH)/resources/Makefile.in-duktape
  LOCAL_CFLAGS += -DUSE_DUKTAPE
ifdef WITH_DUKTAPE_SHARED
  LOCAL_LDLIBS += $(DUKTAPE_SHARED_LIB_FLAG)
endif
endif

LOCAL_SRC_FILES += $(DUKTAPE_SOURCES)
LOCAL_C_INCLUDES += $(LOCAL_PATH)/$(DUKTAPE_DIR)
OBJECTS =
CFLAGS =
SOURCE_DIRS =
BUILD_DIRS =

include $(BUILD_EXECUTABLE)
